/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.Property;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Shape {
    public ArrayList<Property<?>> properties = new ArrayList();
    public IShapeBuffer buffer;
    private int nBlocks = 0;
    public boolean visible = true;
    public boolean ready = false;
    public boolean vertexBufferUnpacked = false;
    public Basepos basepos = null;
    public float colourShapeR = 1.0f;
    public float colourShapeG = 1.0f;
    public float colourShapeB = 1.0f;
    public float colourShapeA = 0.5f;
    public float colourBaseposR = 1.0f;
    public float colourBaseposG = 0.0f;
    public float colourBaseposB = 0.0f;
    public float colourBaseposA = 0.5f;
    protected double baseposOffsetX = 0.0;
    protected double baseposOffsetY = 0.0;
    protected double baseposOffsetZ = 0.0;
    private static ExecutorService executor = Executors.newCachedThreadPool();
    public ReentrantLock lock = new ReentrantLock();
    private Future<?> future = null;
    private long completedAt = 0L;
    public boolean error = false;

    protected abstract void updateShape(IShapeBuffer var1) throws Exception;

    public abstract String getTranslationKey();

    public void update() {
        if (((Boolean)BuildGuide.config.asyncEnabled.value).booleanValue()) {
            this.ready = false;
            this.vertexBufferUnpacked = false;
            if (this.future != null && !this.future.isDone() && !this.future.isCancelled()) {
                this.future.cancel(true);
            }
            if (this.buffer != null) {
                this.buffer.close();
            }
            this.future = executor.submit(() -> {
                try {
                    this.lock.lock();
                    this.ready = false;
                    this.vertexBufferUnpacked = false;
                    this.error = false;
                    this.doUpdate();
                }
                catch (InterruptedException e) {
                    this.error = true;
                }
                catch (Exception e) {
                    this.error = true;
                    e.printStackTrace();
                }
                finally {
                    this.completedAt = System.currentTimeMillis();
                    this.ready = true;
                    this.lock.unlock();
                }
            });
        } else {
            this.ready = false;
            this.vertexBufferUnpacked = false;
            this.error = false;
            if (this.buffer != null) {
                this.buffer.close();
            }
            try {
                this.doUpdate();
            }
            catch (InterruptedException e) {
                this.error = true;
            }
            catch (Exception e) {
                this.error = true;
                e.printStackTrace();
            }
            finally {
                this.completedAt = System.currentTimeMillis();
                this.ready = true;
            }
        }
    }

    private void doUpdate() throws Exception {
        this.nBlocks = 0;
        long t = System.currentTimeMillis();
        this.buffer = BuildGuide.shapeHandler.newBuffer();
        this.buffer.setColour((int)(255.0f * this.colourShapeR), (int)(255.0f * this.colourShapeG), (int)(255.0f * this.colourShapeB), (int)(255.0f * this.colourShapeA));
        this.updateShape(this.buffer);
        this.buffer.setColour((int)(255.0f * this.colourBaseposR), (int)(255.0f * this.colourBaseposG), (int)(255.0f * this.colourBaseposB), (int)(255.0f * this.colourBaseposA));
        this.addCube(this.buffer, 0.4 + this.baseposOffsetX, 0.4 + this.baseposOffsetY, 0.4 + this.baseposOffsetZ, 0.2);
        if (((Boolean)BuildGuide.config.debugGenerationTimingsEnabled.value).booleanValue()) {
            BuildGuide.logHandler.debugOrHigher("Shape " + this.getTranslatedName() + " has been generated in " + (System.currentTimeMillis() - t) + " ms");
        }
    }

    protected void addCube(IShapeBuffer buffer, double x, double y, double z, double s) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        buffer.pushVertex(x, y, z);
        buffer.pushVertex(x, y, z + s);
        buffer.pushVertex(x, y + s, z + s);
        buffer.pushVertex(x, y + s, z);
        buffer.pushVertex(x, y, z);
        buffer.pushVertex(x + s, y, z);
        buffer.pushVertex(x + s, y, z + s);
        buffer.pushVertex(x, y, z + s);
        buffer.pushVertex(x, y, z);
        buffer.pushVertex(x, y + s, z);
        buffer.pushVertex(x + s, y + s, z);
        buffer.pushVertex(x + s, y, z);
        buffer.pushVertex(x + s, y, z);
        buffer.pushVertex(x + s, y + s, z);
        buffer.pushVertex(x + s, y + s, z + s);
        buffer.pushVertex(x + s, y, z + s);
        buffer.pushVertex(x, y + s, z);
        buffer.pushVertex(x, y + s, z + s);
        buffer.pushVertex(x + s, y + s, z + s);
        buffer.pushVertex(x + s, y + s, z);
        buffer.pushVertex(x, y, z + s);
        buffer.pushVertex(x + s, y, z + s);
        buffer.pushVertex(x + s, y + s, z + s);
        buffer.pushVertex(x, y + s, z + s);
    }

    protected void addShapeCube(IShapeBuffer buffer, int x, int y, int z) throws InterruptedException {
        this.addCube(buffer, (double)x + 0.2, (double)y + 0.2, (double)z + 0.2, 0.6);
        ++this.nBlocks;
    }

    protected void setBaseposOffset(double dx, double dy, double dz) {
        this.baseposOffsetX = dx;
        this.baseposOffsetY = dy;
        this.baseposOffsetZ = dz;
    }

    public void onSelectedInGUI() {
        for (int i = 0; i < this.properties.size(); ++i) {
            this.properties.get(i).setSlot(i);
            this.properties.get(i).onSelectedInGUI();
        }
    }

    public void onDeselectedInGUI() {
        for (Property<?> p : this.properties) {
            p.onDeselectedInGUI();
        }
    }

    public String getTranslatedName() {
        return BuildGuide.screenHandler.translate(this.getTranslationKey());
    }

    public int getNumberOfBlocks() {
        if (!this.ready) {
            return 0;
        }
        return this.nBlocks;
    }

    public long getHowLongAgoCompletedMillis() {
        return System.currentTimeMillis() - this.completedAt;
    }

    public void resetBasepos() {
        this.basepos = BuildGuide.shapeHandler.getPlayerPosition();
    }

    public void setBasepos(int x, int y, int z) {
        this.basepos = new Basepos(x, y, z);
    }

    public void shiftBasepos(int dx, int dy, int dz) {
        this.basepos.x += dx;
        this.basepos.y += dy;
        this.basepos.z += dz;
    }

    public static class Basepos {
        public int x;
        public int y;
        public int z;

        public Basepos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

