/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.screen;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.Property;
import brentmaas.buildguide.common.screen.PropertyScreen;
import brentmaas.buildguide.common.screen.ShapelistScreen;
import brentmaas.buildguide.common.screen.VisualisationScreen;
import brentmaas.buildguide.common.screen.widget.IButton;
import brentmaas.buildguide.common.screen.widget.ITextField;
import brentmaas.buildguide.common.shape.Shape;

public class BuildGuideScreen
extends PropertyScreen {
    private String titleGlobalProperties = BuildGuide.screenHandler.translate("screen.buildguide.globalproperties");
    private String titleShapeProperties = BuildGuide.screenHandler.translate("screen.buildguide.shapeproperties");
    private String titleBasepos = BuildGuide.screenHandler.translate("screen.buildguide.basepos");
    private String titleNumberOfBlocks = BuildGuide.screenHandler.translate("screen.buildguide.numberofblocks");
    private String textShape = BuildGuide.screenHandler.translate("screen.buildguide.shape");
    private static final String[] progressIndicator = new String[]{"|", "/", "-", "\\"};
    private IButton buttonClose;
    private IButton buttonShapePrevious = BuildGuide.widgetHandler.createButton(60, 25, 20, 20, "<-", () -> this.updateShape(-1));
    private IButton buttonShapeNext = BuildGuide.widgetHandler.createButton(140, 25, 20, 20, "->", () -> this.updateShape(1));
    private IButton buttonShapeList = BuildGuide.widgetHandler.createButton(140, 25, 20, 20, "...", () -> BuildGuide.screenHandler.showScreen(new ShapelistScreen()));
    private IButton buttonBasepos = BuildGuide.widgetHandler.createButton(185, 25, 120, 20, BuildGuide.screenHandler.translate("screen.buildguide.setbasepos"), () -> this.setBasepos());
    private IButton buttonVisualisation = BuildGuide.widgetHandler.createButton(0, 65, 160, 20, BuildGuide.screenHandler.translate("screen.buildguide.visualisation"), () -> BuildGuide.screenHandler.showScreen(new VisualisationScreen()));
    private IButton buttonBaseposXDecrease = BuildGuide.widgetHandler.createButton(185, 45, 20, 20, "-", () -> this.shiftBasepos(-1, 0, 0));
    private IButton buttonBaseposXIncrease = BuildGuide.widgetHandler.createButton(285, 45, 20, 20, "+", () -> this.shiftBasepos(1, 0, 0));
    private IButton buttonBaseposYDecrease = BuildGuide.widgetHandler.createButton(185, 65, 20, 20, "-", () -> this.shiftBasepos(0, -1, 0));
    private IButton buttonBaseposYIncrease = BuildGuide.widgetHandler.createButton(285, 65, 20, 20, "+", () -> this.shiftBasepos(0, 1, 0));
    private IButton buttonBaseposZDecrease = BuildGuide.widgetHandler.createButton(185, 85, 20, 20, "-", () -> this.shiftBasepos(0, 0, -1));
    private IButton buttonBaseposZIncrease = BuildGuide.widgetHandler.createButton(285, 85, 20, 20, "+", () -> this.shiftBasepos(0, 0, 1));
    private ITextField textFieldX = BuildGuide.widgetHandler.createTextField(205, 45, 50, 20, "");
    private ITextField textFieldY = BuildGuide.widgetHandler.createTextField(205, 65, 50, 20, "");
    private ITextField textFieldZ = BuildGuide.widgetHandler.createTextField(205, 85, 50, 20, "");
    private IButton buttonSetX = BuildGuide.widgetHandler.createButton(255, 45, 30, 20, BuildGuide.screenHandler.translate("screen.buildguide.set"), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldX.getTextValue());
            BuildGuide.stateManager.getState().setBaseposX(newval);
        }
        catch (NumberFormatException e) {
            this.textFieldX.setTextColour(0xFF0000);
        }
    });
    private IButton buttonSetY = BuildGuide.widgetHandler.createButton(255, 65, 30, 20, BuildGuide.screenHandler.translate("screen.buildguide.set"), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldY.getTextValue());
            BuildGuide.stateManager.getState().setBaseposY(newval);
        }
        catch (NumberFormatException e) {
            this.textFieldY.setTextColour(0xFF0000);
        }
    });
    private IButton buttonSetZ = BuildGuide.widgetHandler.createButton(255, 85, 30, 20, BuildGuide.screenHandler.translate("screen.buildguide.set"), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldZ.getTextValue());
            BuildGuide.stateManager.getState().setBaseposZ(newval);
        }
        catch (NumberFormatException e) {
            this.textFieldZ.setTextColour(0xFF0000);
        }
    });

    public BuildGuideScreen() {
        super("screen.buildguide.title");
    }

    @Override
    public void init() {
        super.init();
        BuildGuide.stateManager.getState().initCheck();
        this.buttonClose = BuildGuide.widgetHandler.createButton(this.wrapper.getWidth() - 20, 0, 20, 20, "X", () -> BuildGuide.screenHandler.showScreen(null));
        if (!BuildGuide.stateManager.getState().isShapeAvailable()) {
            this.buttonBasepos.setActive(false);
            this.buttonBaseposXDecrease.setActive(false);
            this.buttonBaseposXIncrease.setActive(false);
            this.buttonBaseposYDecrease.setActive(false);
            this.buttonBaseposYIncrease.setActive(false);
            this.buttonBaseposZDecrease.setActive(false);
            this.buttonBaseposZIncrease.setActive(false);
            this.buttonSetX.setActive(false);
            this.buttonSetY.setActive(false);
            this.buttonSetZ.setActive(false);
        }
        this.addButton(this.buttonClose);
        if (!((Boolean)BuildGuide.stateManager.getState().propertyAdvancedMode.value).booleanValue()) {
            this.addButton(this.buttonShapePrevious);
            this.addButton(this.buttonShapeNext);
        } else {
            this.addButton(this.buttonShapeList);
        }
        this.addButton(this.buttonBasepos);
        this.addButton(this.buttonVisualisation);
        this.addButton(this.buttonBaseposXDecrease);
        this.addButton(this.buttonBaseposXIncrease);
        this.addButton(this.buttonBaseposYDecrease);
        this.addButton(this.buttonBaseposYIncrease);
        this.addButton(this.buttonBaseposZDecrease);
        this.addButton(this.buttonBaseposZIncrease);
        this.addButton(this.buttonSetX);
        this.addButton(this.buttonSetY);
        this.addButton(this.buttonSetZ);
        this.textFieldX.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShape().basepos.x : "-"));
        this.textFieldX.setTextColour(0xFFFFFF);
        this.textFieldY.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShape().basepos.y : "-"));
        this.textFieldY.setTextColour(0xFFFFFF);
        this.textFieldZ.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShape().basepos.z : "-"));
        this.textFieldZ.setTextColour(0xFFFFFF);
        this.addTextField(this.textFieldX);
        this.addTextField(this.textFieldY);
        this.addTextField(this.textFieldZ);
        BuildGuide.stateManager.getState().propertyEnable.setSlot(-4);
        this.addProperty(BuildGuide.stateManager.getState().propertyEnable);
        BuildGuide.stateManager.getState().propertyAdvancedMode.setSlot(-2);
        this.addProperty(BuildGuide.stateManager.getState().propertyAdvancedMode);
        if (((Boolean)BuildGuide.stateManager.getState().propertyAdvancedMode.value).booleanValue()) {
            for (Shape s : BuildGuide.stateManager.getState().advancedModeShapes) {
                for (Property<?> p : s.properties) {
                    this.addProperty(p);
                }
                s.onDeselectedInGUI();
            }
        } else {
            for (Shape s : BuildGuide.stateManager.getState().simpleModeShapes) {
                for (Property<?> p : s.properties) {
                    this.addProperty(p);
                }
                s.onDeselectedInGUI();
            }
        }
        if (BuildGuide.stateManager.getState().isShapeAvailable()) {
            BuildGuide.stateManager.getState().getCurrentShape().onSelectedInGUI();
        }
    }

    @Override
    public void render() {
        super.render();
        this.drawShadowCentred(this.title, this.wrapper.getWidth() / 2, 5, 0xFFFFFF);
        this.drawShadowCentred(this.titleGlobalProperties, 80, 15, 0xFFFFFF);
        this.drawShadowCentred(this.titleShapeProperties, 80, 115, 0xFFFFFF);
        this.drawShadowCentred(this.titleBasepos, 245, 15, 0xFFFFFF);
        this.drawShadowCentred(this.titleNumberOfBlocks, 355, 15, 0xFFFFFF);
        int n = BuildGuide.stateManager.getState().isShapeAvailable() ? BuildGuide.stateManager.getState().getCurrentShape().getNumberOfBlocks() : 0;
        this.drawShadowCentred("" + n, 355, 30, 0xFFFFFF);
        this.drawShadowCentred("(" + n / 64 + " x 64 + " + n % 64 + ")", 355, 45, 0xFFFFFF);
        int colourFraction = (int)Math.max(Math.min((BuildGuide.stateManager.getState().isShapeAvailable() ? BuildGuide.stateManager.getState().getCurrentShape().getHowLongAgoCompletedMillis() : 2000L) * 255L / 1000L, 255L), 0L);
        Object progressIndicatorPart = "";
        if (BuildGuide.stateManager.getState().isShapeAvailable() && !BuildGuide.stateManager.getState().getCurrentShape().ready) {
            long time = System.currentTimeMillis();
            progressIndicatorPart = " " + progressIndicator[(int)(time / 100L % (long)progressIndicator.length)];
        }
        this.drawShadow(this.textShape, 5, 30, 0xFFFFFF);
        String shapeName = (BuildGuide.stateManager.getState().isShapeAvailable() && !BuildGuide.stateManager.getState().getCurrentShape().visible ? "\u00a7m" : "") + (BuildGuide.stateManager.getState().isShapeAvailable() ? BuildGuide.stateManager.getState().getCurrentShape().getTranslatedName() : BuildGuide.screenHandler.translate("shape.buildguide.none")) + (String)progressIndicatorPart;
        this.drawShadowCentred(shapeName, 110, 30, BuildGuide.stateManager.getState().isShapeAvailable() && BuildGuide.stateManager.getState().getCurrentShape().error ? 0xFF0000 : 65280 + colourFraction * 65537);
        this.drawShadow("X", 170, 50, 0xFFFFFF);
        this.drawShadow("Y", 170, 70, 0xFFFFFF);
        this.drawShadow("Z", 170, 90, 0xFFFFFF);
    }

    private void updateShape(int di) {
        BuildGuide.stateManager.getState().getCurrentShape().onDeselectedInGUI();
        BuildGuide.stateManager.getState().iSimple = Math.floorMod(BuildGuide.stateManager.getState().iSimple + di, BuildGuide.stateManager.getState().simpleModeShapes.length);
        BuildGuide.stateManager.getState().getCurrentShape().onSelectedInGUI();
    }

    private void setBasepos() {
        BuildGuide.stateManager.getState().resetBasepos();
        this.textFieldX.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.x);
        this.textFieldX.setTextColour(0xFFFFFF);
        this.textFieldY.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.y);
        this.textFieldY.setTextColour(0xFFFFFF);
        this.textFieldZ.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.z);
        this.textFieldZ.setTextColour(0xFFFFFF);
    }

    private void shiftBasepos(int dx, int dy, int dz) {
        BuildGuide.stateManager.getState().shiftBasepos(dx, dy, dz);
        if (dx != 0) {
            this.textFieldX.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.x);
            this.textFieldX.setTextColour(0xFFFFFF);
        }
        if (dy != 0) {
            this.textFieldY.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.y);
            this.textFieldY.setTextColour(0xFFFFFF);
        }
        if (dz != 0) {
            this.textFieldZ.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.z);
            this.textFieldZ.setTextColour(0xFFFFFF);
        }
    }
}

