/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.property;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.Property;
import brentmaas.buildguide.common.screen.widget.ITextField;

public class PropertyMinimumInt
extends Property<Integer> {
    private ITextField valueTextField;
    private int minValue;

    public PropertyMinimumInt(int value, String name, Runnable onPress, int minValue) {
        super(value, name);
        this.minValue = minValue;
        this.buttonList.add(BuildGuide.widgetHandler.createButton(90, this.y, 20, 20, "-", () -> {
            if ((Integer)this.value > this.minValue) {
                this.value = (Integer)this.value - 1;
                this.valueTextField.setTextValue("" + this.value);
                this.valueTextField.setTextColour(0xFFFFFF);
                if (onPress != null) {
                    onPress.run();
                }
            }
        }));
        this.buttonList.add(BuildGuide.widgetHandler.createButton(190, this.y, 20, 20, "+", () -> {
            this.value = (Integer)this.value + 1;
            this.valueTextField.setTextValue("" + this.value);
            this.valueTextField.setTextColour(0xFFFFFF);
            if (onPress != null) {
                onPress.run();
            }
        }));
        this.buttonList.add(BuildGuide.widgetHandler.createButton(160, this.y, 30, 20, BuildGuide.screenHandler.translate("screen.buildguide.set"), () -> {
            try {
                int newVal = Integer.parseInt(this.valueTextField.getTextValue());
                if (newVal >= this.minValue) {
                    this.value = newVal;
                    this.valueTextField.setTextColour(0xFFFFFF);
                    if (onPress != null) {
                        onPress.run();
                    }
                } else {
                    this.valueTextField.setTextColour(0xFF0000);
                }
            }
            catch (NumberFormatException e) {
                this.valueTextField.setTextColour(0xFF0000);
            }
        }));
        this.valueTextField = BuildGuide.widgetHandler.createTextField(110, this.y, 50, 20, "");
        this.valueTextField.setTextValue("" + value);
        this.valueTextField.setTextColour(0xFFFFFF);
        this.textFieldList.add(this.valueTextField);
    }

    @Override
    public void setValue(Integer value) {
        if (value >= this.minValue) {
            super.setValue(value);
            this.valueTextField.setTextValue("" + value);
            this.valueTextField.setTextColour(0xFFFFFF);
        }
    }
}

