/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.screen.BuildGuideScreen;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeCircle;
import brentmaas.buildguide.common.shape.ShapeRegistry;
import java.util.ArrayList;

public class State {
    private boolean initialised = false;
    public Shape[] simpleModeShapes;
    public int iSimple = ShapeRegistry.getShapeId(ShapeCircle.class);
    public ArrayList<Shape> advancedModeShapes = new ArrayList();
    public int iAdvanced = 0;
    public int iAdvancedNew = ShapeRegistry.getShapeId(ShapeCircle.class);
    public PropertyBoolean propertyEnable = new PropertyBoolean(false, BuildGuide.screenHandler.translate("screen.buildguide.enable"), null);
    public PropertyBoolean propertyAdvancedMode = new PropertyBoolean(false, BuildGuide.screenHandler.translate("screen.buildguide.advancedmode"), () -> BuildGuide.screenHandler.showScreen(new BuildGuideScreen()));
    public PropertyBoolean propertyAdvancedModeRandomColours;
    public PropertyBoolean propertyDepthTest;

    public State() {
        this.propertyAdvancedModeRandomColours = new PropertyBoolean((Boolean)BuildGuide.config.advancedRandomColorsDefaultEnabled.value, BuildGuide.screenHandler.translate("screen.buildguide.advancedmoderandomcolors"), null);
        this.propertyDepthTest = new PropertyBoolean(true, BuildGuide.screenHandler.translate("screen.buildguide.depthtest"), null);
        ArrayList<String> classIdentifiers = ShapeRegistry.getClassIdentifiers();
        this.simpleModeShapes = new Shape[classIdentifiers.size()];
        for (int i = 0; i < classIdentifiers.size(); ++i) {
            this.simpleModeShapes[i] = ShapeRegistry.getNewInstance(classIdentifiers.get(i));
            this.simpleModeShapes[i].update();
        }
    }

    public Shape getCurrentShape() {
        if (((Boolean)this.propertyAdvancedMode.value).booleanValue()) {
            return this.advancedModeShapes.size() > 0 ? this.advancedModeShapes.get(this.iAdvanced) : null;
        }
        return this.simpleModeShapes[this.iSimple];
    }

    public void initCheck() {
        if (!this.initialised) {
            if (this.simpleModeShapes[0].basepos == null) {
                for (Shape s : this.simpleModeShapes) {
                    s.resetBasepos();
                }
            }
            this.initialised = true;
        }
    }

    public void updateCurrentShape() {
        if (((Boolean)this.propertyAdvancedMode.value).booleanValue()) {
            for (int i = 0; i < this.advancedModeShapes.size(); ++i) {
                this.advancedModeShapes.get(i).update();
            }
        } else {
            this.simpleModeShapes[this.iSimple].update();
        }
    }

    public boolean isShapeAvailable() {
        return (Boolean)this.propertyAdvancedMode.value == false || this.advancedModeShapes.size() > 0;
    }

    public void resetBasepos() {
        if (((Boolean)this.propertyAdvancedMode.value).booleanValue()) {
            this.advancedModeShapes.get(this.iAdvanced).resetBasepos();
        } else {
            for (Shape s : this.simpleModeShapes) {
                s.resetBasepos();
            }
        }
    }

    public void resetBasepos(int advancedModeId) {
        this.advancedModeShapes.get(advancedModeId).resetBasepos();
    }

    public void setBasepos(int x, int y, int z) {
        if (((Boolean)this.propertyAdvancedMode.value).booleanValue()) {
            this.advancedModeShapes.get(this.iAdvanced).setBasepos(x, y, z);
        } else {
            for (Shape s : this.simpleModeShapes) {
                s.setBasepos(x, y, z);
            }
        }
    }

    public void setBaseposX(int x) {
        if (((Boolean)this.propertyAdvancedMode.value).booleanValue()) {
            this.advancedModeShapes.get((int)this.iAdvanced).basepos.x = x;
        } else {
            for (Shape s : this.simpleModeShapes) {
                s.basepos.x = x;
            }
        }
    }

    public void setBaseposY(int y) {
        if (((Boolean)this.propertyAdvancedMode.value).booleanValue()) {
            this.advancedModeShapes.get((int)this.iAdvanced).basepos.y = y;
        } else {
            for (Shape s : this.simpleModeShapes) {
                s.basepos.y = y;
            }
        }
    }

    public void setBaseposZ(int z) {
        if (((Boolean)this.propertyAdvancedMode.value).booleanValue()) {
            this.advancedModeShapes.get((int)this.iAdvanced).basepos.z = z;
        } else {
            for (Shape s : this.simpleModeShapes) {
                s.basepos.z = z;
            }
        }
    }

    public void shiftBasepos(int dx, int dy, int dz) {
        if (((Boolean)this.propertyAdvancedMode.value).booleanValue()) {
            this.advancedModeShapes.get(this.iAdvanced).shiftBasepos(dx, dy, dz);
        } else {
            for (Shape s : this.simpleModeShapes) {
                s.shiftBasepos(dx, dy, dz);
            }
        }
    }

    public void setShapeColour(float r, float g, float b, float a) {
        if (((Boolean)this.propertyAdvancedMode.value).booleanValue()) {
            this.advancedModeShapes.get((int)this.iAdvanced).colourShapeR = r;
            this.advancedModeShapes.get((int)this.iAdvanced).colourShapeG = g;
            this.advancedModeShapes.get((int)this.iAdvanced).colourShapeB = b;
            this.advancedModeShapes.get((int)this.iAdvanced).colourShapeA = a;
            this.advancedModeShapes.get(this.iAdvanced).update();
        } else {
            for (Shape s : this.simpleModeShapes) {
                s.colourShapeR = r;
                s.colourShapeG = g;
                s.colourShapeB = b;
                s.colourShapeA = a;
                s.update();
            }
        }
    }

    public void setBaseposColour(float r, float g, float b, float a) {
        if (((Boolean)this.propertyAdvancedMode.value).booleanValue()) {
            this.advancedModeShapes.get((int)this.iAdvanced).colourBaseposR = r;
            this.advancedModeShapes.get((int)this.iAdvanced).colourBaseposG = g;
            this.advancedModeShapes.get((int)this.iAdvanced).colourBaseposB = b;
            this.advancedModeShapes.get((int)this.iAdvanced).colourBaseposA = a;
            this.advancedModeShapes.get(this.iAdvanced).update();
        } else {
            for (Shape s : this.simpleModeShapes) {
                s.colourBaseposR = r;
                s.colourBaseposG = g;
                s.colourBaseposB = b;
                s.colourBaseposA = a;
                s.update();
            }
        }
    }
}

