/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.thermal;

import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.recipes.RecipeJsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.ItemInputTransformer;
import dev.latvian.mods.kubejs.recipe.ItemOutputTransformer;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.thermal.ThermalRecipeJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class FuelRecipeJS
extends ThermalRecipeJS {
    public final List<Ingredient> inputItems = new ArrayList<Ingredient>(1);
    public final List<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>(0);
    public String inKey = "";

    public void create(RecipeArguments args) {
        this.inKey = "ingredients";
        if (this.inputItems.isEmpty() && this.inputFluids.isEmpty()) {
            throw new RecipeExceptionJS("Thermal recipe can't have no ingredients!");
        }
    }

    public void deserialize() {
        this.inKey = "";
        if (this.json.has("ingredient")) {
            this.inKey = "ingredient";
            RecipeJsonUtils.parseInputs(this.inputItems, this.inputFluids, (JsonElement)this.json.get("ingredient"));
        } else if (this.json.has("ingredients")) {
            this.inKey = "ingredients";
            RecipeJsonUtils.parseInputs(this.inputItems, this.inputFluids, (JsonElement)this.json.get("ingredients"));
        } else if (this.json.has("input")) {
            this.inKey = "input";
            RecipeJsonUtils.parseInputs(this.inputItems, this.inputFluids, (JsonElement)this.json.get("input"));
        } else if (this.json.has("inputs")) {
            this.inKey = "inputs";
            RecipeJsonUtils.parseInputs(this.inputItems, this.inputFluids, (JsonElement)this.json.get("inputs"));
        }
    }

    public void serialize() {
        if (this.serializeInputs) {
            JsonArray in = new JsonArray();
            for (Ingredient ingredient : this.inputItems) {
                in.add(ingredient.m_43942_());
            }
            for (FluidIngredient fluid : this.inputFluids) {
                in.add(fluid.toJson());
            }
            this.json.add(this.inKey, (JsonElement)in);
        }
    }

    public boolean hasInput(IngredientMatch match) {
        for (Ingredient in : this.inputItems) {
            if (!match.contains(in)) continue;
            return true;
        }
        return false;
    }

    public boolean replaceInput(IngredientMatch match, Ingredient with, ItemInputTransformer transformer) {
        boolean changed = false;
        for (int i = 0; i < this.inputItems.size(); ++i) {
            Ingredient in = this.inputItems.get(i);
            if (!match.contains(in)) continue;
            this.inputItems.set(i, transformer.transform((RecipeJS)this, match, in, with));
            changed = true;
        }
        return changed;
    }

    public boolean hasOutput(IngredientMatch match) {
        return false;
    }

    public boolean replaceOutput(IngredientMatch match, ItemStack with, ItemOutputTransformer transformer) {
        return false;
    }
}

