/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.api.event.GatherToolClassesEvent;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.MANAGEMENT, hasSubscriptions=true, antiOverlap={"inventorytweaks"})
public class AutomaticToolRestockModule
extends QuarkModule {
    private static final Map<ToolAction, String> ACTION_TO_CLASS = new HashMap<ToolAction, String>();
    private static final WeakHashMap<Player, Stack<Pair<Integer, Integer>>> replacements;
    public List<Enchantment> importantEnchants = new ArrayList<Enchantment>();
    @Config(name="Important Enchantments", description="Enchantments deemed important enough to have special priority when finding a replacement")
    private List<String> enchantNames = AutomaticToolRestockModule.generateDefaultEnchantmentList();
    @Config(description="Enable replacing your tools with tools of the same type but not the same item")
    private boolean enableLooseMatching = true;
    @Config(description="Enable comparing enchantments to find a replacement")
    private boolean enableEnchantMatching = true;
    @Config
    private boolean unstackablesOnly = false;
    private Object mutex = new Object();

    @Override
    public void configChanged() {
        this.importantEnchants = MiscUtil.massRegistryGet(this.enchantNames, ForgeRegistries.ENCHANTMENTS);
    }

    @SubscribeEvent
    public void onToolBreak(PlayerDestroyItemEvent event) {
        Player player = event.getEntity();
        ItemStack stack = event.getOriginal();
        Item item = stack.m_41720_();
        if (!(player == null || player.f_19853_ == null || player.f_19853_.f_46443_ || stack.m_41619_() || item instanceof ArmorItem || this.unstackablesOnly && stack.m_41753_())) {
            HashSet<String> classes;
            int currSlot = player.m_150109_().f_35977_;
            if (event.getHand() == InteractionHand.OFF_HAND) {
                currSlot = player.m_150109_().m_6643_() - 1;
            }
            List<Enchantment> enchantmentsOnStack = this.getImportantEnchantments(stack);
            Predicate<ItemStack> itemPredicate = other -> other.m_41720_() == item;
            if (!stack.m_41763_()) {
                itemPredicate = itemPredicate.and(other -> other.m_41773_() == stack.m_41773_());
            }
            Predicate<ItemStack> enchantmentPredicate = other -> !new ArrayList(enchantmentsOnStack).retainAll(this.getImportantEnchantments((ItemStack)other));
            if (this.enableEnchantMatching && this.findReplacement(player, currSlot, itemPredicate.and(enchantmentPredicate))) {
                return;
            }
            if (this.findReplacement(player, currSlot, itemPredicate)) {
                return;
            }
            if (this.enableLooseMatching && !(classes = this.getItemClasses(stack)).isEmpty()) {
                Predicate<ItemStack> toolPredicate = other -> {
                    HashSet<String> otherClasses = this.getItemClasses((ItemStack)other);
                    return !otherClasses.isEmpty() && !otherClasses.retainAll(classes);
                };
                if (this.enableEnchantMatching && !enchantmentsOnStack.isEmpty() && this.findReplacement(player, currSlot, toolPredicate.and(enchantmentPredicate))) {
                    return;
                }
                this.findReplacement(player, currSlot, toolPredicate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.f_46443_ && replacements.containsKey(event.player)) {
            Stack<Pair<Integer, Integer>> replacementStack = replacements.get(event.player);
            Object object = this.mutex;
            synchronized (object) {
                while (!replacementStack.isEmpty()) {
                    Pair<Integer, Integer> pair = replacementStack.pop();
                    this.switchItems(event.player, (Integer)pair.getLeft(), (Integer)pair.getRight());
                }
            }
        }
    }

    private HashSet<String> getItemClasses(ItemStack stack) {
        Item item = stack.m_41720_();
        HashSet<String> classes = new HashSet<String>();
        if (item instanceof BowItem) {
            classes.add("bow");
        } else if (item instanceof CrossbowItem) {
            classes.add("crossbow");
        }
        for (ToolAction action : ACTION_TO_CLASS.keySet()) {
            if (!item.canPerformAction(stack, action)) continue;
            classes.add(ACTION_TO_CLASS.get(action));
        }
        GatherToolClassesEvent event = new GatherToolClassesEvent(stack, classes);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findReplacement(Player player, int currSlot, Predicate<ItemStack> match) {
        Object object = this.mutex;
        synchronized (object) {
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack stackAt;
                if (i == currSlot || (stackAt = player.m_150109_().m_8020_(i)).m_41619_() || !match.test(stackAt)) continue;
                this.pushReplace(player, i, currSlot);
                return true;
            }
            return false;
        }
    }

    private void pushReplace(Player player, int slot1, int slot2) {
        if (!replacements.containsKey(player)) {
            replacements.put(player, new Stack());
        }
        replacements.get(player).push((Pair<Integer, Integer>)Pair.of((Object)slot1, (Object)slot2));
    }

    private void switchItems(Player player, int slot1, int slot2) {
        Inventory inventory = player.m_150109_();
        int size = inventory.f_35974_.size();
        if (slot1 >= size || slot2 >= size) {
            return;
        }
        ItemStack stackAtSlot1 = inventory.m_8020_(slot1).m_41777_();
        ItemStack stackAtSlot2 = inventory.m_8020_(slot2).m_41777_();
        inventory.m_6836_(slot2, stackAtSlot1);
        inventory.m_6836_(slot1, stackAtSlot2);
    }

    private List<Enchantment> getImportantEnchantments(ItemStack stack) {
        ArrayList<Enchantment> enchantsOnStack = new ArrayList<Enchantment>();
        for (Enchantment ench : this.importantEnchants) {
            if (EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)stack) <= 0) continue;
            enchantsOnStack.add(ench);
        }
        return enchantsOnStack;
    }

    private static List<String> generateDefaultEnchantmentList() {
        Enchantment[] enchants = new Enchantment[]{Enchantments.f_44985_, Enchantments.f_44987_, Enchantments.f_44952_, Enchantments.f_44953_, Enchantments.f_44982_};
        ArrayList<String> strings = new ArrayList<String>();
        for (Enchantment e : enchants) {
            strings.add(Registry.f_122825_.m_7981_((Object)e).toString());
        }
        return strings;
    }

    static {
        ACTION_TO_CLASS.put(ToolActions.AXE_DIG, "axe");
        ACTION_TO_CLASS.put(ToolActions.HOE_DIG, "hoe");
        ACTION_TO_CLASS.put(ToolActions.SHOVEL_DIG, "shovel");
        ACTION_TO_CLASS.put(ToolActions.PICKAXE_DIG, "pickaxe");
        ACTION_TO_CLASS.put(ToolActions.SWORD_SWEEP, "sword");
        ACTION_TO_CLASS.put(ToolActions.SHEARS_HARVEST, "shears");
        ACTION_TO_CLASS.put(ToolActions.FISHING_ROD_CAST, "fishing_rod");
        replacements = new WeakHashMap();
    }
}

