/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.client.render.be;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import vazkii.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;

public class MatrixEnchantingTableRenderer
implements BlockEntityRenderer<MatrixEnchantingTableBlockEntity> {
    public static final Material TEXTURE_BOOK = EnchantTableRenderer.f_112405_;
    private final BookModel modelBook;

    public MatrixEnchantingTableRenderer(BlockEntityRendererProvider.Context context) {
        this.modelBook = new BookModel(context.m_173582_(ModelLayers.f_171271_));
    }

    public void render(MatrixEnchantingTableBlockEntity te, float partialTicks, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        float time = (float)te.tickCount + partialTicks;
        float f1 = te.bookRotation - te.bookRotationPrev;
        while ((double)f1 >= Math.PI) {
            f1 = (float)((double)f1 - Math.PI * 2);
        }
        while ((double)f1 < -Math.PI) {
            f1 = (float)((double)f1 + Math.PI * 2);
        }
        float rot = te.bookRotationPrev + f1 * partialTicks;
        float bookOpen = te.bookSpreadPrev + (te.bookSpread - te.bookSpreadPrev) * partialTicks;
        this.renderBook(te, time, rot, partialTicks, matrix, buffer, light, overlay);
        ItemStack item = te.m_8020_(0);
        if (!item.m_41619_()) {
            this.renderItem(item, time, bookOpen, rot, matrix, buffer, light, overlay);
        }
    }

    private void renderItem(ItemStack item, float time, float bookOpen, float rot, PoseStack matrix, MultiBufferSource buffer, int light, int overlay) {
        matrix.m_85836_();
        matrix.m_85837_(0.5, (double)0.8f, 0.5);
        matrix.m_85841_(0.6f, 0.6f, 0.6f);
        rot *= -57.295776f;
        rot -= 90.0f;
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(rot *= bookOpen));
        matrix.m_85837_(0.0, (double)(bookOpen * 1.4f), Math.sin((double)bookOpen * Math.PI));
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f * (bookOpen - 1.0f)));
        float trans = (float)Math.sin((double)time * 0.06) * bookOpen * 0.2f;
        matrix.m_85837_(0.0, (double)trans, 0.0);
        ItemRenderer render = Minecraft.m_91087_().m_91291_();
        render.m_174269_(item, ItemTransforms.TransformType.FIXED, light, overlay, matrix, buffer, 0);
        matrix.m_85849_();
    }

    private void renderBook(MatrixEnchantingTableBlockEntity tileEntityIn, float time, float bookRot, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float f1;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.75, 0.5);
        float f = (float)tileEntityIn.tickCount + partialTicks;
        matrixStackIn.m_85837_(0.0, (double)(0.1f + Mth.m_14031_((float)(f * 0.1f)) * 0.01f), 0.0);
        for (f1 = tileEntityIn.bookRotation - tileEntityIn.bookRotationPrev; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        float f2 = tileEntityIn.bookRotationPrev + f1 * partialTicks;
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122270_(-f2));
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(80.0f));
        float f3 = Mth.m_14179_((float)partialTicks, (float)tileEntityIn.pageFlipPrev, (float)tileEntityIn.pageFlip);
        float f4 = Mth.m_14187_((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.m_14187_((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.m_14179_((float)partialTicks, (float)tileEntityIn.bookSpreadPrev, (float)tileEntityIn.bookSpread);
        this.modelBook.m_102292_(f, Mth.m_14036_((float)f4, (float)0.0f, (float)1.0f), Mth.m_14036_((float)f5, (float)0.0f, (float)1.0f), f6);
        VertexConsumer ivertexbuilder = TEXTURE_BOOK.m_119194_(bufferIn, RenderType::m_110446_);
        this.modelBook.m_7695_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }
}

