/*
 * Decompiled with CFR 0.152.
 */
package shadows.wstweaks;

import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.RegisterEvent;
import shadows.placebo.recipe.RecipeHelper;
import shadows.placebo.util.RunnableReloader;
import shadows.wstweaks.ItemImmolationBlade;
import shadows.wstweaks.WSTConfig;
import shadows.wstweaks.WSTLootModifier;

@Mod(value="wstweaks")
public class WitherSkeletonTweaks {
    public static final String MODID = "wstweaks";
    public static final RecipeHelper HELPER = new RecipeHelper("wstweaks");
    public static Tier IMMOLATION;
    @ObjectHolder(registryName="item", value="wstweaks:fragment")
    public static final Item FRAGMENT;

    public WitherSkeletonTweaks() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        WSTConfig.load();
        IMMOLATION = new ForgeTier(9, WSTConfig.swordDurability, WSTConfig.swordAtkSpeed, WSTConfig.swordDamage, 30, null, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42686_}));
        MinecraftForge.EVENT_BUS.addListener(this::reload);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        HELPER.registerProvider(factory -> {
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>(9);
            for (int i = 0; i < WSTConfig.shardValue; ++i) {
                inputs.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{FRAGMENT}));
            }
            factory.addShapeless((Object)new ItemStack((ItemLike)Items.f_42679_), inputs.toArray());
        });
    }

    @SubscribeEvent
    public void register(RegisterEvent e) {
        if (e.getForgeRegistry() == ForgeRegistries.ITEMS) {
            this.registerItems();
        }
        if (e.getForgeRegistry() == ForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS.get()) {
            this.registerGMLSer();
        }
    }

    private void registerItems() {
        ForgeRegistries.ITEMS.register("fragment", (Object)new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
        ForgeRegistries.ITEMS.register("lava_blade", (Object)new ItemImmolationBlade());
        ForgeRegistries.ITEMS.register("blaze_blade", (Object)new ItemImmolationBlade());
    }

    private void registerGMLSer() {
        ((IForgeRegistry)ForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS.get()).register("wstmodifier", WSTLootModifier.CODEC.get());
    }

    public void reload(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)new RunnableReloader(WSTConfig::load));
    }

    public static ResourceLocation loc(String s) {
        return new ResourceLocation(MODID, s);
    }

    static {
        FRAGMENT = null;
    }
}

