/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import owmii.powah.api.wrench.IWrench;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.CableTile;
import owmii.powah.lib.client.handler.IHudItem;
import owmii.powah.lib.item.ItemBase;
import owmii.powah.lib.logistics.energy.SideConfig;

public class WrenchItem
extends ItemBase
implements IHudItem,
IWrench {
    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, Level world, BlockPos pos, Player player, InteractionHand hand, Direction side, Vec3 hit) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        BlockEntity te = world.m_7702_(pos);
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof IWrenchable) {
            if (((IWrenchable)state.m_60734_()).onWrench(state, world, pos, player, hand, side, this.getWrenchMode(stack), hit)) {
                return InteractionResult.SUCCESS;
            }
        } else if (!world.f_46443_ && this.getWrenchMode(stack).config() && te instanceof CableTile) {
            CableTile cable = (CableTile)te;
            if (stack.m_41720_() instanceof WrenchItem) {
                Optional<Direction> sides = CableBlock.getHitSide(hit, pos);
                boolean[] flag = new boolean[]{false};
                sides.ifPresent(direction -> {
                    SideConfig config = cable.getSideConfig();
                    config.nextType((Direction)direction);
                    cable.sync();
                });
                return InteractionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(stack, world, pos, player, hand, side, hit);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            this.nextWrenchMode(stack);
            playerIn.m_5661_((Component)Component.m_237110_((String)("info.powah.wrench.mode." + this.getWrenchMode(stack).name().toLowerCase()), (Object[])new Object[]{ChatFormatting.YELLOW}).m_130940_(ChatFormatting.GRAY), true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237110_((String)("info.powah.wrench.mode." + this.getWrenchMode(stack).name().toLowerCase()), (Object[])new Object[]{ChatFormatting.YELLOW}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            this.oneTimeInfo(player, stack, (Component)Component.m_237110_((String)("info.powah.wrench.mode." + this.getWrenchMode(stack).name().toLowerCase()), (Object[])new Object[]{ChatFormatting.YELLOW}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public boolean renderHud(Level world, BlockPos pos, Player player, InteractionHand hand, Direction side, Vec3 hit) {
        return false;
    }

    private boolean changeWrenchMode(ItemStack stack, boolean next) {
        if (stack.m_41720_() instanceof IWrench) {
            if (next) {
                this.nextWrenchMode(stack);
                return true;
            }
            this.prevWrenchMode(stack);
            return true;
        }
        return false;
    }

    private void nextWrenchMode(ItemStack stack) {
        int j;
        CompoundTag nbt;
        int i = (nbt = this.getWrenchNBT(stack)).m_128451_("WrenchMode") + 1;
        nbt.m_128405_("WrenchMode", i > (j = WrenchMode.values().length - 1) ? 0 : i);
    }

    private void prevWrenchMode(ItemStack stack) {
        int j;
        CompoundTag nbt;
        int i = (nbt = this.getWrenchNBT(stack)).m_128451_("WrenchMode") - 1;
        nbt.m_128405_("WrenchMode", i < (j = WrenchMode.values().length - 1) ? j : i);
    }

    @Override
    public WrenchMode getWrenchMode(ItemStack stack) {
        return WrenchMode.values()[this.getWrenchNBT(stack).m_128451_("WrenchMode")];
    }

    public CompoundTag getWrenchNBT(ItemStack stack) {
        return stack.m_41698_("PowahWrenchNBT");
    }
}

