/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.forge.block;

import com.google.common.primitives.Ints;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import owmii.powah.block.Tier;
import owmii.powah.block.cable.CableTile;

public class ForgeCableTile
extends CableTile {
    public ForgeCableTile(BlockPos pos, BlockState state, Tier variant) {
        super(pos, state, variant);
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate, @Nullable Direction direction) {
        if (this.f_58857_ == null || this.isRemote() || direction == null || !this.checkRedstone() || !this.canReceiveEnergy(direction)) {
            return 0L;
        }
        long received = 0L;
        Iterable<CableTile> cables = this.getCables();
        if (!simulate) {
            ++this.startIndex;
        }
        for (CableTile cable : cables) {
            long amount = maxReceive - received;
            if (amount <= 0L) break;
            if (cable.energySides.isEmpty() || !cable.isActive()) continue;
            received += ((ForgeCableTile)cable).pushEnergy(maxReceive, simulate, direction, this);
        }
        return received;
    }

    private long pushEnergy(long maxReceive, boolean simulate, @Nullable Direction direction, CableTile cable) {
        Level level = this.m_58904_();
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Expected server level");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        long received = 0L;
        for (int i = 0; i < 6; ++i) {
            Direction side = Direction.m_122376_((int)((i + serverLevel.m_7654_().m_129921_()) % 6));
            if (!this.energySides.contains(side)) continue;
            long amount = Math.min(maxReceive - received, this.energy.getMaxExtract());
            if (amount <= 0L) break;
            if (cable.equals(this) && side.equals((Object)direction) || !this.canExtractEnergy(side)) continue;
            BlockPos pos = this.f_58858_.m_121945_(side);
            if (direction != null && cable.m_58899_().m_121945_(direction).equals((Object)pos)) continue;
            received += this.receive(this.f_58857_, pos, side.m_122424_(), amount, simulate);
        }
        return received;
    }

    private long receive(Level level, BlockPos pos, Direction side, long amount, boolean simulate) {
        BlockEntity tile = level.m_7702_(pos);
        IEnergyStorage energy = tile != null ? (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side).orElse(null) : null;
        return energy != null ? (long)energy.receiveEnergy(Ints.saturatedCast((long)amount), simulate) : 0L;
    }
}

