/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.forge;

import com.google.common.primitives.Ints;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import owmii.powah.EnvHandler;
import owmii.powah.Powah;
import owmii.powah.api.forge.ChargeableItemsEvent;
import owmii.powah.block.Tier;
import owmii.powah.block.cable.CableTile;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.client.render.tile.ReactorItemRenderer;
import owmii.powah.forge.EmptyEnergyStorage;
import owmii.powah.forge.block.ForgeCableTile;
import owmii.powah.item.ItemGroups;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IBlock;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.item.IEnergyContainingItem;
import owmii.powah.lib.item.ItemBlock;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.lib.util.Util;
import owmii.powah.world.gen.Features;

public class ForgeEnvHandler
implements EnvHandler {
    private final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();

    @Override
    public void setupBlockItems() {
        this.modEventBus.addListener(event -> {
            if (event.getRegistryKey() == Registry.f_122904_) {
                IForgeRegistry registry = event.getForgeRegistry();
                for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                    if (!(block instanceof IBlock)) continue;
                    IBlock iBlock = (IBlock)block;
                    ItemBlock blockItem = iBlock.getBlockItem(new Item.Properties(), ItemGroups.MAIN);
                    ResourceLocation name = Registry.f_122824_.m_7981_((Object)block);
                    registry.register(name, (Object)blockItem);
                }
            }
        });
    }

    @Override
    public void registerWorldgen() {
        EnvHandler.super.registerWorldgen();
        this.modEventBus.addListener(event -> {
            if (event.getRegistryKey() == Registry.f_122838_) {
                Features.init();
            }
        });
    }

    @Override
    public void handleReactorInitClient(Consumer<?> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new ReactorItemRenderer();
            }
        });
    }

    @Override
    public TagKey<Biome> getOverworldBiomeTag() {
        return BiomeTags.f_215817_;
    }

    @Override
    public void scheduleCommonSetup(Runnable runnable) {
        this.modEventBus.addListener(event -> runnable.run());
    }

    @Override
    public void registerTransfer() {
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, event -> {
            Object patt7159$temp;
            Object holder;
            Object patt6611$temp;
            Object patt5141$temp;
            Object patt4609$temp = event.getObject();
            if (patt4609$temp instanceof ReactorPartTile) {
                final ReactorPartTile reactorPart = (ReactorPartTile)patt4609$temp;
                event.addCapability(Powah.id("reactor_part"), new ICapabilityProvider(){

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                        if (reactorPart.core().isPresent() && (cap != CapabilityEnergy.ENERGY || reactorPart.isExtractor())) {
                            return reactorPart.core().get().getCapability(cap, side);
                        }
                        return LazyOptional.empty();
                    }
                });
            }
            if ((patt5141$temp = event.getObject()) instanceof AbstractEnergyStorage) {
                final AbstractEnergyStorage energyStorage = (AbstractEnergyStorage)patt5141$temp;
                event.addCapability(Powah.id("energy"), new ICapabilityProvider(){

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, final @Nullable Direction side) {
                        if (capability == CapabilityEnergy.ENERGY && energyStorage.isEnergyPresent(side)) {
                            return LazyOptional.of(() -> new IEnergyStorage(){

                                public int extractEnergy(int maxExtract, boolean simulate) {
                                    return Util.safeInt(energyStorage.extractEnergy(maxExtract, simulate, side));
                                }

                                public int getEnergyStored() {
                                    return Util.safeInt(energyStorage.getEnergy().getStored());
                                }

                                public int getMaxEnergyStored() {
                                    return Ints.saturatedCast((long)energyStorage.getEnergy().getMaxEnergyStored());
                                }

                                public int receiveEnergy(int maxReceive, boolean simulate) {
                                    return Util.safeInt(energyStorage.receiveEnergy(maxReceive, simulate, side));
                                }

                                public boolean canReceive() {
                                    return energyStorage.canReceiveEnergy(side);
                                }

                                public boolean canExtract() {
                                    return energyStorage.canExtractEnergy(side);
                                }
                            }).cast();
                        }
                        return LazyOptional.empty();
                    }
                });
            }
            if ((patt6611$temp = event.getObject()) instanceof IInventoryHolder) {
                holder = (IInventoryHolder)patt6611$temp;
                event.addCapability(Powah.id("inv"), new ICapabilityProvider(){
                    final /* synthetic */ IInventoryHolder val$holder;
                    {
                        this.val$holder = iInventoryHolder;
                    }

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
                        Inventory inv;
                        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && !(inv = this.val$holder.getInventory()).isBlank()) {
                            return LazyOptional.of(inv::getPlatformWrapper).cast();
                        }
                        return LazyOptional.empty();
                    }
                });
            }
            if ((patt7159$temp = event.getObject()) instanceof ITankHolder) {
                holder = (ITankHolder)patt7159$temp;
                event.addCapability(Powah.id("tank"), new ICapabilityProvider(){
                    final /* synthetic */ ITankHolder val$holder;
                    {
                        this.val$holder = iTankHolder;
                    }

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                            return LazyOptional.of(this.val$holder.getTank()::getPlatformWrapper).cast();
                        }
                        return LazyOptional.empty();
                    }
                });
            }
        });
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, event -> {
            Item patt7765$temp = ((ItemStack)event.getObject()).m_41720_();
            if (patt7765$temp instanceof IEnergyContainingItem) {
                final IEnergyContainingItem eci = (IEnergyContainingItem)patt7765$temp;
                event.addCapability(Powah.id("energy"), new ICapabilityProvider(){
                    final /* synthetic */ AttachCapabilitiesEvent val$event;
                    {
                        this.val$event = attachCapabilitiesEvent;
                    }

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction arg) {
                        IEnergyContainingItem.Info info;
                        if (cap == CapabilityEnergy.ENERGY && (info = eci.getEnergyInfo()) != null) {
                            return LazyOptional.of(() -> {
                                final Energy.Item energyItem = new Energy.Item((ItemStack)this.val$event.getObject(), info);
                                return new IEnergyStorage(){

                                    public int receiveEnergy(int i, boolean bl) {
                                        return Ints.saturatedCast((long)energyItem.receiveEnergy(i, bl));
                                    }

                                    public int extractEnergy(int i, boolean bl) {
                                        return Ints.saturatedCast((long)energyItem.extractEnergy(i, bl));
                                    }

                                    public int getEnergyStored() {
                                        return Ints.saturatedCast((long)energyItem.getEnergyStored());
                                    }

                                    public int getMaxEnergyStored() {
                                        return Ints.saturatedCast((long)energyItem.getMaxEnergyStored());
                                    }

                                    public boolean canExtract() {
                                        return energyItem.canExtract();
                                    }

                                    public boolean canReceive() {
                                        return energyItem.canReceive();
                                    }
                                };
                            }).cast();
                        }
                        return LazyOptional.empty();
                    }
                });
            }
        });
    }

    @Override
    public Object createInvWrapper(final Inventory inventory) {
        return new IItemHandler(){

            public int getSlots() {
                return inventory.getSlots();
            }

            @NotNull
            public ItemStack getStackInSlot(int i) {
                return inventory.getStackInSlot(i);
            }

            @NotNull
            public ItemStack insertItem(int i, @NotNull ItemStack arg, boolean bl) {
                return inventory.insertItem(i, arg, bl);
            }

            @NotNull
            public ItemStack extractItem(int i, int j, boolean bl) {
                return inventory.extractItem(i, j, bl);
            }

            public int getSlotLimit(int i) {
                return inventory.getSlotLimit(i);
            }

            public boolean isItemValid(int i, @NotNull ItemStack arg) {
                return inventory.isItemValid(i, arg);
            }
        };
    }

    public IFluidHandler createTankWrapper(final Tank tank) {
        return new IFluidHandler(){

            public int getTanks() {
                return tank.getTanks();
            }

            @NotNull
            public FluidStack getFluidInTank(int i) {
                return FluidStackHooksForge.toForge((dev.architectury.fluid.FluidStack)tank.getFluidInTank(i));
            }

            public int getTankCapacity(int i) {
                return (int)tank.getTankCapacity(i);
            }

            public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
                return tank.isFluidValid(i, FluidStackHooksForge.fromForge((FluidStack)fluidStack));
            }

            public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                return (int)tank.fill(FluidStackHooksForge.fromForge((FluidStack)fluidStack), fluidAction.simulate());
            }

            @NotNull
            public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                return FluidStackHooksForge.toForge((dev.architectury.fluid.FluidStack)tank.drain(FluidStackHooksForge.fromForge((FluidStack)fluidStack), fluidAction.simulate()));
            }

            @NotNull
            public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
                return FluidStackHooksForge.toForge((dev.architectury.fluid.FluidStack)tank.drain(i, fluidAction.simulate()));
            }
        };
    }

    @Override
    public boolean interactWithTank(Player player, InteractionHand hand, Tank tank) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.createTankWrapper(tank));
    }

    @Override
    public boolean canDischarge(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).map(s -> s.canExtract() && s.getEnergyStored() > 0).orElse(false);
    }

    @Override
    public boolean hasEnergy(Level level, BlockPos pos, Direction side) {
        BlockEntity be = level.m_7702_(pos);
        return be != null && be.getCapability(CapabilityEnergy.ENERGY, side).isPresent();
    }

    @Override
    public long pushEnergy(Level level, BlockPos pos, Direction side, long howMuch) {
        BlockEntity be = level.m_7702_(pos);
        IEnergyStorage handler = be != null ? (IEnergyStorage)be.getCapability(CapabilityEnergy.ENERGY, side).orElse(null) : null;
        return handler != null ? (long)handler.receiveEnergy(Ints.saturatedCast((long)howMuch), false) : 0L;
    }

    @Override
    public CableTile createCable(BlockPos pos, BlockState state, Tier variant) {
        return new ForgeCableTile(pos, state, variant);
    }

    @Override
    public long chargeItemsInPlayerInv(Player player, long maxPerSlot, long maxTotal, Predicate<ItemStack> allowStack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(owmii.powah.lib.util.Player.invStacks(player).stream().toList());
        ChargeableItemsEvent event = new ChargeableItemsEvent(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        stacks.addAll(event.getItems());
        stacks.removeIf(allowStack.negate());
        return this.transferSlotList(IEnergyStorage::receiveEnergy, stacks, maxPerSlot, maxTotal);
    }

    @Override
    public long chargeItemsInContainer(Container container, long maxPerSlot, long maxTotal) {
        long ret = this.transferSlotList(IEnergyStorage::receiveEnergy, IntStream.range(0, container.m_6643_()).mapToObj(arg_0 -> ((Container)container).m_8020_(arg_0)).toList(), maxPerSlot, maxTotal);
        container.m_6596_();
        return ret;
    }

    @Override
    public long chargeItemsInInventory(Inventory inv, int slotFrom, int slotTo, long maxPerSlot, long maxTotal) {
        return this.transferSlotList(IEnergyStorage::receiveEnergy, IntStream.range(slotFrom, slotTo).mapToObj(inv::getStackInSlot).toList(), maxPerSlot, maxTotal);
    }

    @Override
    public long dischargeItemsInInventory(Inventory inv, long maxPerSlot, long maxTotal) {
        return this.transferSlotList(IEnergyStorage::extractEnergy, IntStream.range(0, inv.getSlots()).mapToObj(inv::getStackInSlot).toList(), maxPerSlot, maxTotal);
    }

    private long transferSlotList(EnergyTransferOperation op, Iterable<ItemStack> stacks, long maxPerStack, long maxTotal) {
        long charged = 0L;
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            IEnergyStorage cap = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY).orElse((Object)EmptyEnergyStorage.INSTANCE);
            charged += (long)op.perform(cap, Ints.saturatedCast((long)Math.min(maxPerStack, maxTotal - charged)), false);
        }
        return charged;
    }

    private static interface EnergyTransferOperation {
        public int perform(IEnergyStorage var1, int var2, boolean var3);
    }
}

