/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.client.screen.Textures;
import owmii.powah.inventory.ReactorContainer;
import owmii.powah.lib.client.screen.container.AbstractEnergyScreen;
import owmii.powah.lib.client.screen.widget.IconButton;
import owmii.powah.lib.client.util.Draw;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.util.Util;
import owmii.powah.network.Network;
import owmii.powah.network.packet.SwitchGenModePacket;

public class ReactorScreen
extends AbstractEnergyScreen<ReactorTile, ReactorContainer> {
    private IconButton modeButton = IconButton.EMPTY;

    public ReactorScreen(ReactorContainer container, Inventory inv, Component title) {
        super(container, inv, title, Textures.REACTOR);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.modeButton = (IconButton)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ - 11, this.f_97736_ + 10, Textures.REACTOR_GEN_MODE.get(((ReactorTile)this.te).isGenModeOn()), b -> {
            Network.toServer(new SwitchGenModePacket(((ReactorTile)this.te).m_58899_()));
            ((ReactorTile)this.te).setGenModeOn(!((ReactorTile)this.te).isGenModeOn());
        }, (Screen)this).setTooltip(tooltip -> {
            tooltip.add(Component.m_237115_((String)"info.powah.gen.mode").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237115_((String)("info.lollipop." + (((ReactorTile)this.te).isGenModeOn() ? "on" : "off"))).m_130940_(((ReactorTile)this.te).isGenModeOn() ? ChatFormatting.GREEN : ChatFormatting.RED)));
            tooltip.add(Component.m_237115_((String)"info.powah.gen.mode.desc").m_130940_(ChatFormatting.DARK_GRAY));
        }));
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.modeButton.setTexture(Textures.REACTOR_GEN_MODE.get(((ReactorTile)this.te).isGenModeOn()));
    }

    @Override
    protected void drawBackground(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        TextureAtlasSprite sprite;
        super.drawBackground(matrix, partialTicks, mouseX, mouseY);
        Textures.REACTOR_GAUGE.drawScalableH(matrix, ((ReactorTile)this.te).getEnergy().subSized(), this.f_97735_ + 5, this.f_97736_ + 5);
        Textures.REACTOR_GAUGE_URN.drawScalableH(matrix, ((ReactorTile)this.te).fuel.subSized(), this.f_97735_ + 103, this.f_97736_ + 13);
        Textures.REACTOR_GAUGE_CARBON.drawScalableH(matrix, ((ReactorTile)this.te).carbon.subSized(), this.f_97735_ + 51, this.f_97736_ + 6);
        Textures.REACTOR_GAUGE_REDSTONE.drawScalableH(matrix, ((ReactorTile)this.te).redstone.subSized(), this.f_97735_ + 51, this.f_97736_ + 52);
        Textures.REACTOR_GAUGE_COOLANT.drawScalableH(matrix, ((ReactorTile)this.te).solidCoolant.subSized(), this.f_97735_ + 140, this.f_97736_ + 52);
        Textures.REACTOR_GAUGE_TEMP.drawScalableH(matrix, ((ReactorTile)this.te).temp.subSized(), this.f_97735_ + 114, this.f_97736_ + 28);
        Textures.REACTOR_GEN_MODE_BG.draw(matrix, this.modeButton.f_93620_ - 4, this.modeButton.f_93621_ - 4);
        Tank tank = ((ReactorTile)this.te).getTank();
        if (!tank.isEmpty() && (sprite = FluidStackHooks.getStillTexture((FluidStack)(fluidStack = tank.getFluid()))) != null) {
            int color = FluidStackHooks.getColor((FluidStack)fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)1.0f);
            this.bindTexture(InventoryMenu.f_39692_);
            Draw.gaugeV(sprite, this.f_97735_ + 157, this.f_97736_ + 5, 14, 65, (int)tank.getCapacity(), (int)tank.getFluidAmount());
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    protected void m_7025_(PoseStack matrix, int mouseX, int mouseY) {
        ArrayList<MutableComponent> list;
        super.m_7025_(matrix, mouseX, mouseY);
        if (Textures.REACTOR_GAUGE.isMouseOver(this.f_97735_ + 5, this.f_97736_ + 5, mouseX, mouseY)) {
            list = new ArrayList<MutableComponent>();
            Energy energy = ((ReactorTile)this.te).getEnergy();
            list.add(Component.m_237115_((String)"info.powah.gen.mode").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237115_((String)("info.lollipop." + (((ReactorTile)this.te).isGenModeOn() ? "on" : "off"))).m_130940_(((ReactorTile)this.te).isGenModeOn() ? ChatFormatting.GREEN : ChatFormatting.RED)));
            list.add(Component.m_237115_((String)"info.lollipop.stored").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237110_((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(energy.getStored()), Util.numFormat(energy.getCapacity())}).m_130940_(ChatFormatting.DARK_GRAY)));
            list.add(Component.m_237115_((String)"info.powah.generation.factor").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237113_((String)Util.numFormat(((ReactorTile)this.te).getGeneration())).m_7220_((Component)Component.m_237115_((String)"info.lollipop.fe.pet.tick")).m_130940_(ChatFormatting.DARK_GRAY)));
            list.add(Component.m_237115_((String)"info.lollipop.generating").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237113_((String)Util.numFormat((long)((ReactorTile)this.te).calcProduction())).m_7220_((Component)Component.m_237115_((String)"info.lollipop.fe.pet.tick")).m_130940_(ChatFormatting.DARK_GRAY)));
            list.add(Component.m_237115_((String)"info.lollipop.max.extract").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237113_((String)Util.numFormat(energy.getMaxExtract())).m_7220_((Component)Component.m_237115_((String)"info.lollipop.fe.pet.tick")).m_130940_(ChatFormatting.DARK_GRAY)));
            this.m_96597_(matrix, list, mouseX, mouseY);
        }
        if (Textures.REACTOR_GAUGE_TEMP.isMouseOver(this.f_97735_ + 114, this.f_97736_ + 28, mouseX, mouseY)) {
            list = new ArrayList();
            list.add(Component.m_237113_((String)(ChatFormatting.GRAY + String.format("%.1f", ((ReactorTile)this.te).temp.getTicks()) + " C")));
            this.m_96597_(matrix, list, mouseX, mouseY);
        }
        if (Textures.REACTOR_GAUGE_URN.isMouseOver(this.f_97735_ + 103, this.f_97736_ + 13, mouseX, mouseY)) {
            list = new ArrayList();
            list.add(Component.m_237115_((String)"item.powah.uraninite").m_130940_(ChatFormatting.GREEN));
            list.add(Component.m_237115_((String)"info.lollipop.stored").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237110_((String)"info.lollipop.mb.stored", (Object[])new Object[]{String.format("%.0f", ((ReactorTile)this.te).fuel.getTicks()), String.format("%.0f", ((ReactorTile)this.te).fuel.getMax())}).m_130940_(ChatFormatting.DARK_GRAY)));
            list.add(Component.m_237115_((String)"info.lollipop.using").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237113_((String)(ChatFormatting.GREEN + String.format("%.4f", ((ReactorTile)this.te).calcConsumption()))).m_7220_((Component)Component.m_237115_((String)"info.lollipop.mb.pet.tick")).m_130940_(ChatFormatting.DARK_GRAY)));
            this.m_96597_(matrix, list, mouseX, mouseY);
        }
        if (Textures.REACTOR_GAUGE_CARBON.isMouseOver(this.f_97735_ + 51, this.f_97736_ + 6, mouseX, mouseY)) {
            list = new ArrayList();
            boolean b = ((ReactorTile)this.te).carbon.isEmpty();
            list.add(Component.m_237115_((String)"info.powah.carbon").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"info.lollipop.stored").m_130940_(ChatFormatting.DARK_GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237110_((String)"info.lollipop.mb.stored", (Object[])new Object[]{String.format("%.1f", ((ReactorTile)this.te).carbon.getTicks()), String.format("%.1f", ((ReactorTile)this.te).carbon.getMax())}).m_130940_(ChatFormatting.DARK_GRAY)));
            list.add(Component.m_237119_());
            list.add(Component.m_237115_((String)"enchantment.minecraft.efficiency").m_130940_(ChatFormatting.DARK_AQUA));
            list.add(Component.m_237113_((String)(ChatFormatting.DARK_RED + (b ? "+0 C" : "+180 C"))));
            this.m_96597_(matrix, list, mouseX, mouseY);
        }
        if (Textures.REACTOR_GAUGE_REDSTONE.isMouseOver(this.f_97735_ + 51, this.f_97736_ + 52, mouseX, mouseY)) {
            list = new ArrayList();
            boolean b = ((ReactorTile)this.te).redstone.isEmpty();
            list.add(Component.m_237115_((String)"info.powah.redstone").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"info.lollipop.stored").m_130940_(ChatFormatting.DARK_GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237110_((String)"info.lollipop.mb.stored", (Object[])new Object[]{String.format("%.1f", ((ReactorTile)this.te).redstone.getTicks()), String.format("%.1f", ((ReactorTile)this.te).redstone.getMax())}).m_130940_(ChatFormatting.DARK_GRAY)));
            list.add(Component.m_237119_());
            list.add(Component.m_237115_((String)"info.powah.production").m_130940_(ChatFormatting.DARK_AQUA));
            list.add(Component.m_237115_((String)"info.powah.fuel.consumption").m_130940_(ChatFormatting.DARK_RED));
            list.add(Component.m_237113_((String)(ChatFormatting.DARK_RED + (b ? "+0 C" : "+120 C"))));
            this.m_96597_(matrix, list, mouseX, mouseY);
        }
        if (Textures.REACTOR_GAUGE_COOLANT.isMouseOver(this.f_97735_ + 140, this.f_97736_ + 52, mouseX, mouseY)) {
            list = new ArrayList();
            list.add(Component.m_237115_((String)"info.powah.solid.coolant").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"info.lollipop.stored").m_130940_(ChatFormatting.DARK_GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237110_((String)"info.lollipop.mb.stored", (Object[])new Object[]{String.format("%.1f", ((ReactorTile)this.te).solidCoolant.getTicks()), String.format("%.1f", ((ReactorTile)this.te).solidCoolant.getMax())}).m_130940_(ChatFormatting.DARK_GRAY)));
            list.add(Component.m_237113_((String)(ChatFormatting.AQUA + ((ReactorTile)this.te).solidCoolantTemp + " C")));
            this.m_96597_(matrix, list, mouseX, mouseY);
        }
        Tank tank = ((ReactorTile)this.te).getTank();
        if (this.isMouseOver(mouseX - 157, mouseY - 5, 14, 65)) {
            ArrayList<MutableComponent> list2 = new ArrayList<MutableComponent>();
            if (!tank.isEmpty()) {
                list2.add(Component.m_237115_((String)"info.lollipop.coolant").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)FluidStackHooks.getName((FluidStack)tank.getFluid()).m_6879_().m_130940_(ChatFormatting.AQUA)));
                list2.add(Component.m_237115_((String)"info.lollipop.stored").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Util.formatTankContent(tank)));
                list2.add(Component.m_237115_((String)"info.lollipop.temperature").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237110_((String)"info.lollipop.temperature.c", (Object[])new Object[]{"" + ChatFormatting.AQUA + PowahAPI.getCoolant(tank.getFluid().getFluid())}).m_130940_(ChatFormatting.DARK_GRAY)));
            } else {
                list2.add(Component.m_237115_((String)"info.lollipop.fluid").m_130940_(ChatFormatting.GRAY).m_7220_(Text.COLON).m_7220_((Component)Component.m_237113_((String)"---").m_130940_(ChatFormatting.DARK_GRAY)));
            }
            this.m_96597_(matrix, list2, mouseX, mouseY);
        }
    }
}

