/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.lib.util.NBT;

public class Builder {
    private final ReactorTile reactor;
    private List<BlockPos> queue = new ArrayList<BlockPos>();
    public boolean built;
    private int delay = 5;

    public Builder(ReactorTile reactor) {
        this.reactor = reactor;
    }

    public void read(CompoundTag nbt) {
        this.built = nbt.m_128471_("built");
        if (!this.built) {
            this.queue = NBT.readPosList(nbt, "queue_pos", new ArrayList());
        }
    }

    public void write(CompoundTag nbt) {
        nbt.m_128379_("built", this.built);
        if (!this.built) {
            NBT.writePosList(nbt, this.queue, "queue_pos");
        }
    }

    public boolean isDone(Level world) {
        if (this.built) {
            return true;
        }
        if (!this.queue.isEmpty()) {
            if (this.delay-- <= 0) {
                Iterator<BlockPos> itr = this.queue.iterator();
                while (itr.hasNext()) {
                    BlockPos pos = itr.next();
                    BlockState state = ((ReactorBlock)this.reactor.getBlock()).m_49966_();
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)ReactorBlock.CORE, (Comparable)Boolean.valueOf(false)), 3);
                    BlockEntity tileEntity = world.m_7702_(pos);
                    if (!(tileEntity instanceof ReactorPartTile)) continue;
                    ReactorPartTile part = (ReactorPartTile)tileEntity;
                    part.setCorePos(this.reactor.m_58899_());
                    world.m_46796_(2001, pos, Block.m_49956_((BlockState)this.reactor.m_58900_()));
                    itr.remove();
                    this.delay = 5;
                    return false;
                }
            }
        } else {
            for (Direction side : Direction.values()) {
                if (side.equals((Object)Direction.DOWN)) continue;
                BlockPos pos = this.reactor.m_58899_().m_121945_(side).m_6630_(side.equals((Object)Direction.UP) ? 2 : 0);
                BlockEntity tileEntity = world.m_7702_(pos);
                if (!(tileEntity instanceof ReactorPartTile)) continue;
                ReactorPartTile part = (ReactorPartTile)tileEntity;
                part.setExtractor(true);
                world.m_46672_(pos, part.getBlock());
            }
            for (BlockPos pos : this.getPosList()) {
                BlockEntity tileEntity = world.m_7702_(pos);
                if (!(tileEntity instanceof ReactorPartTile)) continue;
                ReactorPartTile part = (ReactorPartTile)tileEntity;
                part.setBuilt(true);
                part.sync();
            }
            this.built = true;
            this.reactor.sync();
        }
        return false;
    }

    public void shuffle() {
        this.queue.addAll(this.getPosList());
        Collections.shuffle(this.queue);
    }

    public void demolish(Level world) {
        List<BlockPos> list = this.getPosList();
        list.add(this.reactor.m_58899_());
        int count = 0;
        for (BlockPos blockPos : list) {
            if (!world.m_8055_(blockPos).m_60734_().equals(this.reactor.getBlock())) continue;
            ++count;
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
        }
        Block.m_49840_((Level)world, (BlockPos)this.reactor.m_58899_(), (ItemStack)new ItemStack(this.reactor.getBlock(), count + this.queue.size()));
        world.m_7731_(this.reactor.m_58899_(), Blocks.f_50016_.m_49966_(), 3);
        this.queue.clear();
    }

    public List<BlockPos> getPosList() {
        BlockPos pos = this.reactor.m_58899_();
        return BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, 3, 1)).map(BlockPos::m_7949_).filter(pos1 -> !pos1.equals((Object)pos)).collect(Collectors.toList());
    }
}

