/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.powah.Powah;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.item.WrenchItem;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.client.handler.IHud;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.lib.util.Util;
import owmii.powah.lib.util.math.V3d;

public class EnergizingOrbBlock
extends AbstractBlock<IVariant.Single, EnergizingOrbBlock>
implements SimpleWaterloggedBlock,
IWrenchable,
IHud {
    public EnergizingOrbBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.setStateProps(state -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN));
        this.shapes.put(Direction.UP, Shapes.m_83113_((VoxelShape)EnergizingOrbBlock.box(3.5, 11.0, 3.5, 12.5, 1.77, 12.5), (VoxelShape)EnergizingOrbBlock.box(2.5, 15.0, 2.5, 13.5, 16.0, 13.5), (BooleanOp)BooleanOp.f_82695_));
        this.shapes.put(Direction.DOWN, Shapes.m_83113_((VoxelShape)EnergizingOrbBlock.box(3.5, 14.23, 3.5, 12.5, 5.0, 12.5), (VoxelShape)EnergizingOrbBlock.box(2.5, 0.0, 2.5, 13.5, 1.0, 13.5), (BooleanOp)BooleanOp.f_82695_));
        this.shapes.put(Direction.NORTH, Shapes.m_83113_((VoxelShape)EnergizingOrbBlock.box(3.5, 3.5, 14.23, 12.5, 12.5, 5.0), (VoxelShape)EnergizingOrbBlock.box(2.5, 2.5, 0.0, 13.5, 13.5, 1.0), (BooleanOp)BooleanOp.f_82695_));
        this.shapes.put(Direction.SOUTH, Shapes.m_83113_((VoxelShape)EnergizingOrbBlock.box(3.5, 3.5, 11.0, 12.5, 12.5, 1.77), (VoxelShape)EnergizingOrbBlock.box(2.5, 2.5, 15.0, 13.5, 13.5, 16.0), (BooleanOp)BooleanOp.f_82695_));
        this.shapes.put(Direction.WEST, Shapes.m_83113_((VoxelShape)EnergizingOrbBlock.box(14.23, 3.5, 3.5, 5.0, 12.5, 12.5), (VoxelShape)EnergizingOrbBlock.box(0.0, 2.5, 2.5, 1.0, 13.5, 13.5), (BooleanOp)BooleanOp.f_82695_));
        this.shapes.put(Direction.EAST, Shapes.m_83113_((VoxelShape)EnergizingOrbBlock.box(11.0, 3.5, 3.5, 1.77, 12.5, 12.5), (VoxelShape)EnergizingOrbBlock.box(15.0, 2.5, 2.5, 16.0, 13.5, 13.5), (BooleanOp)BooleanOp.f_82695_));
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnergizingOrbTile(pos, state);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack held = player.m_21120_(hand);
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof EnergizingOrbTile) {
            EnergizingOrbTile orb = (EnergizingOrbTile)tileentity;
            Inventory inv = orb.getInventory();
            ItemStack output = inv.getStackInSlot(0);
            ItemStack off = player.m_21206_();
            if (held.m_41619_() || !output.m_41619_()) {
                if (!world.f_46443_) {
                    player.m_150109_().m_150079_(inv.removeNext());
                }
                return InteractionResult.SUCCESS;
            }
            ItemStack copy = held.m_41777_();
            copy.m_41764_(1);
            if (!inv.addNext(copy).m_41619_() && !player.m_7500_()) {
                held.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, result);
    }

    @Override
    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.search(worldIn, pos);
    }

    @Override
    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof EnergizingOrbTile) {
            EnergizingOrbTile orb = (EnergizingOrbTile)tileentity;
            return orb.getInventory().getNonEmptyStacks().size();
        }
        return super.m_6782_(state, world, pos);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        int range = Powah.config().general.energizing_range;
        List<BlockPos> list = BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).map(BlockPos::m_7949_).filter(pos1 -> !pos.equals(pos1)).collect(Collectors.toList());
        list.forEach(pos1 -> {
            BlockEntity tileEntity1 = worldIn.m_7702_(pos1);
            if (tileEntity1 instanceof EnergizingRodTile && pos.equals((Object)((EnergizingRodTile)tileEntity1).getOrbPos())) {
                ((EnergizingRodTile)tileEntity1).setOrbPos(BlockPos.f_121853_);
            }
        });
        list.forEach(pos1 -> {
            BlockState state1 = worldIn.m_8055_(pos1);
            if (state1.m_60734_() instanceof EnergizingOrbBlock) {
                ((EnergizingOrbBlock)state1.m_60734_()).search(worldIn, (BlockPos)pos1);
            }
        });
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void search(Level worldIn, BlockPos pos) {
        int range = Powah.config().general.energizing_range;
        List list = BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).map(BlockPos::m_7949_).filter(pos1 -> !pos.equals(pos1)).collect(Collectors.toList());
        list.stream().filter(p -> worldIn.m_46749_(pos)).forEach(pos1 -> {
            BlockEntity tileEntity1 = worldIn.m_7702_(pos1);
            if (tileEntity1 instanceof EnergizingRodTile && !((EnergizingRodTile)tileEntity1).hasOrb()) {
                ((EnergizingRodTile)tileEntity1).setOrbPos(pos);
            }
        });
    }

    @Override
    public boolean onWrench(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, Direction side, WrenchMode mode, Vec3 hit) {
        ItemStack stack;
        Item item;
        if (mode.link() && (item = (stack = player.m_21120_(hand)).m_41720_()) instanceof WrenchItem) {
            WrenchItem wrench = (WrenchItem)item;
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity instanceof EnergizingOrbTile) {
                CompoundTag nbt = wrench.getWrenchNBT(stack);
                if (nbt.m_128425_("RodPos", 10)) {
                    BlockPos rodPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("RodPos"));
                    BlockEntity tileEntity1 = world.m_7702_(rodPos);
                    if (tileEntity1 instanceof EnergizingRodTile) {
                        EnergizingRodTile rod = (EnergizingRodTile)tileEntity1;
                        V3d v3d = V3d.from(rodPos);
                        if ((int)v3d.distance(pos) <= Powah.config().general.energizing_range) {
                            rod.setOrbPos(pos);
                            player.m_5661_((Component)Component.m_237115_((String)"chat.powah.wrench.link.done").m_130940_(ChatFormatting.GOLD), true);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"chat.powah.wrench.link.fail").m_130940_(ChatFormatting.RED), true);
                        }
                    }
                    nbt.m_128473_("RodPos");
                } else {
                    nbt.m_128365_("OrbPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                    player.m_5661_((Component)Component.m_237115_((String)"chat.powah.wrench.link.start").m_130940_(ChatFormatting.YELLOW), true);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderHud(PoseStack matrix, BlockState state, Level world, BlockPos pos, Player player, BlockHitResult result, @Nullable BlockEntity te) {
        EnergizingOrbTile orb;
        if (te instanceof EnergizingOrbTile && (orb = (EnergizingOrbTile)te).getBuffer().getCapacity() > 0L) {
            RenderSystem.m_157191_().m_85836_();
            RenderSystem.m_69478_();
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            int x = mc.m_91268_().m_85445_() / 2;
            int y = mc.m_91268_().m_85446_();
            String s = ChatFormatting.GREEN + orb.getBuffer().getPercent() + "%";
            String s1 = ChatFormatting.GRAY + I18n.m_118938_((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(orb.getBuffer().getEnergyStored()), Util.numFormat(orb.getBuffer().getCapacity())});
            font.m_92750_(matrix, s, (float)x - (float)font.m_92895_(s) / 2.0f, (float)(y - 90), 0xFFFFFF);
            font.m_92750_(matrix, s1, (float)x - (float)font.m_92895_(s1) / 2.0f, (float)(y - 75), 0xFFFFFF);
            RenderSystem.m_69461_();
            RenderSystem.m_157191_().m_85849_();
        }
        return true;
    }
}

