/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.mods.toolkit.utils.jer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sunekaer.mods.toolkit.utils.jer.DimData;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.mutable.MutableLong;

public class Scanner
implements Runnable {
    private static final Function<Block, MutableLong> BLOCK_TO_COUNT_FUNCTION = k -> new MutableLong(0L);
    public static Scanner current;
    public final List<DimData> dimensions = new ArrayList<DimData>();
    public boolean stop;
    public final int height;
    public final int radius;
    public final int startX;
    public final int startZ;
    public final Set<Block> whitelist;
    public final boolean drops;
    public long blocksScanned;
    public Consumer<Component> callback;
    public int addToHeight;

    public Scanner(int h, int r, int sx, int sz, Set<Block> w, boolean d) {
        this.height = h;
        this.radius = r;
        this.startX = sx;
        this.startZ = sz;
        this.whitelist = w;
        this.drops = d;
        this.blocksScanned = 0L;
        this.stop = true;
    }

    @Override
    public void run() {
        long diameter = 1L + (long)this.radius * 2L;
        long area = diameter * diameter;
        long blocks = area * 256L;
        long progress = 0L;
        long percent = 0L;
        for (DimData dimData : this.dimensions) {
            if (this.stop) {
                return;
            }
            this.addToHeight = Math.abs(dimData.dimension.m_141937_());
            dimData.distribution = new HashMap[this.height + this.addToHeight];
            for (int i = 0; i < this.height + this.addToHeight; ++i) {
                dimData.distribution[i] = new HashMap();
            }
            for (int x = -this.radius; x <= this.radius; ++x) {
                for (int z = -this.radius; z <= this.radius; ++z) {
                    if (this.stop) {
                        return;
                    }
                    int cx = this.startX + x;
                    int cz = this.startZ + z;
                    LevelChunk chunk = dimData.dimension.m_6325_(cx, cz);
                    for (int bx = 0; bx < 16; ++bx) {
                        for (int bz = 0; bz < 16; ++bz) {
                            int h = Math.min(this.height, chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING).m_64242_(bx, bz));
                            for (int by = dimData.dimension.m_141937_(); by < h; ++by) {
                                BlockState state = chunk.m_8055_(new BlockPos(cx * 16 + bx, by, cz * 16 + bz));
                                int y = by + this.addToHeight;
                                if (!(state.m_60734_() instanceof AirBlock) && this.whitelist.contains(state.m_60734_())) {
                                    dimData.distribution[y].computeIfAbsent(state.m_60734_(), BLOCK_TO_COUNT_FUNCTION).increment();
                                }
                                ++this.blocksScanned;
                            }
                            ++progress;
                        }
                    }
                    long p = percent;
                    if (p == (percent = progress * 1000L / (blocks * (long)this.dimensions.size()))) continue;
                    this.callback.accept((Component)Component.m_237113_((String)("JER Scanner is running [" + (double)percent / 10.0 + "%]")));
                }
            }
        }
        if (!this.stop) {
            JsonArray array = new JsonArray();
            for (DimData data : this.dimensions) {
                HashSet<Block> dimBlocks = new HashSet<Block>();
                this.addToHeight = Math.abs(data.dimension.m_141937_());
                for (int y = 0; y < this.height + this.addToHeight; ++y) {
                    dimBlocks.addAll(data.distribution[y].keySet());
                }
                LootContext.Builder lootContext = new LootContext.Builder(data.dimension).m_230911_(data.dimension.f_46441_).m_78963_(1.0f);
                for (Block block : dimBlocks) {
                    StringBuilder sb = new StringBuilder();
                    for (int y = data.dimension.m_141937_(); y < this.height; ++y) {
                        if (y > data.dimension.m_141937_()) {
                            sb.append(';');
                        }
                        sb.append(y);
                        sb.append(',');
                        int count = y + this.addToHeight;
                        System.out.println(y + " " + count);
                        MutableLong m = data.distribution[y + this.addToHeight].get(block);
                        String b = m == null ? "0.0" : Double.toString(m.getValue().doubleValue() / (double)blocks);
                        sb.append(b.endsWith(".0") ? b.substring(0, b.length() - 2) : b);
                    }
                    JsonObject json = new JsonObject();
                    json.addProperty("block", Registry.f_122824_.m_7981_((Object)block).toString());
                    json.addProperty("dim", data.dimension.m_46472_().m_135782_().toString());
                    json.addProperty("distrib", sb.toString());
                    array.add((JsonElement)json);
                }
            }
            try {
                Files.write(FMLPaths.CONFIGDIR.get().resolve("world-gen.json"), Collections.singleton(array.toString()), new OpenOption[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        current = null;
    }

    public void stop() {
        this.stop = true;
    }
}

