/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.mods.toolkit.commands;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sunekaer.mods.toolkit.utils.jer.DimData;
import com.sunekaer.mods.toolkit.utils.jer.Scanner;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class CommandJER {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"jer").requires(cs -> cs.m_6761_(0))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"start").executes(context -> CommandJER.jerStart((CommandSourceStack)context.getSource(), false))).then(Commands.m_82129_((String)"drops", (ArgumentType)BoolArgumentType.bool()).executes(context -> CommandJER.jerStart((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"drops")))))).then(Commands.m_82127_((String)"stop").executes(context -> CommandJER.jerStop((CommandSourceStack)context.getSource())));
    }

    private static int jerStart(CommandSourceStack source, boolean drops) {
        if (Scanner.current != null) {
            source.m_81354_((Component)Component.m_237113_((String)"JER Scanner is already running!"), false);
            return 0;
        }
        Path config = FMLPaths.CONFIGDIR.get().resolve("jer-world-gen-config.json");
        if (!Files.exists(config, new LinkOption[0])) {
            try {
                JsonObject json = new JsonObject();
                JsonArray blocks = new JsonArray();
                blocks.add("#forge:ores");
                json.add("block_whitelist", (JsonElement)blocks);
                JsonObject dimensions = new JsonObject();
                for (ServerLevel world : source.m_81377_().m_129785_()) {
                    dimensions.addProperty(world.m_46472_().m_135782_().toString(), Boolean.valueOf(true));
                }
                json.add("dimensions", (JsonElement)dimensions);
                json.addProperty("height", (Number)256);
                json.addProperty("scan_radius", (Number)25);
                Files.write(config, Collections.singleton(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json)), new OpenOption[0]);
                source.m_81354_((Component)Component.m_237113_((String)"config/jer-world-gen-config.json created! After you've configured it, run this command again!"), false);
                return 0;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            int n;
            block19: {
                BufferedReader reader = Files.newBufferedReader(config);
                try {
                    JsonObject json = (JsonObject)new GsonBuilder().setLenient().create().fromJson((Reader)reader, JsonObject.class);
                    int height = Mth.m_14045_((int)json.get("height").getAsInt(), (int)16, (int)320);
                    int radius = Mth.m_14045_((int)json.get("scan_radius").getAsInt(), (int)1, (int)200);
                    int startX = Mth.m_14107_((double)source.m_81371_().f_82479_) >> 4;
                    int startZ = Mth.m_14107_((double)source.m_81371_().f_82481_) >> 4;
                    HashSet<Block> blocks = new HashSet<Block>();
                    for (Object e : json.get("block_whitelist").getAsJsonArray()) {
                        String s = e.getAsString();
                        if (s.startsWith("#")) {
                            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(s.substring(1)));
                            if (tag.toString().isEmpty()) continue;
                            ForgeRegistries.BLOCKS.tags().getTag(tag).stream().forEach(blocks::add);
                            continue;
                        }
                        blocks.add((Block)Registry.f_122824_.m_7745_(new ResourceLocation(s)));
                    }
                    blocks.remove(Blocks.f_50016_);
                    Scanner.current = new Scanner(height, radius, startX, startZ, blocks, drops);
                    JsonObject dimensions = json.get("dimensions").getAsJsonObject();
                    for (ServerLevel world : source.m_81377_().m_129785_()) {
                        String id = world.m_46472_().m_135782_().toString();
                        if (!dimensions.has(id) || !dimensions.get(id).getAsBoolean()) continue;
                        Scanner.current.dimensions.add(new DimData(Scanner.current, world));
                    }
                    Scanner.current.stop = false;
                    if (source.m_81373_() instanceof Player) {
                        Player p = (Player)source.m_81373_();
                        Scanner.current.callback = text -> p.m_5661_(text, true);
                    } else {
                        Scanner.current.callback = text -> source.m_81354_(text, false);
                    }
                    Util.m_183992_().execute(Scanner.current);
                    source.m_81354_((Component)Component.m_237113_((String)"JER Scanner started!"), false);
                    n = 1;
                    if (reader == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ((Reader)reader).close();
            }
            return n;
        }
        return 0;
    }

    private static int jerStop(CommandSourceStack source) {
        if (Scanner.current != null) {
            Scanner.current.stop();
            Scanner.current = null;
            source.m_81354_((Component)Component.m_237113_((String)"JER Scanner stopped!"), false);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"JER Scanner isn't running!"));
        return 0;
    }
}

