/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.mods.toolkit.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.common.Tags;

public class CommandClear {
    private static final AtomicBoolean COMPLETED = new AtomicBoolean(true);
    public static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(cs -> cs.m_6761_(2))).executes(context -> CommandClear.remove((CommandSourceStack)context.getSource(), 1, RemovalPredicate.NAMES[0]))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"range", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandClear.remove((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range"), RemovalPredicate.NAMES[0]))).then(Commands.m_82129_((String)"filter", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.m_82967_((String[])RemovalPredicate.NAMES, (SuggestionsBuilder)suggestionsBuilder)).executes(ctx -> CommandClear.remove((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range"), StringArgumentType.getString((CommandContext)ctx, (String)"filter")))));
    }

    private static int remove(CommandSourceStack source, int size, String filter) throws CommandSyntaxException {
        if (!COMPLETED.get()) {
            source.m_81352_((Component)Component.m_237113_((String)"Already running, give it a second."));
            return 1;
        }
        COMPLETED.set(false);
        ServerPlayer player = source.m_81375_();
        RemovalPredicate removalCheck = RemovalPredicate.getFromName(filter).orElse(RemovalPredicate.JUST_ORES);
        Predicate<BlockState> customCheck = null;
        if (filter.startsWith("#")) {
            customCheck = state -> state.m_204336_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(filter.replace("#", ""))));
        } else if (filter.contains(":")) {
            customCheck = state -> Registry.f_122824_.m_7981_((Object)state.m_60734_()).toString().equalsIgnoreCase(filter);
        }
        ServerLevel level = source.m_81372_();
        source.m_81354_((Component)Component.m_237115_((String)"commands.toolkit.remove.lagwarring"), true);
        int range = size - 1;
        ChunkPos chunkPos = player.m_146902_();
        Predicate<BlockState> finalCustomCheck = customCheck;
        level.m_7654_().m_18707_(() -> CommandClear.removeArea(level, range, chunkPos, finalCustomCheck, removalCheck));
        COMPLETED.set(false);
        return 1;
    }

    private static void removeArea(ServerLevel level, int range, ChunkPos chunkPos, Predicate<BlockState> check, RemovalPredicate removalCheck) {
        for (int x = chunkPos.f_45578_ - range; x <= chunkPos.f_45578_ + range; ++x) {
            for (int z = chunkPos.f_45579_ - range; z <= chunkPos.f_45579_ + range; ++z) {
                ChunkPos currentChunkPos = new ChunkPos(x, z);
                CommandClear.removeChunk(level, currentChunkPos, check != null ? check : removalCheck.stateCheck);
            }
        }
        COMPLETED.set(true);
    }

    private static void removeChunk(ServerLevel level, ChunkPos chunkPos, Predicate<BlockState> blockCheck) {
        LevelChunk chunk = level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        List<LevelChunkSection> sections = Arrays.stream(chunk.m_7103_()).filter(e -> !e.m_188008_()).toList();
        for (LevelChunkSection section : sections) {
            for (int y = section.m_63017_(); y < section.m_63017_() + 16; ++y) {
                for (int x = chunkPos.f_45578_ << 4; x < (chunkPos.f_45578_ << 4) + 16; ++x) {
                    for (int z = chunkPos.f_45579_ << 4; z < (chunkPos.f_45579_ << 4) + 16; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = level.m_8055_(pos);
                        if (state.m_60795_() || state.m_60734_() == Blocks.f_50752_ || blockCheck.test(state)) continue;
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
        }
    }

    private static enum RemovalPredicate {
        JUST_ORES(state -> state.m_204336_(Tags.Blocks.ORES)),
        ORES_AND_MODDED(state -> state.m_204336_(Tags.Blocks.ORES) && Registry.f_122824_.m_7981_((Object)state.m_60734_()).m_135827_().equals("minecraft"));

        public static final List<RemovalPredicate> VALUES;
        public static final String[] NAMES;
        final Predicate<BlockState> stateCheck;

        private RemovalPredicate(Predicate<BlockState> stateCheck) {
            this.stateCheck = stateCheck;
        }

        public static Optional<RemovalPredicate> getFromName(String name) {
            return VALUES.stream().filter(e -> e.toString().toLowerCase().equals(name)).findFirst();
        }

        static {
            VALUES = Arrays.asList(RemovalPredicate.values());
            NAMES = (String[])VALUES.stream().map(e -> e.toString().toLowerCase()).toArray(String[]::new);
        }
    }

    private record RangeBounds(int minX, int maxX, int minZ, int maxZ) {
        public static RangeBounds from(ChunkPos pos, int range) {
            return new RangeBounds(pos.f_45578_ - range << 4, (pos.f_45578_ + range << 4) + 16, pos.f_45579_ - range << 4, (pos.f_45579_ + range << 4) + 16);
        }
    }
}

