/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.codexadrian.spirit.data.TagAndListSetCodec;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;

public record SoulfireMultiblock(List<List<String>> pattern, Map<String, StrippedBlockPredicate> keys) {
    public static final Codec<List<List<String>>> PATTERN_CODEC = Codec.STRING.listOf().listOf().flatXmap(lists -> {
        if (SoulfireMultiblock.shouldFail(lists)) {
            return DataResult.error((String)"Size invalid");
        }
        return DataResult.success((Object)lists);
    }, lists -> {
        if (SoulfireMultiblock.shouldFail(lists)) {
            return DataResult.error((String)"Size invalid");
        }
        return DataResult.success((Object)lists);
    });
    public static final Codec<SoulfireMultiblock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PATTERN_CODEC.fieldOf("pattern").forGetter(SoulfireMultiblock::pattern), (App)Codec.unboundedMap((Codec)Codec.STRING, StrippedBlockPredicate.CODEC).fieldOf("keys").forGetter(SoulfireMultiblock::keys)).apply((Applicative)instance, SoulfireMultiblock::new));
    public static HashMap<String, StrippedBlockPredicate> RESERVED_VALUES = new HashMap();
    public static final SoulfireMultiblock DEFAULT_RECIPE;

    public boolean validateMultiblock(BlockPos blockPos, ServerLevel level, boolean breakBlock) {
        BlockPos fireCoordinate = new BlockPos(0, 0, 0);
        for (int y = this.pattern.size() - 1; y >= 0; --y) {
            block1: for (int x = 0; x < this.pattern.get(0).size(); ++x) {
                char[] chars = this.pattern.get(y).get(x).toCharArray();
                for (int z = 0; z < chars.length; ++z) {
                    if (chars[z] != '@') continue;
                    fireCoordinate = new BlockPos(x, y, z);
                    continue block1;
                }
            }
        }
        HashMap<BlockPos, Character> placementMap = new HashMap<BlockPos, Character>();
        for (int y = this.pattern.size() - 1; y >= 0; --y) {
            for (int x = 0; x < this.pattern.get(0).size(); ++x) {
                char[] chars = this.pattern.get(y).get(x).toCharArray();
                for (int z = 0; z < chars.length; ++z) {
                    placementMap.put(blockPos.m_7918_(x - fireCoordinate.m_123341_(), fireCoordinate.m_123342_() - y, z - fireCoordinate.m_123343_()).m_7949_(), Character.valueOf(chars[z]));
                }
            }
        }
        for (Map.Entry block : placementMap.entrySet()) {
            String key = String.valueOf(block.getValue());
            StrippedBlockPredicate blockPredicate = this.keys.get(key);
            if (blockPredicate == null) {
                blockPredicate = RESERVED_VALUES.get(key);
            }
            if (blockPredicate != null && blockPredicate.matches(level, (BlockPos)block.getKey())) continue;
            return false;
        }
        if (breakBlock) {
            for (Map.Entry block : placementMap.entrySet()) {
                String key = String.valueOf(block.getValue());
                StrippedBlockPredicate blockPredicate = this.keys.get(key);
                if (blockPredicate == null) {
                    blockPredicate = RESERVED_VALUES.get(key);
                }
                if (blockPredicate == null || !blockPredicate.matches(level, (BlockPos)block.getKey())) continue;
                level.m_46961_((BlockPos)block.getKey(), false);
            }
        }
        return true;
    }

    public static boolean shouldFail(List<List<String>> lists) {
        for (List<String> list : lists) {
            for (String s : list) {
                if (s.length() == list.size()) continue;
                return true;
            }
        }
        return false;
    }

    static {
        RESERVED_VALUES.put("@", new StrippedBlockPredicate(Optional.of(HolderSet.m_205809_((Holder[])new Holder[]{Blocks.f_50084_.m_204297_()})), Optional.empty()));
        RESERVED_VALUES.put("&", new StrippedBlockPredicate(Optional.of(Registry.f_122824_.m_203561_(BlockTags.f_13085_)), Optional.empty()));
        RESERVED_VALUES.put(" ", StrippedBlockPredicate.ANY);
        DEFAULT_RECIPE = new SoulfireMultiblock(List.of(List.of("@"), List.of("&")), Map.of());
    }

    public record StrippedBlockPredicate(Optional<HolderSet<Block>> blocks, Optional<CompoundTag> nbtTag) {
        public static final StrippedBlockPredicate ANY = new StrippedBlockPredicate(Optional.empty(), Optional.empty());
        public static final Codec<StrippedBlockPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagAndListSetCodec.of(Registry.f_122824_).optionalFieldOf("block").forGetter(StrippedBlockPredicate::blocks), (App)CompoundTag.f_128325_.optionalFieldOf("nbtTag").forGetter(StrippedBlockPredicate::nbtTag)).apply((Applicative)instance, StrippedBlockPredicate::new));

        public boolean matches(ServerLevel serverLevel, BlockPos blockPos) {
            BlockEntity blockEntity;
            if (this.blocks().isPresent() && !serverLevel.m_8055_(blockPos).m_204341_(this.blocks().get())) {
                return false;
            }
            if (this.nbtTag().isPresent() && (blockEntity = serverLevel.m_7702_(blockPos)) != null) {
                return new NbtPredicate(this.nbtTag().get()).m_57483_((Tag)blockEntity.m_187480_());
            }
            return true;
        }
    }
}

