/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import me.codexadrian.spirit.data.SyncedData;
import me.codexadrian.spirit.data.TagAndListSetCodec;
import me.codexadrian.spirit.registry.SpiritMisc;
import me.codexadrian.spirit.utils.CodecUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public record PedestalRecipe(ResourceLocation id, HolderSet<EntityType<?>> entityInput, Optional<Ingredient> activationItem, boolean consumesActivator, List<Ingredient> ingredients, EntityType<?> entityOutput, int duration, boolean shouldSummon, Optional<CompoundTag> outputNbt) implements SyncedData
{
    public static Codec<PedestalRecipe> codec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)id), (App)TagAndListSetCodec.of(Registry.f_122826_).fieldOf("entityInput").forGetter(PedestalRecipe::entityInput), (App)CodecUtils.INGREDIENT_CODEC.optionalFieldOf("activatorItem").forGetter(PedestalRecipe::activationItem), (App)Codec.BOOL.fieldOf("consumesActivator").orElse((Object)false).forGetter(PedestalRecipe::consumesActivator), (App)CodecUtils.INGREDIENT_CODEC.listOf().fieldOf("itemInputs").forGetter(PedestalRecipe::ingredients), (App)Registry.f_122826_.m_194605_().fieldOf("entityOutput").forGetter(PedestalRecipe::entityOutput), (App)Codec.INT.fieldOf("duration").orElse((Object)60).forGetter(PedestalRecipe::duration), (App)Codec.BOOL.fieldOf("shouldSummonMob").orElse((Object)false).forGetter(PedestalRecipe::shouldSummon), (App)CompoundTag.f_128325_.optionalFieldOf("outputNbt").forGetter(PedestalRecipe::outputNbt)).apply((Applicative)instance, PedestalRecipe::new));
    }

    public ResourceLocation m_6423_() {
        return this.id();
    }

    public RecipeSerializer<?> m_7707_() {
        return SpiritMisc.SOUL_TRANSMUTATION_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return SpiritMisc.SOUL_TRANSMUTATION_RECIPE.get();
    }

    public static List<PedestalRecipe> getRecipesForEntity(EntityType<?> entity, ItemStack stack, RecipeManager manager) {
        return manager.m_44013_(SpiritMisc.SOUL_TRANSMUTATION_RECIPE.get()).stream().filter(recipe -> {
            boolean stackMatches = recipe.activationItem().isPresent() ? recipe.activationItem().get().test(stack) : stack.m_41619_();
            return recipe.entityInput().m_203333_((Holder)entity.m_204041_()) && stackMatches;
        }).toList();
    }

    public static Optional<PedestalRecipe> getEffect(String id, RecipeManager manager) {
        return manager.m_44043_(ResourceLocation.m_135820_((String)id));
    }
}

