/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.data.traits;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.codexadrian.spirit.data.MobTrait;
import me.codexadrian.spirit.data.MobTraitSerializer;
import me.codexadrian.spirit.data.ToolType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public record ExplosionTrait(float power, Explosion.BlockInteraction blockInteraction) implements MobTrait<ExplosionTrait>
{
    public static final Serializer SERIALIZER = new Serializer();

    @Override
    public void onHitEntity(ToolType type, Entity attacker, Entity victim) {
        victim.f_19853_.m_46511_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), this.power(), this.blockInteraction());
    }

    @Override
    public void onHitBlock(ToolType type, Entity entity, BlockState blockState, Level level, BlockPos pos) {
        entity.f_19853_.m_46511_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.power(), this.blockInteraction());
        if (type == ToolType.BOW) {
            entity.m_146870_();
        }
    }

    @Override
    public MobTraitSerializer<ExplosionTrait> serializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements MobTraitSerializer<ExplosionTrait> {
        public static final Codec<ExplosionTrait> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("power").forGetter(ExplosionTrait::power), (App)Codec.STRING.xmap(Explosion.BlockInteraction::valueOf, Enum::toString).fieldOf("interaction").orElse((Object)Explosion.BlockInteraction.NONE).forGetter(ExplosionTrait::blockInteraction)).apply((Applicative)instance, ExplosionTrait::new));

        private Serializer() {
        }

        @Override
        public ResourceLocation id() {
            return new ResourceLocation("spirit", "explosion");
        }

        @Override
        public Codec<ExplosionTrait> codec() {
            return CODEC;
        }
    }
}

