/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.compat.rei.categories;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.codexadrian.spirit.compat.jei.multiblock.SoulEngulfingRecipeWrapper;
import me.codexadrian.spirit.compat.rei.displays.SoulEngulfingDisplay;
import me.codexadrian.spirit.registry.SpiritItems;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SoulEngulfingCategory
implements DisplayCategory<SoulEngulfingDisplay> {
    public static final ResourceLocation GUI_BACKGROUND = new ResourceLocation("spirit", "textures/gui/soul_engulfing.png");
    public static final ResourceLocation ID = new ResourceLocation("spirit", "soul_engulfing");
    public static final CategoryIdentifier<SoulEngulfingDisplay> RECIPE = CategoryIdentifier.of((ResourceLocation)ID);
    private static final double OFFSET = Math.sqrt(512.0) * 0.5;
    private int scale = 10;
    public long lastTime = System.currentTimeMillis();
    private final BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
    private int xOffset = 0;
    private int yOffset = 0;

    public Renderer getIcon() {
        return EntryStacks.of((ItemStack)SpiritItems.SOUL_CRYSTAL.get().m_7968_());
    }

    public Component getTitle() {
        return Component.m_237115_((String)"spirit.jei.soul_engulfing.title");
    }

    public CategoryIdentifier<? extends SoulEngulfingDisplay> getCategoryIdentifier() {
        return RECIPE;
    }

    public int getDisplayWidth(SoulEngulfingDisplay display) {
        return 158;
    }

    public int getDisplayHeight() {
        return 108;
    }

    public List<Widget> setupDisplay(final SoulEngulfingDisplay display, Rectangle bounds) {
        this.scale = 10 - (display.getWrapper().getMultiblock().pattern().get(0).size() * 2 - 6);
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        final int startX = bounds.getCenterX() - 75;
        final int startY = bounds.getCenterY() - 50;
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)GUI_BACKGROUND, (int)startX, (int)startY, (int)150, (int)100));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + 2, startY + 2)).markInput().entries((Collection)display.getInput()));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + 133, startY + 83)).markOutput().entries((Collection)display.getOutput()));
        widgets.add((Widget)new DelegateWidget((Widget)Widgets.noOp()){

            public void render(PoseStack stack, int mouseX, int mouseY, float delta) {
                stack.m_85836_();
                stack.m_85837_((double)startX, (double)startY, 0.0);
                SoulEngulfingCategory.this.draw(display.getWrapper(), stack, mouseX, mouseY);
                stack.m_85849_();
                List<Component> strings = SoulEngulfingCategory.this.getTooltipStrings(display.getWrapper(), mouseX - startX, mouseY - startY);
                if (!strings.isEmpty()) {
                    Tooltip.create((Point)new Point(mouseX, mouseY), strings).queue();
                }
            }

            public Rectangle getBounds() {
                return new Rectangle(2, 26, 103, 74);
            }

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                return SoulEngulfingCategory.this.handleInput(display.getWrapper(), keyCode, scanCode);
            }

            public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
                if (button == 1) {
                    SoulEngulfingCategory.this.xOffset = (int)((double)SoulEngulfingCategory.this.xOffset + deltaX * 0.5);
                    SoulEngulfingCategory.this.yOffset = (int)((double)SoulEngulfingCategory.this.yOffset + deltaY * 0.5);
                }
                return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
            }
        });
        widgets.add(Widgets.wrapVanillaWidget((GuiEventListener)new PlainTextButton(startX + 140, startY + 2, 20, 20, (Component)Component.m_237113_((String)"\u267a"), button -> {
            this.xOffset = 0;
            this.yOffset = 0;
            this.scale = 10 - (display.getWrapper().getMultiblock().pattern().get(0).size() * 2 - 6);
        }, Minecraft.m_91087_().f_91062_)));
        return widgets;
    }

    public List<Component> getTooltipStrings(SoulEngulfingRecipeWrapper recipe, double mouseX, double mouseY) {
        ArrayList<Component> components = new ArrayList<Component>();
        ArrayList<List<SoulEngulfingRecipeWrapper.BlockMap>> tempBlockMap = new ArrayList<List<SoulEngulfingRecipeWrapper.BlockMap>>(recipe.blockMap);
        Collections.reverse(tempBlockMap);
        if (mouseX > 1.0 && mouseX < 105.0 && mouseY > 27.0 && mouseY < 99.0) {
            for (int i = 0; i < tempBlockMap.size(); ++i) {
                components.add((Component)Component.m_237110_((String)"spirit.jei.soul_engulfing.layer", (Object[])new Object[]{i + 1}).m_130940_(ChatFormatting.DARK_GRAY));
                for (SoulEngulfingRecipeWrapper.BlockMap blockMap : tempBlockMap.get(i)) {
                    components.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)blockMap.blocks().getCurrent().m_49954_()).m_130940_(ChatFormatting.GRAY));
                }
            }
            if (recipe.getRecipe().breaksBlocks()) {
                components.add((Component)Component.m_237115_((String)"spirit.jei.soul_engulfing.consumes").m_130940_(ChatFormatting.RED));
            }
        }
        if (mouseX > 107.0 && mouseX < 129.0 && mouseY > 83.0 && mouseY < 98.0) {
            components.add((Component)Component.m_237110_((String)"spirit.jei.soul_engulfing.duration", (Object[])new Object[]{(double)recipe.getRecipe().duration() * 0.05}));
        }
        return components;
    }

    public void draw(SoulEngulfingRecipeWrapper recipe, PoseStack stack, double mouseX, double mouseY) {
        long l = System.currentTimeMillis();
        if (this.lastTime + 1500L <= l && !Screen.m_96638_()) {
            recipe.tick();
            this.lastTime = l;
        }
        try (CloseableScissors ignored = Widget.scissor((PoseStack)stack, (Rectangle)new Rectangle(2, 26, 103, 74));){
            stack.m_85836_();
            Lighting.m_84930_();
            float scaled = 1.6f * (float)this.scale;
            double width = (double)recipe.getMultiblock().pattern().get(0).size() * OFFSET * (double)(scaled / 16.0f);
            double height = (double)(recipe.blockMap.size() * 16) + (66.0 - (double)recipe.blockMap.size() * OFFSET * (double)(scaled / 16.0f));
            stack.m_85837_(52.0 - width + (double)this.xOffset, height + (double)this.yOffset - (double)((16.0f - scaled) / 16.0f * 48.0f), 100.0);
            stack.m_85841_(scaled, -scaled, 1.0f);
            stack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
            stack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            for (int i = 0; i < Math.min(recipe.blockMap.size(), recipe.layer); ++i) {
                for (SoulEngulfingRecipeWrapper.BlockMap blockMap : recipe.blockMap.get(i)) {
                    stack.m_85836_();
                    stack.m_85837_((double)blockMap.pos().m_123341_(), (double)blockMap.pos().m_123342_(), (double)blockMap.pos().m_123343_());
                    this.dispatcher.m_110912_(blockMap.blocks().getCurrent().m_49966_(), stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
                    stack.m_85849_();
                }
            }
            bufferSource.m_109911_();
            stack.m_85849_();
            Lighting.m_84931_();
        }
    }

    public boolean handleInput(SoulEngulfingRecipeWrapper recipe, int keyCode, int scanCode) {
        if (keyCode == 265) {
            recipe.layer = Math.min(recipe.layer + 1, recipe.blockMap.size());
            return true;
        }
        if (keyCode == 264) {
            recipe.layer = Math.max(recipe.layer - 1, 0);
            return true;
        }
        if (keyCode == 45) {
            this.scale = Math.max(this.scale - 1, 1);
            return true;
        }
        if (keyCode == 61) {
            this.scale = Math.min(this.scale + 1, 20);
            return true;
        }
        return false;
    }
}

