/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.compat.rei.categories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import me.codexadrian.spirit.compat.jei.ingredients.EntityIngredient;
import me.codexadrian.spirit.compat.rei.SpiritPlugin;
import me.codexadrian.spirit.compat.rei.displays.PedestalDisplay;
import me.codexadrian.spirit.recipe.PedestalRecipe;
import me.codexadrian.spirit.registry.SpiritBlocks;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class PedestalRecipeCategory
implements DisplayCategory<PedestalDisplay> {
    public static final ResourceLocation GUI_BACKGROUND = new ResourceLocation("spirit", "textures/gui/soul_transmutation.png");
    public static final ResourceLocation ID = new ResourceLocation("spirit", "soul_transmutation");
    public static final CategoryIdentifier<PedestalDisplay> RECIPE = CategoryIdentifier.of((ResourceLocation)ID);
    private static final List<int[]> slots = List.of(new int[]{32, 11}, new int[]{55, 18}, new int[]{62, 41}, new int[]{55, 64}, new int[]{32, 71}, new int[]{9, 64}, new int[]{2, 49}, new int[]{9, 18});

    public Renderer getIcon() {
        return EntryStacks.of((ItemStack)SpiritBlocks.SOUL_PEDESTAL.get().m_5456_().m_7968_());
    }

    public Component getTitle() {
        return Component.m_237115_((String)"spirit.jei.soul_transmutation.title");
    }

    public CategoryIdentifier<? extends PedestalDisplay> getCategoryIdentifier() {
        return RECIPE;
    }

    public int getDisplayWidth(PedestalDisplay display) {
        return 158;
    }

    public int getDisplayHeight() {
        return 108;
    }

    public List<Widget> setupDisplay(PedestalDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int startX = bounds.getCenterX() - 75;
        int startY = bounds.getCenterY() - 50;
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)GUI_BACKGROUND, (int)startX, (int)startY, (int)150, (int)100));
        PedestalRecipe recipe = display.recipe();
        for (int i = 0; i < Math.min(recipe.ingredients().size(), 8); ++i) {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + slots.get(i)[0], startY + slots.get(i)[1])).markInput().entries((Collection)EntryIngredients.ofIngredient((Ingredient)recipe.ingredients().get(i))));
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("Corrupted", true);
        List<EntityIngredient> entityTypes = recipe.entityInput().m_203614_().filter(Holder::m_203633_).map(Holder::m_203334_).map(type -> new EntityIngredient((EntityType<?>)type, 45.0f, Optional.of(nbt))).toList();
        if (recipe.activationItem().isPresent()) {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + 93, startY + 21)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)recipe.activationItem().get()).map(stack -> {
                if (recipe.consumesActivator()) {
                    stack.tooltip(new Component[]{Component.m_237115_((String)"spirit.jei.soul_transmutation.consumes").m_130940_(ChatFormatting.RED)});
                }
                return stack;
            })));
        } else {
            widgets.add(Widgets.createTooltip((Rectangle)new Rectangle(startX + 93, startY + 21, 18, 18), (Component[])new Component[]{Component.m_237115_((String)"spirit.jei.soul_transmutation.empty_hand")}));
        }
        widgets.add((Widget)Widgets.createSlot((Rectangle)new Rectangle(startX + 28 - 1, startY + 37 - 1, 26, 26)).markInput().disableBackground().entries((Collection)EntryIngredients.of(SpiritPlugin.ENTITY_INGREDIENT, entityTypes)));
        widgets.add((Widget)Widgets.createSlot((Rectangle)new Rectangle(startX + 124 - 1, startY + 37 - 1, 26, 26)).markOutput().disableBackground().entry(EntryStack.of(SpiritPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.entityOutput(), -45.0f, recipe.shouldSummon() ? Optional.empty() : Optional.of(nbt)))));
        return widgets;
    }
}

