/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.compat.jei.categories;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import me.codexadrian.spirit.compat.jei.categories.BaseCategory;
import me.codexadrian.spirit.compat.jei.multiblock.SoulEngulfingRecipeWrapper;
import me.codexadrian.spirit.recipe.SoulEngulfingRecipe;
import me.codexadrian.spirit.recipe.SoulfireMultiblock;
import me.codexadrian.spirit.registry.SpiritItems;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;

public class SoulEngulfingCategory
extends BaseCategory<SoulEngulfingRecipeWrapper> {
    public static final ResourceLocation GUI_BACKGROUND = new ResourceLocation("spirit", "textures/gui/soul_engulfing.png");
    public static final ResourceLocation ID = new ResourceLocation("spirit", "soul_engulfing");
    public static final RecipeType<SoulEngulfingRecipeWrapper> RECIPE = new RecipeType(ID, SoulEngulfingRecipeWrapper.class);
    private static final double OFFSET = Math.sqrt(512.0) * 0.5;
    private int scale = 10;
    public long lastTime = System.currentTimeMillis();
    private final BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();

    public SoulEngulfingCategory(IGuiHelper guiHelper) {
        super(guiHelper, RECIPE, (Component)Component.m_237115_((String)"spirit.jei.soul_engulfing.title"), (IDrawable)guiHelper.drawableBuilder(GUI_BACKGROUND, 0, 0, 150, 100).build(), guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)SpiritItems.SOUL_CRYSTAL.get().m_7968_()));
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, SoulEngulfingRecipeWrapper wrapper, @NotNull IFocusGroup focuses) {
        SoulEngulfingRecipe recipe = wrapper.getRecipe();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Collection<SoulfireMultiblock.StrippedBlockPredicate> blocks = recipe.input().multiblock().keys().values();
        List holderSets = blocks.stream().flatMap(predicate -> {
            if (predicate.blocks().isPresent()) {
                return predicate.blocks().get().m_203614_();
            }
            return Stream.of(new Holder[0]);
        }).toList();
        for (Holder holderSet : holderSets) {
            items.add(((Block)holderSet.m_203334_()).m_5456_().m_7968_());
        }
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addIngredients(Ingredient.m_43921_(items.stream()));
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).addIngredients(recipe.input().item());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 133, 83).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.m_8043_());
    }

    public List<Component> getTooltipStrings(SoulEngulfingRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> components = new ArrayList<Component>();
        ArrayList<List<SoulEngulfingRecipeWrapper.BlockMap>> tempBlockMap = new ArrayList<List<SoulEngulfingRecipeWrapper.BlockMap>>(recipe.blockMap);
        Collections.reverse(tempBlockMap);
        if (mouseX > 1.0 && mouseX < 105.0 && mouseY > 27.0 && mouseY < 99.0) {
            for (int i = 0; i < tempBlockMap.size(); ++i) {
                components.add((Component)Component.m_237110_((String)"spirit.jei.soul_engulfing.layer", (Object[])new Object[]{i + 1}).m_130940_(ChatFormatting.DARK_GRAY));
                for (SoulEngulfingRecipeWrapper.BlockMap blockMap : tempBlockMap.get(i)) {
                    components.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)blockMap.blocks().getCurrent().m_49954_()).m_130940_(ChatFormatting.GRAY));
                }
            }
            if (recipe.getRecipe().breaksBlocks()) {
                components.add((Component)Component.m_237115_((String)"spirit.jei.soul_engulfing.consumes").m_130940_(ChatFormatting.RED));
            }
        }
        if (mouseX > 107.0 && mouseX < 129.0 && mouseY > 83.0 && mouseY < 98.0) {
            components.add((Component)Component.m_237110_((String)"spirit.jei.soul_engulfing.duration", (Object[])new Object[]{(double)recipe.getRecipe().duration() * 0.05}));
        }
        return components;
    }

    public void draw(SoulEngulfingRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        long l = System.currentTimeMillis();
        if (this.lastTime + 1500L <= l && !Screen.m_96638_()) {
            recipe.tick();
            this.lastTime = l;
        }
        double guiScale = Minecraft.m_91087_().m_91268_().m_85449_();
        Matrix4f pose = stack.m_85850_().m_85861_();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)16);
        pose.m_27650_(floatBuffer);
        Vec3 translation = new Vec3((double)floatBuffer.get(12) * guiScale, (double)floatBuffer.get(13) * guiScale, (double)floatBuffer.get(14) * guiScale);
        RenderSystem.m_69488_((int)((int)(translation.f_82479_ + 2.0 * guiScale)), (int)((int)((double)Minecraft.m_91087_().m_91268_().m_85442_() - 27.0 * guiScale - translation.f_82480_ - 73.0 * guiScale)), (int)((int)(103.0 * guiScale)), (int)((int)(73.0 * guiScale)));
        stack.m_85836_();
        Lighting.m_84930_();
        float scaled = 1.6f * (float)this.scale;
        double width = (double)recipe.getMultiblock().pattern().get(0).size() * OFFSET * (double)(scaled / 16.0f);
        double height = (double)(recipe.blockMap.size() * 16) + (66.0 - (double)recipe.blockMap.size() * OFFSET);
        stack.m_85837_(52.0 - width, height, 100.0);
        stack.m_85841_(scaled, -scaled, 1.0f);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        for (int i = 0; i < Math.min(recipe.blockMap.size(), recipe.layer); ++i) {
            for (SoulEngulfingRecipeWrapper.BlockMap blockMap : recipe.blockMap.get(i)) {
                stack.m_85836_();
                stack.m_85837_((double)blockMap.pos().m_123341_(), (double)blockMap.pos().m_123342_(), (double)blockMap.pos().m_123343_());
                this.dispatcher.m_110912_(blockMap.blocks().getCurrent().m_49966_(), stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
                stack.m_85849_();
            }
        }
        bufferSource.m_109911_();
        stack.m_85849_();
        RenderSystem.m_69471_();
    }

    public boolean handleInput(SoulEngulfingRecipeWrapper recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84873_() == 265) {
            recipe.layer = Math.min(recipe.layer + 1, recipe.blockMap.size());
            return true;
        }
        if (input.m_84873_() == 264) {
            recipe.layer = Math.max(recipe.layer - 1, 0);
            return true;
        }
        if (input.m_84873_() == 45) {
            this.scale = Math.max(this.scale - 1, 1);
            return true;
        }
        if (input.m_84873_() == 61) {
            this.scale = Math.min(this.scale + 1, 20);
            return true;
        }
        return false;
    }

    public static List<SoulEngulfingRecipeWrapper> getRecipes(Collection<SoulEngulfingRecipe> recipes) {
        return recipes.stream().map(SoulEngulfingRecipeWrapper::new).toList();
    }
}

