/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.blocks.blockentity;

import java.util.ArrayList;
import java.util.Optional;
import me.codexadrian.spirit.Corrupted;
import me.codexadrian.spirit.recipe.PedestalRecipe;
import me.codexadrian.spirit.registry.SpiritBlocks;
import me.codexadrian.spirit.utils.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulPedestalBlockEntity
extends BlockEntity {
    public EntityType<?> type;
    private ItemStack item = ItemStack.f_41583_;
    @Nullable
    public Entity entity;
    @Nullable
    public PedestalRecipe containedRecipe;
    public int burnTime = 0;
    public int age;

    public SoulPedestalBlockEntity(BlockPos $$1, BlockState $$2) {
        super(SpiritBlocks.SOUL_PEDESTAL_ENTITY.get(), $$1, $$2);
    }

    public static void tick(Level level1, BlockPos blockPos, BlockState blockState1, BlockEntity blockEntity) {
        if (blockEntity instanceof SoulPedestalBlockEntity) {
            SoulPedestalBlockEntity soulPedestal = (SoulPedestalBlockEntity)blockEntity;
            soulPedestal.age = (soulPedestal.age + 1) % Integer.MAX_VALUE;
            if (soulPedestal.containedRecipe != null) {
                if (!RecipeUtils.validatePedestals(blockPos, level1, new ArrayList<Ingredient>(soulPedestal.containedRecipe.ingredients()), false)) {
                    soulPedestal.setRecipe(null);
                    return;
                }
                if (soulPedestal.burnTime < soulPedestal.containedRecipe.duration()) {
                    for (int i = 0; i < 5; ++i) {
                        double percentage;
                        if ((double)soulPedestal.burnTime < (double)soulPedestal.containedRecipe.duration() * 0.5) {
                            percentage = (double)(2 * soulPedestal.burnTime) / (double)soulPedestal.containedRecipe.duration();
                            level1.m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)blockPos.m_123341_() + 3.0 * Math.sin(percentage * 2.0 * Math.PI) + 0.5, (double)blockPos.m_123342_() + 0.75, (double)blockPos.m_123343_() + 3.0 * Math.cos(percentage * 2.0 * Math.PI) + 0.5, 0.0, 0.0, 0.0);
                            continue;
                        }
                        percentage = 2.0 * (((double)soulPedestal.burnTime - (double)soulPedestal.containedRecipe.duration() * 0.5) / (double)soulPedestal.containedRecipe.duration());
                        level1.m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)blockPos.m_123341_() + 3.0 * (1.0 - percentage) * Math.sin(percentage * 2.0 * Math.PI) + 0.5, (double)blockPos.m_123342_() + 0.75, (double)blockPos.m_123343_() + 3.0 * (1.0 - percentage) * Math.cos(percentage * 2.0 * Math.PI) + 0.5, 0.0, 0.0, 0.0);
                    }
                } else if (RecipeUtils.validatePedestals(blockPos, level1, new ArrayList<Ingredient>(soulPedestal.containedRecipe.ingredients()), true)) {
                    if (soulPedestal.containedRecipe.shouldSummon()) {
                        Entity entity = soulPedestal.containedRecipe.entityOutput().m_20615_(level1);
                        if (entity != null) {
                            entity.m_6034_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.75, (double)blockPos.m_123343_() + 0.5);
                            if (soulPedestal.containedRecipe.outputNbt().isPresent()) {
                                entity.m_20258_(soulPedestal.containedRecipe.outputNbt().get());
                            }
                            level1.m_7967_(entity);
                            for (int i = 0; i < 10; ++i) {
                                level1.m_7106_((ParticleOptions)ParticleTypes.f_123746_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0, 0.0, 0.0);
                            }
                            soulPedestal.setType(null);
                        }
                    } else {
                        soulPedestal.setType(soulPedestal.containedRecipe.entityOutput());
                    }
                    level1.m_7260_(blockPos, blockState1, blockState1, 3);
                    soulPedestal.setRecipe(null);
                }
                ++soulPedestal.burnTime;
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128441_("Soul")) {
            this.setType((EntityType)Registry.f_122826_.m_7745_(ResourceLocation.m_135820_((String)compoundTag.m_128461_("Soul"))));
        }
        if (compoundTag.m_128441_("PedestalRecipe") && this.m_58898_()) {
            Optional<PedestalRecipe> recipe = PedestalRecipe.getEffect(compoundTag.m_128461_("PedestalRecipe"), this.m_58904_().m_7465_());
            recipe.ifPresent(pedestalRecipe -> {
                this.containedRecipe = pedestalRecipe;
            });
        }
        this.burnTime = compoundTag.m_128451_("BurnTime");
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (this.type != null) {
            compoundTag.m_128359_("Soul", Registry.f_122826_.m_7981_(this.type).toString());
        }
        if (this.containedRecipe != null) {
            compoundTag.m_128359_("PedestalRecipe", this.containedRecipe.id().toString());
        }
        compoundTag.m_128405_("BurnTime", this.burnTime);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Entity getOrCreateEntity() {
        Entity entity;
        if (this.entity == null && this.m_58898_() && this.type != null && (entity = (this.entity = this.type.m_20615_(this.m_58904_()))) instanceof Corrupted) {
            Corrupted corrupted = (Corrupted)entity;
            corrupted.setCorrupted();
        }
        return this.entity;
    }

    public void setType(EntityType<?> type) {
        this.type = type;
        this.entity = null;
        this.m_6596_();
    }

    public void setRecipe(@Nullable PedestalRecipe recipe) {
        this.containedRecipe = recipe;
        if (recipe == null) {
            this.burnTime = 0;
        }
        this.m_6596_();
    }
}

