/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.blocks;

import java.util.List;
import me.codexadrian.spirit.blocks.blockentity.SoulCageBlockEntity;
import me.codexadrian.spirit.registry.SpiritBlocks;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulCageBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SoulCageBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return SpiritBlocks.SOUL_CAGE_ENTITY.get().m_155264_(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return SoulCageBlock.m_152132_(blockEntityType, SpiritBlocks.SOUL_CAGE_ENTITY.get(), SoulCageBlockEntity::tick);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        if (interactionHand != InteractionHand.OFF_HAND) {
            ItemStack itemStack = player.m_21205_();
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof SoulCageBlockEntity) {
                SoulCageBlockEntity soulSpawner = (SoulCageBlockEntity)blockEntity;
                if (soulSpawner.m_7983_()) {
                    if (SoulUtils.canCrystalBeUsedInCage(itemStack) && itemStack.m_41782_() && SoulUtils.getTier(itemStack, level) != null) {
                        soulSpawner.entity = null;
                        soulSpawner.m_6836_(0, itemStack.m_41777_());
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41764_(0);
                        }
                        soulSpawner.setType();
                        soulSpawner.update(3);
                        return InteractionResult.SUCCESS;
                    }
                } else if (player.m_6144_()) {
                    soulSpawner.entity = null;
                    soulSpawner.type = null;
                    ItemStack divineCrystal = soulSpawner.m_8016_(0);
                    player.m_150109_().m_150079_(divineCrystal);
                    soulSpawner.update(3);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState blockState, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootContext.Builder builder) {
        List drops = super.m_7381_(blockState, builder);
        BlockEntity blockE = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockE instanceof SoulCageBlockEntity) {
            drops.add(((SoulCageBlockEntity)blockE).m_8020_(0));
        }
        return drops;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }
}

