/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidType;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCAFluidType
extends FluidType
implements IMaterialFormFluidType {
    private final IMaterialFormFluid fluid;
    private final IFluidFormSettings settings;
    private OptionalInt lightValue = OptionalInt.empty();
    private OptionalInt density = OptionalInt.empty();
    private OptionalInt temperature = OptionalInt.empty();
    private OptionalInt viscosity = OptionalInt.empty();
    private Optional<Rarity> rarity = Optional.empty();
    private OptionalDouble motionScale = OptionalDouble.empty();
    private Optional<Boolean> canPushEntity = Optional.empty();
    private Optional<Boolean> canSwim = Optional.empty();
    private OptionalDouble fallDistanceModifier = OptionalDouble.empty();
    private Optional<Boolean> canExtinguish = Optional.empty();
    private Optional<Boolean> canDrown = Optional.empty();
    private Optional<Boolean> supportsBoating = Optional.empty();
    private Optional<Boolean> canHydrate = Optional.empty();
    private Optional<Boolean> canConvertToSource = Optional.empty();

    public JAOPCAFluidType(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(FluidType.Properties.create().pathType(settings.getPathTypeFunction().apply(fluid.getMaterial())).adjacentPathType(settings.getAdjacentPathTypeFunction().apply(fluid.getMaterial())).sound(SoundActions.BUCKET_FILL, settings.getFillSoundSupplier().get()).sound(SoundActions.BUCKET_EMPTY, settings.getEmptySoundSupplier().get()).sound(SoundActions.FLUID_VAPORIZE, settings.getVaporizeSoundSupplier().get()));
        this.fluid = fluid;
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return this.fluid.getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return this.fluid.getMaterial();
    }

    public FluidState getStateForPlacement(BlockAndTintGetter world, BlockPos pos, FluidStack stack) {
        return this.fluid.getSourceState();
    }

    public int getLightLevel() {
        if (!this.lightValue.isPresent()) {
            this.lightValue = OptionalInt.of(this.settings.getLightValueFunction().applyAsInt(this.getMaterial()));
        }
        return this.lightValue.getAsInt();
    }

    public int getDensity() {
        if (!this.density.isPresent()) {
            this.density = OptionalInt.of(this.settings.getDensityFunction().applyAsInt(this.getMaterial()));
        }
        return this.density.getAsInt();
    }

    public int getTemperature() {
        if (!this.temperature.isPresent()) {
            this.temperature = OptionalInt.of(this.settings.getTemperatureFunction().applyAsInt(this.getMaterial()));
        }
        return this.temperature.getAsInt();
    }

    public int getViscosity() {
        if (!this.viscosity.isPresent()) {
            this.viscosity = OptionalInt.of(this.settings.getViscosityFunction().applyAsInt(this.getMaterial()));
        }
        return this.viscosity.getAsInt();
    }

    public Rarity getRarity() {
        if (!this.rarity.isPresent()) {
            this.rarity = Optional.of(this.settings.getDisplayRarityFunction().apply(this.getMaterial()));
        }
        return this.rarity.get();
    }

    public double motionScale(Entity entity) {
        if (!this.motionScale.isPresent()) {
            this.motionScale = OptionalDouble.of(this.settings.getMotionScaleFunction().applyAsDouble(this.getMaterial()));
        }
        return this.motionScale.getAsDouble();
    }

    public boolean canPushEntity(Entity entity) {
        if (!this.canPushEntity.isPresent()) {
            this.canPushEntity = Optional.of(this.settings.getCanPushEntityFunction().test(this.getMaterial()));
        }
        return this.canPushEntity.get();
    }

    public boolean canSwim(Entity entity) {
        if (!this.canSwim.isPresent()) {
            this.canSwim = Optional.of(this.settings.getCanSwimFunction().test(this.getMaterial()));
        }
        return this.canSwim.get();
    }

    public float getFallDistanceModifier(Entity entity) {
        if (!this.fallDistanceModifier.isPresent()) {
            this.fallDistanceModifier = OptionalDouble.of(this.settings.getFallDistanceModifierFunction().applyAsDouble(this.getMaterial()));
        }
        return (float)this.fallDistanceModifier.getAsDouble();
    }

    public boolean canExtinguish(Entity entity) {
        if (!this.canExtinguish.isPresent()) {
            this.canExtinguish = Optional.of(this.settings.getCanExtinguishFunction().test(this.getMaterial()));
        }
        return this.canExtinguish.get();
    }

    public boolean canExtinguish(FluidState state, BlockGetter getter, BlockPos pos) {
        if (!this.canExtinguish.isPresent()) {
            this.canExtinguish = Optional.of(this.settings.getCanExtinguishFunction().test(this.getMaterial()));
        }
        return this.canExtinguish.get();
    }

    public boolean canDrownIn(LivingEntity entity) {
        if (!this.canDrown.isPresent()) {
            this.canDrown = Optional.of(this.settings.getCanDrownFunction().test(this.getMaterial()));
        }
        return this.canDrown.get();
    }

    public boolean supportsBoating(Boat boat) {
        if (!this.supportsBoating.isPresent()) {
            this.supportsBoating = Optional.of(this.settings.getSupportsBoatingFunction().test(this.getMaterial()));
        }
        return this.supportsBoating.get();
    }

    public boolean canHydrate(Entity entity) {
        if (!this.canHydrate.isPresent()) {
            this.canHydrate = Optional.of(this.settings.getCanHydrateFunction().test(this.getMaterial()));
        }
        return this.canHydrate.get();
    }

    public boolean canHydrate(FluidState state, BlockGetter getter, BlockPos pos, BlockState source, BlockPos sourcePos) {
        if (!this.canHydrate.isPresent()) {
            this.canHydrate = Optional.of(this.settings.getCanHydrateFunction().test(this.getMaterial()));
        }
        return this.canHydrate.get();
    }

    public boolean canHydrate(FluidStack stack) {
        if (!this.canHydrate.isPresent()) {
            this.canHydrate = Optional.of(this.settings.getCanHydrateFunction().test(this.getMaterial()));
        }
        return this.canHydrate.get();
    }

    public boolean canConvertToSource(FluidState state, LevelReader reader, BlockPos pos) {
        if (!this.canConvertToSource.isPresent()) {
            this.canConvertToSource = Optional.of(this.settings.getCanConvertToSourceFunction().test(this.getMaterial()));
        }
        return this.canConvertToSource.get();
    }

    public boolean canConvertToSource(FluidStack stack) {
        if (!this.canConvertToSource.isPresent()) {
            this.canConvertToSource = Optional.of(this.settings.getCanConvertToSourceFunction().test(this.getMaterial()));
        }
        return this.canConvertToSource.get();
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public int getTintColor() {
                return JAOPCAFluidType.this.fluid.getMaterial().getColor();
            }

            public ResourceLocation getStillTexture() {
                ResourceLocation location = ForgeRegistries.FLUIDS.getKey((Object)JAOPCAFluidType.this.fluid.asFluid());
                if (MiscHelper.INSTANCE.hasResource(new ResourceLocation(location.m_135827_(), "textures/fluid/" + location.m_135815_() + "_still.png"))) {
                    return new ResourceLocation(location.m_135827_(), "fluid/" + location.m_135815_() + "_still");
                }
                return new ResourceLocation(location.m_135827_(), "fluid/" + JAOPCAFluidType.this.fluid.getMaterial().getModelType() + "/" + JAOPCAFluidType.this.fluid.getForm().getName() + "_still");
            }

            public ResourceLocation getFlowingTexture() {
                ResourceLocation location = ForgeRegistries.FLUIDS.getKey((Object)JAOPCAFluidType.this.fluid.asFluid());
                if (MiscHelper.INSTANCE.hasResource(new ResourceLocation(location.m_135827_(), "textures/fluid/" + location.m_135815_() + "_flow.png"))) {
                    return new ResourceLocation(location.m_135827_(), "fluid/" + location.m_135815_() + "_flow");
                }
                return new ResourceLocation(location.m_135827_(), "fluid/" + JAOPCAFluidType.this.fluid.getMaterial().getModelType() + "/" + JAOPCAFluidType.this.fluid.getForm().getName() + "_flow");
            }
        });
    }

    public Component getDescription() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("fluid_type.jaopca." + this.fluid.getForm().getName(), this.fluid.getMaterial(), this.getDescriptionId());
    }

    public Component getDescription(FluidStack stack) {
        return this.getDescription();
    }
}

