/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.common.base.Function;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.Rarity;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.JsonHelper;

public class ItemFormSettingsDeserializer
implements JsonDeserializer<IItemFormSettings> {
    public static final ItemFormSettingsDeserializer INSTANCE = new ItemFormSettingsDeserializer();

    private ItemFormSettingsDeserializer() {
    }

    public IItemFormSettings deserialize(JsonElement jsonElement, JsonDeserializationContext context) {
        return this.deserialize(jsonElement, (Type)((Object)IItemFormSettings.class), context);
    }

    public IItemFormSettings deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject functionJson;
        JsonHelper helper = JsonHelper.INSTANCE;
        JsonObject json = helper.getJsonObject(jsonElement, "settings");
        IItemFormSettings settings = ItemFormType.INSTANCE.getNewSettings();
        if (json.has("maxStackSize")) {
            functionJson = helper.getJsonObject(json, "maxStackSize");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)64);
            }
            settings.setMaxStackSizeFunction((ToIntFunction)helper.deserializeType(json, "maxStackSize", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("hasEffect")) {
            boolean hasEffect = helper.getBoolean(json, "hasEffect");
            settings.setHasEffectFunction(m -> m.hasEffect() || hasEffect);
        }
        if (json.has("rarity")) {
            Rarity rarity = (Rarity)helper.deserializeType(json, "rarity", context, (Type)((Object)Rarity.class));
            settings.setDisplayRarityFunction((Function<IMaterial, Rarity>)((Function)m -> rarity));
        }
        if (json.has("burnTime")) {
            functionJson = helper.getJsonObject(json, "burnTime");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)-1);
            }
            settings.setBurnTimeFunction((ToIntFunction)helper.deserializeType(json, "burnTime", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        return settings;
    }
}

