/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.ISlurryProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IFluidStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.compat.mekanism.MekanismDataInjector;
import thelm.jaopca.compat.mekanism.recipes.CombiningRecipeSerializer;
import thelm.jaopca.compat.mekanism.recipes.CrushingRecipeSerializer;
import thelm.jaopca.compat.mekanism.recipes.CrystallizingRecipeSerializer;
import thelm.jaopca.compat.mekanism.recipes.DissolutionRecipeSerializer;
import thelm.jaopca.compat.mekanism.recipes.EnrichingRecipeSerializer;
import thelm.jaopca.compat.mekanism.recipes.InjectingRecipeSerializer;
import thelm.jaopca.compat.mekanism.recipes.PurifyingRecipeSerializer;
import thelm.jaopca.compat.mekanism.recipes.WashingRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class MekanismHelper {
    public static final MekanismHelper INSTANCE = new MekanismHelper();

    private MekanismHelper() {
    }

    public Set<ResourceLocation> getSlurryTags() {
        return ImmutableSortedSet.copyOf((Collection)Sets.union(ApiImpl.INSTANCE.getTags("mekanism:slurry"), MekanismDataInjector.getInjectSlurryTags()));
    }

    public ItemStackIngredient getItemStackIngredient(Object obj, int count) {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(obj);
        return ing == EmptyIngredient.INSTANCE ? null : IngredientCreatorAccess.item().from(ing, count);
    }

    public FluidStackIngredient getFluidStackIngredient(Object obj, int amount) {
        return (FluidStackIngredient)this.getFluidStackIngredientResolved(obj, amount).getLeft();
    }

    public Pair<FluidStackIngredient, Set<Fluid>> getFluidStackIngredientResolved(Object obj, int amount) {
        FluidStackIngredient ing = null;
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        MiscHelper helper = MiscHelper.INSTANCE;
        IFluidStackIngredientCreator creator = IngredientCreatorAccess.fluid();
        if (obj instanceof Supplier) {
            Pair<FluidStackIngredient, Set<Fluid>> pair = this.getFluidStackIngredientResolved(((Supplier)obj).get(), amount);
            ing = (FluidStackIngredient)pair.getLeft();
            fluids.addAll((Collection)pair.getRight());
        } else if (obj instanceof FluidStackIngredient) {
            ing = (FluidStackIngredient)obj;
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = (FluidStackIngredient)creator.from(helper.getFluidTagKey(location), amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = (FluidStackIngredient)creator.from(helper.getFluidTagKey(location), amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = (FluidStackIngredient)creator.from(key, amount);
            fluids.addAll(helper.getFluidTagValues(key.f_203868_()));
        } else if (obj instanceof FluidStack) {
            FluidStack stack = (FluidStack)obj;
            ing = (FluidStackIngredient)creator.from((Object)stack);
            fluids.add(stack.getFluid());
        } else if (obj instanceof FluidStack[]) {
            FluidStack[] stacks = (FluidStack[])obj;
            ing = (FluidStackIngredient)creator.createMulti((InputIngredient[])((FluidStackIngredient[])Arrays.stream(stacks).map(arg_0 -> ((IFluidStackIngredientCreator)creator).from(arg_0)).toArray(FluidStackIngredient[]::new)));
            Arrays.stream(stacks).map(FluidStack::getFluid).forEach(fluids::add);
        } else if (obj instanceof Fluid) {
            Fluid fluid = (Fluid)obj;
            ing = creator.from(fluid, amount);
            fluids.add(fluid);
        } else if (obj instanceof Fluid[]) {
            Fluid[] fluidz = (Fluid[])obj;
            ing = (FluidStackIngredient)creator.createMulti((InputIngredient[])((FluidStackIngredient[])Arrays.stream(fluidz).map(f -> creator.from(f, amount)).toArray(FluidStackIngredient[]::new)));
            Collections.addAll(fluids, fluidz);
        } else if (obj instanceof JsonElement) {
            ing = (FluidStackIngredient)creator.deserialize((JsonElement)obj);
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        }
        return Pair.of((Object)(fluids.isEmpty() ? null : ing), fluids);
    }

    public ChemicalStackIngredient.GasStackIngredient getGasStackIngredient(Object obj, int amount) {
        return (ChemicalStackIngredient.GasStackIngredient)this.getGasStackIngredientResolved(obj, amount).getLeft();
    }

    public Pair<ChemicalStackIngredient.GasStackIngredient, Set<Gas>> getGasStackIngredientResolved(Object obj, int amount) {
        ChemicalStackIngredient.GasStackIngredient ing = null;
        HashSet<Gas> gases = new HashSet<Gas>();
        MiscHelper helper = MiscHelper.INSTANCE;
        IChemicalStackIngredientCreator creator = IngredientCreatorAccess.gas();
        if (obj instanceof Supplier) {
            Pair<ChemicalStackIngredient.GasStackIngredient, Set<Gas>> pair = this.getGasStackIngredientResolved(((Supplier)obj).get(), amount);
            ing = (ChemicalStackIngredient.GasStackIngredient)pair.getLeft();
            gases.addAll((Collection)pair.getRight());
        } else if (obj instanceof ChemicalStackIngredient.GasStackIngredient) {
            ing = (ChemicalStackIngredient.GasStackIngredient)obj;
            gases.addAll(MekanismAPI.gasRegistry().getValues());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = (ChemicalStackIngredient.GasStackIngredient)creator.from(this.getGasTagKey(location), amount);
            gases.addAll(this.getGasTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = (ChemicalStackIngredient.GasStackIngredient)creator.from(this.getGasTagKey(location), amount);
            gases.addAll(this.getGasTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = (ChemicalStackIngredient.GasStackIngredient)creator.from(key, amount);
            gases.addAll(this.getGasTagValues(key.f_203868_()));
        } else if (obj instanceof GasStack) {
            GasStack stack = (GasStack)obj;
            ing = (ChemicalStackIngredient.GasStackIngredient)creator.from((ChemicalStack)stack);
            gases.add((Gas)stack.getType());
        } else if (obj instanceof GasStack[]) {
            GasStack[] stacks = (GasStack[])obj;
            ing = (ChemicalStackIngredient.GasStackIngredient)creator.createMulti((InputIngredient[])((ChemicalStackIngredient.GasStackIngredient[])Arrays.stream(stacks).map(arg_0 -> ((IChemicalStackIngredientCreator)creator).from(arg_0)).toArray(ChemicalStackIngredient.GasStackIngredient[]::new)));
            Arrays.stream(stacks).map(ChemicalStack::getType).forEach(gases::add);
        } else if (obj instanceof IGasProvider) {
            IGasProvider gas = (IGasProvider)obj;
            ing = (ChemicalStackIngredient.GasStackIngredient)creator.from((IChemicalProvider)gas, (long)amount);
            gases.add((Gas)gas.getChemical());
        } else if (obj instanceof IGasProvider[]) {
            IGasProvider[] gasez = (IGasProvider[])obj;
            ing = (ChemicalStackIngredient.GasStackIngredient)creator.createMulti((InputIngredient[])((ChemicalStackIngredient.GasStackIngredient[])Arrays.stream(gasez).map(g -> (ChemicalStackIngredient.GasStackIngredient)creator.from((IChemicalProvider)g, (long)amount)).toArray(ChemicalStackIngredient.GasStackIngredient[]::new)));
            Arrays.stream(gasez).map(IChemicalProvider::getChemical).forEach(gases::add);
        } else if (obj instanceof JsonElement) {
            ing = (ChemicalStackIngredient.GasStackIngredient)creator.deserialize((JsonElement)obj);
            gases.addAll(MekanismAPI.gasRegistry().getValues());
        }
        return Pair.of((Object)(gases.isEmpty() ? null : ing), gases);
    }

    public ChemicalStackIngredient.SlurryStackIngredient getSlurryStackIngredient(Object obj, int amount) {
        return (ChemicalStackIngredient.SlurryStackIngredient)this.getSlurryStackIngredientResolved(obj, amount).getLeft();
    }

    public Pair<ChemicalStackIngredient.SlurryStackIngredient, Set<Slurry>> getSlurryStackIngredientResolved(Object obj, int amount) {
        ChemicalStackIngredient.SlurryStackIngredient ing = null;
        HashSet<Slurry> slurries = new HashSet<Slurry>();
        MiscHelper helper = MiscHelper.INSTANCE;
        IChemicalStackIngredientCreator creator = IngredientCreatorAccess.slurry();
        if (obj instanceof Supplier) {
            Pair<ChemicalStackIngredient.SlurryStackIngredient, Set<Slurry>> pair = this.getSlurryStackIngredientResolved(((Supplier)obj).get(), amount);
            ing = (ChemicalStackIngredient.SlurryStackIngredient)pair.getLeft();
            slurries.addAll((Collection)pair.getRight());
        } else if (obj instanceof ChemicalStackIngredient.SlurryStackIngredient) {
            ing = (ChemicalStackIngredient.SlurryStackIngredient)obj;
            slurries.addAll(MekanismAPI.slurryRegistry().getValues());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = (ChemicalStackIngredient.SlurryStackIngredient)creator.from(this.getSlurryTagKey(location), amount);
            slurries.addAll(this.getSlurryTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = (ChemicalStackIngredient.SlurryStackIngredient)creator.from(this.getSlurryTagKey(location), amount);
            slurries.addAll(this.getSlurryTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = (ChemicalStackIngredient.SlurryStackIngredient)creator.from(key, amount);
            slurries.addAll(this.getSlurryTagValues(key.f_203868_()));
        } else if (obj instanceof SlurryStack) {
            SlurryStack stack = (SlurryStack)obj;
            ing = (ChemicalStackIngredient.SlurryStackIngredient)creator.from((ChemicalStack)stack);
            slurries.add((Slurry)stack.getType());
        } else if (obj instanceof SlurryStack[]) {
            SlurryStack[] stacks = (SlurryStack[])obj;
            ing = (ChemicalStackIngredient.SlurryStackIngredient)creator.createMulti((InputIngredient[])((ChemicalStackIngredient.SlurryStackIngredient[])Arrays.stream(stacks).map(arg_0 -> ((IChemicalStackIngredientCreator)creator).from(arg_0)).toArray(ChemicalStackIngredient.SlurryStackIngredient[]::new)));
            Arrays.stream(stacks).map(ChemicalStack::getType).forEach(slurries::add);
        } else if (obj instanceof ISlurryProvider) {
            ISlurryProvider slurry = (ISlurryProvider)obj;
            ing = (ChemicalStackIngredient.SlurryStackIngredient)creator.from((IChemicalProvider)slurry, (long)amount);
            slurries.add((Slurry)slurry.getChemical());
        } else if (obj instanceof ISlurryProvider[]) {
            ISlurryProvider[] slurriez = (ISlurryProvider[])obj;
            ing = (ChemicalStackIngredient.SlurryStackIngredient)creator.createMulti((InputIngredient[])((ChemicalStackIngredient.SlurryStackIngredient[])Arrays.stream(slurriez).map(s -> (ChemicalStackIngredient.SlurryStackIngredient)creator.from((IChemicalProvider)s, (long)amount)).toArray(ChemicalStackIngredient.SlurryStackIngredient[]::new)));
            Arrays.stream(slurriez).map(IChemicalProvider::getChemical).forEach(slurries::add);
        } else if (obj instanceof JsonElement) {
            ing = (ChemicalStackIngredient.SlurryStackIngredient)creator.deserialize((JsonElement)obj);
            slurries.addAll(MekanismAPI.slurryRegistry().getValues());
        }
        return Pair.of((Object)(slurries.isEmpty() ? null : ing), slurries);
    }

    public GasStack getGasStack(Object obj, int amount) {
        GasStack ret = this.getPreferredGasStack((Iterable)this.getGasStackIngredientResolved(obj, amount).getRight(), amount);
        return ret.isEmpty() ? GasStack.EMPTY : ret;
    }

    public SlurryStack getSlurryStack(Object obj, int amount) {
        SlurryStack ret = this.getPreferredSlurryStack((Iterable)this.getSlurryStackIngredientResolved(obj, amount).getRight(), amount);
        return ret.isEmpty() ? SlurryStack.EMPTY : ret;
    }

    public boolean registerCrushingRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CrushingRecipeSerializer(key, input, inputCount, output, outputCount));
    }

    public boolean registerEnrichingRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new EnrichingRecipeSerializer(key, input, inputCount, output, outputCount));
    }

    public boolean registerCombiningRecipe(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CombiningRecipeSerializer(key, input, inputCount, secondInput, secondInputCount, output, outputCount));
    }

    public boolean registerWashingRecipe(ResourceLocation key, Object fluidInput, int fluidInputCount, Object gasInput, int gasInputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new WashingRecipeSerializer(key, fluidInput, fluidInputCount, gasInput, gasInputCount, output, outputCount));
    }

    public boolean registerCrystallizingRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CrystallizingRecipeSerializer(key, input, inputCount, output, outputCount));
    }

    public boolean registerDissolutionRecipe(ResourceLocation key, Object itemInput, int itemInputCount, Object gasInput, int gasInputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new DissolutionRecipeSerializer(key, itemInput, itemInputCount, gasInput, gasInputCount, output, outputCount));
    }

    public boolean registerPurifyingRecipe(ResourceLocation key, Object itemInput, int itemInputCount, Object gasInput, int gasInputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PurifyingRecipeSerializer(key, itemInput, itemInputCount, gasInput, gasInputCount, output, outputCount));
    }

    public boolean registerInjectingRecipe(ResourceLocation key, Object itemInput, int itemInputCount, Object gasInput, int gasInputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new InjectingRecipeSerializer(key, itemInput, itemInputCount, gasInput, gasInputCount, output, outputCount));
    }

    public TagKey<Gas> getGasTagKey(ResourceLocation location) {
        return MiscHelper.INSTANCE.getTagKey(MekanismAPI.gasRegistryName(), location);
    }

    public Collection<Gas> getGasTagValues(ResourceLocation location) {
        return MiscHelper.INSTANCE.getTagValues(MekanismAPI.gasRegistryName(), location);
    }

    public GasStack getPreferredGasStack(Iterable<Gas> collection, int amount) {
        return new GasStack((IGasProvider)MiscHelper.INSTANCE.getPreferredEntry(arg_0 -> ((IForgeRegistry)MekanismAPI.gasRegistry()).getKey(arg_0), collection).orElse(MekanismAPI.EMPTY_GAS), (long)amount);
    }

    public TagKey<Slurry> getSlurryTagKey(ResourceLocation location) {
        return MiscHelper.INSTANCE.getTagKey(MekanismAPI.slurryRegistryName(), location);
    }

    public Collection<Slurry> getSlurryTagValues(ResourceLocation location) {
        return MiscHelper.INSTANCE.getTagValues(MekanismAPI.slurryRegistryName(), location);
    }

    public SlurryStack getPreferredSlurryStack(Iterable<Slurry> collection, int amount) {
        return new SlurryStack((ISlurryProvider)MiscHelper.INSTANCE.getPreferredEntry(arg_0 -> ((IForgeRegistry)MekanismAPI.slurryRegistry()).getKey(arg_0), collection).orElse(MekanismAPI.EMPTY_SLURRY), (long)amount);
    }
}

