/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.ic2;

import com.google.common.collect.TreeBasedTable;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.data.DataInjector;

public class IC2DataInjector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TreeBasedTable<String, ResourceLocation, IRecipeSerializer> IC2_RECIPES_INJECT = TreeBasedTable.create();

    private IC2DataInjector() {
    }

    public static void init() {
        try {
            DataInjector.registerReloadInjector(Class.forName("ic2.core.platform.recipes.helpers.IC2RecipeLoader"), IC2DataInjector::injectRecipes);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("IC2 Classic recipe loader not found", (Throwable)e);
        }
    }

    public static boolean registerRecipe(String type, ResourceLocation key, IRecipeSerializer recipeSupplier) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(key);
        Objects.requireNonNull(recipeSupplier);
        if (ConfigHandler.RECIPE_BLACKLIST.contains(key) || ConfigHandler.RECIPE_REGEX_BLACKLIST.stream().anyMatch(p -> p.matcher(key.toString()).matches())) {
            return false;
        }
        return IC2_RECIPES_INJECT.row((Object)type).putIfAbsent(key, recipeSupplier) != null;
    }

    public static void injectRecipes(Object object) {
        Map recipeMap = (Map)object;
        TreeMap<ResourceLocation, JsonElement> recipesToInject = new TreeMap<ResourceLocation, JsonElement>();
        IC2_RECIPES_INJECT.cellSet().forEach(cell -> {
            String type = (String)cell.getRowKey();
            ResourceLocation key = (ResourceLocation)cell.getColumnKey();
            IRecipeSerializer supplier = (IRecipeSerializer)cell.getValue();
            ResourceLocation mapKey = new ResourceLocation(key.m_135815_(), type + "/" + key.m_135815_());
            if (recipeMap.containsKey(mapKey)) {
                LOGGER.debug("Duplicate IC2 recipe ignored with type {} and ID {}", (Object)type, (Object)key);
                return;
            }
            JsonElement recipe = null;
            try {
                recipe = (JsonElement)supplier.get();
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("IC2 recipe with type {} and ID {} received invalid arguments: {}", (Object)type, (Object)key, (Object)e.getMessage());
                return;
            }
            catch (Throwable e) {
                LOGGER.warn("IC2 recipe with type {} and ID {} errored", (Object)type, (Object)key, (Object)e);
                return;
            }
            if (recipe == null) {
                LOGGER.debug("IC2 recipe with type {} and ID {} returned null", (Object)type, (Object)key);
                return;
            }
            recipesToInject.put(mapKey, recipe);
            LOGGER.debug("Injected IC2 recipe with type {} and ID {}", (Object)type, (Object)key);
        });
        recipesToInject.forEach(recipeMap::putIfAbsent);
        LOGGER.info("Injected {} IC2 recipes, {} IC2 recipes total", (Object)recipesToInject.size(), (Object)recipeMap.size());
    }
}

