/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.fluid.MCFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.google.common.collect.TreeBasedTable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;
import thelm.jaopca.api.blocks.IBlockLike;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materialforms.IMaterialFormInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.crafttweaker.Form;
import thelm.jaopca.compat.crafttweaker.Material;
import thelm.jaopca.utils.MiscHelper;

@ZenRegister
@ZenCodeType.Name(value="mods.jaopca.MaterialForm")
public class MaterialForm {
    private static final TreeBasedTable<IForm, IMaterial, MaterialForm> MATERIAL_FORM_WRAPPERS = TreeBasedTable.create();
    private final IMaterialFormInfo info;

    public static MaterialForm getMaterialFormWrapper(IForm form, IMaterial material) {
        MaterialForm materialForm = (MaterialForm)MATERIAL_FORM_WRAPPERS.get((Object)form, (Object)material);
        if (materialForm == null) {
            IMaterialFormInfo info = form.getType().getMaterialFormInfo(form, material);
            materialForm = new MaterialForm(info);
        }
        return materialForm;
    }

    private MaterialForm(IMaterialFormInfo info) {
        this.info = info;
    }

    public IMaterialFormInfo getInternal() {
        return this.info;
    }

    @ZenCodeType.Getter(value="form")
    public Form getForm() {
        return Form.getFormWrapper(this.info.getMaterialForm().getForm());
    }

    @ZenCodeType.Getter(value="material")
    public Material getMaterial() {
        return Material.getMaterialWrapper(this.info.getMaterialForm().getMaterial());
    }

    @ZenCodeType.Method
    public MCTag asItemTag() {
        return this.asTag(Registry.f_122904_.m_135782_());
    }

    @ZenCodeType.Method
    public MCTag asFluidTag() {
        return this.asTag(Registry.f_122899_.m_135782_());
    }

    @ZenCodeType.Method
    public MCTag asTag(ResourceLocation registry) {
        return CraftTweakerTagRegistry.INSTANCE.tagManager(registry).tag(MiscHelper.INSTANCE.getTagLocation(this.info.getMaterialForm().getForm().getSecondaryName(), this.info.getMaterialForm().getMaterial().getName(), this.info.getMaterialForm().getForm().getTagSeparator()));
    }

    @ZenCodeType.Method
    public IItemStack asItemStack(int count) {
        if (!(this.info instanceof ItemLike)) {
            return null;
        }
        return new MCItemStack(new ItemStack((ItemLike)this.info, count));
    }

    @ZenCodeType.Method
    public IItemStack asItemStack() {
        return this.asItemStack(1);
    }

    @ZenCodeType.Method
    public IFluidStack asFluidStack(int amount) {
        if (!(this.info instanceof IFluidLike)) {
            return null;
        }
        return new MCFluidStack(new FluidStack(((IFluidLike)((Object)this.info)).asFluid(), amount));
    }

    @ZenCodeType.Method
    public Block asBlock() {
        if (!(this.info instanceof IBlockLike)) {
            return null;
        }
        return ((IBlockLike)((Object)this.info)).asBlock();
    }

    @ZenCodeType.Method
    public BlockState asBlockState() {
        if (!(this.info instanceof IBlockLike)) {
            return null;
        }
        return ((IBlockLike)((Object)this.info)).asBlock().m_49966_();
    }
}

