/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.colors;

import com.google.common.collect.Streams;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.registries.tags.ITag;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materialforms.IMaterialForm;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.items.ItemFormType;

public class ColorHandler {
    public static final BlockColor BLOCK_COLOR = (state, world, pos, tintIndex) -> {
        Block block;
        if (tintIndex == 0 && (block = state.m_60734_()) instanceof IMaterialForm) {
            IMaterialForm materialForm = (IMaterialForm)block;
            return materialForm.getMaterial().getColor();
        }
        return -1;
    };
    public static final ItemColor ITEM_COLOR = (stack, tintIndex) -> {
        Item item;
        if ((tintIndex == 0 || tintIndex == 2) && (item = stack.m_41720_()) instanceof IMaterialForm) {
            IMaterialForm materialForm = (IMaterialForm)item;
            return materialForm.getMaterial().getColor();
        }
        return -1;
    };

    public static void setup(RegisterColorHandlersEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        for (IMaterialFormBlock block : BlockFormType.getBlocks()) {
            blockColors.m_92589_(BLOCK_COLOR, new Block[]{block.asBlock()});
        }
        for (IMaterialFormBlockItem blockItem : BlockFormType.getBlockItems()) {
            itemColors.m_92689_(ITEM_COLOR, new ItemLike[]{blockItem.asBlockItem()});
        }
        for (IMaterialFormItem item : ItemFormType.getItems()) {
            itemColors.m_92689_(ITEM_COLOR, new ItemLike[]{item.asItem()});
        }
        for (IMaterialFormFluidBlock fluidBlock : FluidFormType.getFluidBlocks()) {
            blockColors.m_92589_(BLOCK_COLOR, new Block[]{fluidBlock.asBlock()});
        }
        for (IMaterialFormBucketItem bucketItem : FluidFormType.getBucketItems()) {
            itemColors.m_92689_(ITEM_COLOR, new ItemLike[]{bucketItem.asItem()});
        }
    }

    public static int getAverageColor(ITag<Item> tag) {
        Vector4f color = ColorHandler.weightedAverageColor(tag, ConfigHandler.gammaValue);
        return ColorHandler.toColorInt(color);
    }

    public static Vector4f weightedAverageColor(Iterable<Item> items, double gammaValue) {
        if (!items.iterator().hasNext()) {
            return new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);
        }
        List<Vector4f> colors = Streams.stream(items).map(ItemStack::new).map(stack -> ColorHandler.weightedAverageColor(stack, gammaValue)).toList();
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Vector4f weightedAverageColor(ItemStack stack, double gammaValue) {
        List<BakedQuad> quads = ColorHandler.getBakedQuads(stack);
        if (quads.isEmpty()) {
            return new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);
        }
        ArrayList<Vector4f> colors = new ArrayList<Vector4f>();
        for (BakedQuad quad : quads) {
            Vector4f color = ColorHandler.weightedAverageColor(quad.m_173410_(), gammaValue);
            color = ColorHandler.tintColor(color, ColorHandler.getTint(stack, quad));
            colors.add(color);
        }
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Vector4f weightedAverageColor(TextureAtlasSprite texture, double gammaValue) {
        int width = texture.m_118405_();
        int height = texture.m_118408_();
        int frameCount = texture.m_118415_();
        if (width <= 0 || height <= 0 || frameCount <= 0) {
            return new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);
        }
        ArrayList<Vector4f> colors = new ArrayList<Vector4f>();
        for (int frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int color = texture.getPixelRGBA(frameIndex, x, y);
                    colors.add(ColorHandler.toColorTuple(color));
                }
            }
        }
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Vector4f weightedAverageColor(List<Vector4f> colors, double gammaValue) {
        double totalWeight = 0.0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        for (Vector4f color : colors) {
            totalWeight += (double)color.m_123617_();
        }
        if (totalWeight <= 0.0) {
            return new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);
        }
        if (gammaValue == 0.0) {
            r = 1.0;
            g = 1.0;
            b = 1.0;
            for (Vector4f color : colors) {
                r *= (double)(color.m_123601_() * color.m_123617_());
                g *= (double)(color.m_123615_() * color.m_123617_());
                b *= (double)(color.m_123616_() * color.m_123617_());
            }
            r = Math.pow(r, 1.0 / totalWeight);
            g = Math.pow(g, 1.0 / totalWeight);
            b = Math.pow(b, 1.0 / totalWeight);
        } else {
            for (Vector4f color : colors) {
                r += Math.pow(color.m_123601_(), gammaValue) * (double)color.m_123617_();
                g += Math.pow(color.m_123615_(), gammaValue) * (double)color.m_123617_();
                b += Math.pow(color.m_123616_(), gammaValue) * (double)color.m_123617_();
            }
            r = Math.pow(r / totalWeight, 1.0 / gammaValue);
            g = Math.pow(g / totalWeight, 1.0 / gammaValue);
            b = Math.pow(b / totalWeight, 1.0 / gammaValue);
        }
        return new Vector4f((float)Mth.m_14008_((double)r, (double)0.0, (double)1.0), (float)Mth.m_14008_((double)g, (double)0.0, (double)1.0), (float)Mth.m_14008_((double)b, (double)0.0, (double)1.0), (float)Mth.m_14008_((double)(totalWeight / (double)colors.size()), (double)0.0, (double)1.0));
    }

    public static Vector4f toColorTuple(int color) {
        return new Vector4f((float)(color & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
    }

    public static Vector4f tintColor(Vector4f color, int tint) {
        return new Vector4f(color.m_123601_() * (float)(tint >> 16 & 0xFF) / 255.0f, color.m_123615_() * (float)(tint >> 8 & 0xFF) / 255.0f, color.m_123616_() * (float)(tint & 0xFF) / 255.0f, color.m_123617_());
    }

    public static int toColorInt(Vector4f color) {
        int ret = 0;
        ret |= (Math.round(Mth.m_14036_((float)(color.m_123601_() * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF) << 16;
        ret |= (Math.round(Mth.m_14036_((float)(color.m_123615_() * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF) << 8;
        return ret |= Math.round(Mth.m_14036_((float)(color.m_123616_() * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF;
    }

    public static List<BakedQuad> getBakedQuads(ItemStack stack) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0);
        model.m_213637_(null, null, RandomSource.m_216335_((long)0L)).stream().filter(quad -> quad.m_111306_() == Direction.SOUTH).forEach(quads::add);
        for (Direction facing : Direction.values()) {
            model.m_213637_(null, facing, RandomSource.m_216335_((long)0L)).stream().filter(quad -> quad.m_111306_() == Direction.SOUTH).forEach(quads::add);
        }
        return quads;
    }

    public static int getTint(ItemStack stack, BakedQuad quad) {
        return Minecraft.m_91087_().getItemColors().m_92676_(stack, quad.m_111305_());
    }
}

