/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item.knife;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.DelightfulConfig;
import net.brnbrd.delightful.common.item.IConfigured;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.item.KnifeItem;

public class DelightfulKnifeItem
extends KnifeItem
implements IConfigured {
    private final TagKey<Item> tag;
    private final Supplier<Ingredient> smithingBase;
    protected final ImmutableList<CreativeModeTab> tabs = ImmutableList.of((Object)CreativeModeTab.f_40754_, (Object)FarmersDelight.CREATIVE_TAB);

    public DelightfulKnifeItem(TagKey<Item> tag, Tier tier, Item.Properties properties, Supplier<Ingredient> smithingBase) {
        super(tier, 0.5f, -2.0f, properties);
        this.tag = tag;
        this.smithingBase = smithingBase;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> tool, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, tool, pIsAdvanced);
        if (!this.config()) {
            tool.add((Component)Component.m_237115_((String)"delightful.disabled.desc").m_130940_(ChatFormatting.UNDERLINE));
        } else if (!this.isTag()) {
            tool.add((Component)Component.m_237115_((String)"delightful.disabled.requirestag"));
            tool.add((Component)Component.m_237113_((String)this.getTag().f_203868_().toString()).m_130940_(ChatFormatting.UNDERLINE));
        }
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    public boolean isTag() {
        return !Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(this.getTag()).isEmpty();
    }

    public boolean config() {
        return DelightfulConfig.verify((Item)this);
    }

    @Override
    public boolean isEnabled() {
        return this.config() && this.isTag();
    }

    public Supplier<Ingredient> getRod() {
        return Util.ing((TagKey<Item>)Tags.Items.RODS_WOODEN);
    }

    @Nullable
    public Ingredient getSmithingBase() {
        return this.isSmithing() ? this.smithingBase.get() : null;
    }

    public boolean isSmithing() {
        return this.smithingBase != null;
    }

    public boolean genRecipe() {
        return true;
    }

    public boolean hasCustomName() {
        return false;
    }

    protected boolean m_220152_(@NotNull CreativeModeTab cat) {
        return this.tabs.contains((Object)cat) && this.config();
    }
}

