/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.utils;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final double KB_D = 1024.0;
    public static final double MB_D = 1048576.0;
    public static final double GB_D = 1.073741824E9;
    public static final double TB_D = 1.099511627776E12;

    public static void pack(Path zipFilePath, Path serverRoot, Iterable<Path> sourcePaths) throws IOException {
        Path p = Files.createFile(zipFilePath, new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            for (Path sourcePath : sourcePaths) {
                Stream<Path> pathStream = Files.walk(sourcePath, new FileVisitOption[0]);
                try {
                    for (Path path : pathStream::iterator) {
                        if (Files.isDirectory(path, new LinkOption[0])) continue;
                        FileUtils.packIntoZip(zs, serverRoot, path);
                    }
                }
                finally {
                    if (pathStream == null) continue;
                    pathStream.close();
                }
            }
        }
    }

    private static void packIntoZip(ZipOutputStream zos, Path rootDir, Path file) throws IOException {
        if (file.getFileName().toString().equals("session.lock")) {
            return;
        }
        if (!file.toFile().exists()) {
            return;
        }
        if (!Files.isReadable(file)) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(rootDir.relativize(file).toString());
        zos.putNextEntry(zipEntry);
        FileUtils.updateZipEntry(zipEntry, file);
        try {
            Files.copy(file, zos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        zos.closeEntry();
    }

    public static void updateZipEntry(ZipEntry zipEntry, Path path) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            zipEntry.setLastModifiedTime(basicFileAttributes.lastModifiedTime());
            zipEntry.setCreationTime(basicFileAttributes.creationTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isChildOf(Path path, Path parent) {
        if (path == null) {
            return false;
        }
        if (path.equals(parent)) {
            return true;
        }
        return FileUtils.isChildOf(path.getParent(), parent);
    }

    public static String getSha1(Path path) {
        try {
            HashCode sha1HashCode = com.google.common.io.Files.asByteSource((File)path.toFile()).hash(Hashing.sha1());
            return sha1HashCode.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static long getFolderSize(File folder) {
        long length = 0L;
        File[] files = folder.listFiles();
        int count = files.length;
        for (int i = 0; i < count; ++i) {
            if (files[i].isFile()) {
                length += files[i].length();
                continue;
            }
            length += FileUtils.getFolderSize(files[i]);
        }
        return length;
    }

    public static String getSizeString(double b) {
        if (b >= 1.099511627776E12) {
            return String.format("%.1fTB", b / 1.099511627776E12);
        }
        if (b >= 1.073741824E9) {
            return String.format("%.1fGB", b / 1.073741824E9);
        }
        if (b >= 1048576.0) {
            return String.format("%.1fMB", b / 1048576.0);
        }
        if (b >= 1024.0) {
            return String.format("%.1fKB", b / 1024.0);
        }
        return (long)b + "B";
    }

    public static String getSizeString(Path path) {
        return FileUtils.getSizeString(FileUtils.getSize(path.toFile()));
    }

    public static String getSizeString(File file) {
        return FileUtils.getSizeString(FileUtils.getSize(file));
    }

    public static long getSize(File file) {
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        if (file.isDirectory()) {
            long length = 0L;
            File[] f1 = file.listFiles();
            if (f1 != null && f1.length > 0) {
                for (File aF1 : f1) {
                    length += FileUtils.getSize(aF1);
                }
            }
            return length;
        }
        return 0L;
    }
}

