/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.nbt;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.creeperhost.ftbbackups.de.piegames.nbt.ByteArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ByteTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.DoubleTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.EndTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.FloatTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.IntArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.IntTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ListTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.LongArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.LongTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ShortArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ShortTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.StringTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.TagType;

public abstract class Tag<T>
implements Comparable<Tag<?>> {
    private final String name;
    private final TagType type;

    public Tag(TagType type) {
        this(type, "");
    }

    public Tag(TagType type, String name) {
        this.name = name;
        this.type = type;
    }

    public final String getName() {
        return this.name;
    }

    public TagType getType() {
        return this.type;
    }

    public abstract T getValue();

    public abstract void setValue(T var1);

    public Optional<EndTag> getAsEndTag() {
        return Optional.empty();
    }

    public Optional<ByteTag> getAsByteTag() {
        return Optional.empty();
    }

    public Optional<ShortTag> getAsShortTag() {
        return Optional.empty();
    }

    public Optional<IntTag> getAsIntTag() {
        return Optional.empty();
    }

    public Optional<LongTag> getAsLongTag() {
        return Optional.empty();
    }

    public Optional<FloatTag> getAsFloatTag() {
        return Optional.empty();
    }

    public Optional<DoubleTag> getAsDoubleTag() {
        return Optional.empty();
    }

    public Optional<ByteArrayTag> getAsByteArrayTag() {
        return Optional.empty();
    }

    public Optional<StringTag> getAsStringTag() {
        return Optional.empty();
    }

    public Optional<ListTag<?>> getAsListTag() {
        return Optional.empty();
    }

    public Optional<CompoundTag> getAsCompoundTag() {
        return Optional.empty();
    }

    public Optional<IntArrayTag> getAsIntArrayTag() {
        return Optional.empty();
    }

    public Optional<LongArrayTag> getAsLongArrayTag() {
        return Optional.empty();
    }

    public Optional<ShortArrayTag> getAsShortArrayTag() {
        return Optional.empty();
    }

    public static Map<String, Tag<?>> cloneMap(Map<String, Tag<?>> map) {
        if (map == null) {
            return null;
        }
        HashMap newMap = new HashMap();
        for (Map.Entry<String, Tag<?>> entry : map.entrySet()) {
            newMap.put(entry.getKey(), (Tag<?>)entry.getValue().clone());
        }
        return newMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(Tag<?> other) {
        if (this.equals(other)) {
            return 0;
        }
        if (other.getName().equals(this.getName())) {
            throw new IllegalStateException("Cannot compare two Tags with the same name but different values for sorting");
        }
        return this.getName().compareTo(other.getName());
    }

    public abstract Tag<T> clone();
}

