/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.world;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftDimension;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.Exclude;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.PostDeserialize;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.PostSerialize;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2d;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2dc;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2i;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3d;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3dc;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3i;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3ic;
import net.creeperhost.ftbbackups.de.piegames.nbt.ByteArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ByteTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundMap;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.DoubleTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.IntArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.IntTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ListTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.LongTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.StringTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.regionfile.RegionFile;
import net.creeperhost.ftbbackups.de.piegames.nbt.stream.NBTInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LevelMetadata {
    private static Logger log = LogManager.getLogger(LevelMetadata.class);
    int version = 0;
    Optional<String> worldName;
    Optional<List<PlayerPin>> players;
    Optional<List<MapPin>> maps;
    Optional<List<VillageObjectPin>> villageObjects;
    Optional<List<ChunkPin>> slimeChunks;
    Optional<List<ChunkPin>> loadedChunks;
    Optional<BorderPin> barrier;
    Optional<WorldSpawnPin> worldSpawn;

    private LevelMetadata() {
    }

    public LevelMetadata(String worldName, List<PlayerPin> players, List<MapPin> maps, List<VillageObjectPin> villageObjects, List<ChunkPin> slimeChunks, List<ChunkPin> loadedChunks, BorderPin barrier, WorldSpawnPin worldSpawn) {
        this(Optional.ofNullable(worldName), Optional.ofNullable(players), Optional.ofNullable(maps), Optional.ofNullable(villageObjects), Optional.ofNullable(slimeChunks), Optional.ofNullable(loadedChunks), Optional.ofNullable(barrier), Optional.ofNullable(worldSpawn));
    }

    public LevelMetadata(Optional<String> worldName, Optional<List<PlayerPin>> players, Optional<List<MapPin>> maps, Optional<List<VillageObjectPin>> villageObjects, Optional<List<ChunkPin>> slimeChunks, Optional<List<ChunkPin>> loadedChunks, Optional<BorderPin> barrier, Optional<WorldSpawnPin> worldSpawn) {
        this.worldName = worldName;
        this.players = players;
        this.maps = maps;
        this.villageObjects = villageObjects;
        this.slimeChunks = slimeChunks;
        this.loadedChunks = loadedChunks;
        this.barrier = barrier;
        this.worldSpawn = worldSpawn;
    }

    public Optional<String> getWorldName() {
        return this.worldName;
    }

    public Optional<List<PlayerPin>> getPlayers() {
        return this.players;
    }

    public Optional<List<MapPin>> getMaps() {
        return this.maps;
    }

    public Optional<List<ChunkPin>> getSlimeChunks() {
        return this.slimeChunks;
    }

    public Optional<List<ChunkPin>> getLoadedChunks() {
        return this.loadedChunks;
    }

    public Optional<BorderPin> getBarrier() {
        return this.barrier;
    }

    public Optional<WorldSpawnPin> getWorldSpawn() {
        return this.worldSpawn;
    }

    public Optional<List<VillageObjectPin>> getVillageObjects() {
        return this.villageObjects;
    }

    public static LevelMetadata loadFromWorld(Path worldPath, MinecraftDimension filterDimension) {
        NBTInputStream in;
        Object spawnpoint;
        ArrayList<PlayerPin> players = new ArrayList<PlayerPin>();
        try (DirectoryStream<Path> d = Files.newDirectoryStream(worldPath.resolve("playerdata"));){
            for (Path p : d) {
                if (!p.getFileName().toString().endsWith(".dat")) continue;
                log.debug("Loading player metadata from " + p.toAbsolutePath());
                try (NBTInputStream in2 = new NBTInputStream(Files.newInputStream(p, new OpenOption[0]), 1);){
                    String UUID2;
                    CompoundMap map = (CompoundMap)in2.readTag().getValue();
                    Object pos = ((ListTag)map.get("Pos")).getValue();
                    Vector3d position = new Vector3d(((DoubleTag)pos.get(0)).getValue(), ((DoubleTag)pos.get(1)).getValue(), ((DoubleTag)pos.get(2)).getValue());
                    MinecraftDimension dimension = ((Tag)map.get("Dimension")).getAsStringTag().map(tag -> MinecraftDimension.byName(tag.getValue())).orElseGet(() -> MinecraftDimension.byID(((Tag)map.get("Dimension")).getAsIntTag().get().getValue()));
                    if (filterDimension != null && dimension != filterDimension) continue;
                    if (map.containsKey("UUID")) {
                        int[] uuid = ((IntArrayTag)map.get("UUID")).getValue();
                        UUID2 = BigInteger.valueOf(uuid[0]).and(new BigInteger("FFFFFFFF", 16)).shiftLeft(32).or(BigInteger.valueOf(uuid[1]).and(new BigInteger("FFFFFFFF", 16))).shiftLeft(32).or(BigInteger.valueOf(uuid[2]).and(new BigInteger("FFFFFFFF", 16))).shiftLeft(32).or(BigInteger.valueOf(uuid[3]).and(new BigInteger("FFFFFFFF", 16))).toString(16);
                    } else {
                        UUID2 = BigInteger.valueOf(((LongTag)map.get("UUIDMost")).getValue()).and(new BigInteger("FFFFFFFFFFFFFFFF", 16)).shiftLeft(64).or(BigInteger.valueOf(((LongTag)map.get("UUIDLeast")).getValue()).and(new BigInteger("FFFFFFFFFFFFFFFF", 16))).toString(16);
                    }
                    spawnpoint = null;
                    if (map.containsKey("SpawnX")) {
                        spawnpoint = new Vector3i(((IntTag)map.get("SpawnX")).getValue(), ((IntTag)map.get("SpawnY")).getValue(), (int)((IntTag)map.get("SpawnZ")).getValue());
                    }
                    int gamemode = ((IntTag)map.get("playerGameType")).getValue();
                    players.add(new PlayerPin((Vector3dc)position, dimension, UUID2, (Vector3ic)spawnpoint, gamemode));
                }
                catch (IOException e) {
                    log.warn("Could not load player metadata from " + p.toAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            log.warn("Could not access player data", (Throwable)e);
        }
        ArrayList<VillageObjectPin> villageObjects = new ArrayList<VillageObjectPin>();
        for (MinecraftDimension dimension : MinecraftDimension.values()) {
            if (filterDimension != null && dimension != filterDimension) continue;
            try (DirectoryStream<Path> d = Files.newDirectoryStream(worldPath.resolve(dimension.getPoiPath()));){
                for (Path p : d) {
                    if (!p.toString().endsWith(".mca")) continue;
                    log.debug("Loading village metadata from " + p.toAbsolutePath());
                    try (RegionFile file = new RegionFile(p, StandardOpenOption.READ);){
                        spawnpoint = file.listChunks().iterator();
                        while (spawnpoint.hasNext()) {
                            int i = spawnpoint.next();
                            for (CompoundTag section : file.loadChunk(i).readTag().getAsCompoundTag("Sections").map(tag -> tag.getValue().values()).stream().flatMap(Collection::stream).map(t -> (CompoundTag)t)::iterator) {
                                if (section.getByteValue("Valid").orElse((byte)0) != 1) {
                                    log.warn("Found invalid records during village loading in region file " + file.getPath().toString() + " in chunk " + i);
                                    continue;
                                }
                                List records = section.getAsListTag("Records").flatMap(ListTag::getAsCompoundTagList).map(Tag::getValue).orElse(Collections.emptyList());
                                for (CompoundTag j : records) {
                                    int freeTickets = j.getIntValue("free_tickets").orElse(-1);
                                    String type = j.getStringValue("type").orElse("<unknown>");
                                    int[] pos = j.getIntArrayValue("pos").orElse(new int[]{0, 0, 0});
                                    Vector3i position = new Vector3i(pos[0], pos[1], pos[2]);
                                    villageObjects.add(new VillageObjectPin(position, dimension, freeTickets, type));
                                }
                            }
                        }
                    }
                    catch (IOException | RuntimeException e) {
                        if (Files.size(p) == 0L) {
                            log.warn("'" + worldPath.relativize(p) + "' is empty?!");
                            continue;
                        }
                        log.warn("Could not load village data from " + p.getFileName(), (Throwable)e);
                    }
                }
            }
            catch (IOException | RuntimeException e) {
                log.warn("Could not access village data", (Throwable)e);
            }
        }
        ArrayList<MapPin> maps = new ArrayList<MapPin>();
        try (DirectoryStream<Path> d = Files.newDirectoryStream(worldPath.resolve("data"));){
            for (Path p : d) {
                if (!p.getFileName().toString().endsWith(".dat") || !p.getFileName().toString().startsWith("map_")) continue;
                log.debug("Loading map metadata from " + p.toAbsolutePath());
                try {
                    in = new NBTInputStream(Files.newInputStream(p, new OpenOption[0]), 1);
                    try {
                        CompoundMap map = (CompoundMap)((Tag)((CompoundMap)in.readTag().getValue()).get("data")).getValue();
                        byte scale = ((ByteTag)map.get("scale")).getValue();
                        Vector2i center = new Vector2i((int)((IntTag)map.get("xCenter")).getValue(), (int)((IntTag)map.get("zCenter")).getValue());
                        ArrayList<MapPin.BannerPin> banners = null;
                        if (map.containsKey("banners")) {
                            banners = new ArrayList<MapPin.BannerPin>();
                            Iterator i = ((ListTag)map.get("banners")).getValue().iterator();
                            while (i.hasNext()) {
                                CompoundTag banner = (CompoundTag)i.next();
                                CompoundMap bannerMap = banner.getValue();
                                String color = bannerMap.containsKey("Color") ? ((StringTag)bannerMap.get("Color")).getValue() : null;
                                String name = bannerMap.containsKey("Name") ? ((StringTag)bannerMap.get("Name")).getValue() : null;
                                CompoundMap pos = ((CompoundTag)bannerMap.get("Pos")).getValue();
                                banners.add(new MapPin.BannerPin((Vector3ic)new Vector3i(((IntTag)pos.get("X")).getValue(), ((IntTag)pos.get("Y")).getValue(), (int)((IntTag)pos.get("Z")).getValue()), color, name));
                            }
                        }
                        byte[] colors = null;
                        if (map.containsKey("colors")) {
                            colors = ((ByteArrayTag)map.get("colors")).getValue();
                        }
                        MinecraftDimension dimension = ((Tag)map.get("dimension")).getAsStringTag().map(tag -> MinecraftDimension.byName(tag.getValue())).or(() -> ((Tag)map.get("dimension")).getAsIntTag().map(IntTag::getValue).map(MinecraftDimension::byID)).or(() -> ((Tag)map.get("dimension")).getAsByteTag().map(ByteTag::getValue).map(MinecraftDimension::byID)).get();
                        if (filterDimension != null && dimension != filterDimension) continue;
                        maps.add(new MapPin(scale, (Vector2ic)center, dimension, banners, colors));
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException | RuntimeException e) {
                    log.warn("Could not access map " + p.getFileName(), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.warn("Could not access map data", (Throwable)e);
        }
        WorldSpawnPin worldSpawn = null;
        BorderPin barrier = null;
        String name = null;
        try {
            in = new NBTInputStream(Files.newInputStream(worldPath.resolve("level.dat"), new OpenOption[0]), 1);
            try {
                CompoundMap level = ((CompoundTag)((CompoundTag)in.readTag()).getValue().get("Data")).getValue();
                name = ((Tag)level.get("LevelName")).getAsStringTag().map(StringTag::getValue).orElse(null);
                worldSpawn = new WorldSpawnPin(new Vector3i(((IntTag)level.get("SpawnX")).getValue(), ((IntTag)level.get("SpawnY")).getValue(), (int)((IntTag)level.get("SpawnZ")).getValue()));
                barrier = new BorderPin(new Vector2d(((DoubleTag)level.get("BorderCenterX")).getValue(), ((DoubleTag)level.get("BorderCenterZ")).getValue()), ((DoubleTag)level.get("BorderSize")).getValue());
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            log.warn("Could not access level data", (Throwable)e);
        }
        return new LevelMetadata(name, players, maps, villageObjects, null, null, barrier, worldSpawn);
    }

    public static class PlayerPin {
        Vector3dc position;
        MinecraftDimension dimension;
        Optional<String> UUID;
        Optional<Vector3ic> spawnpoint;
        Optional<Integer> gamemode;

        private PlayerPin() {
        }

        public PlayerPin(Vector3dc position, MinecraftDimension dimension, String UUID2, Vector3ic spawnpoint, int gamemode) {
            this(position, dimension, Optional.ofNullable(UUID2), Optional.ofNullable(spawnpoint), Optional.ofNullable(gamemode));
        }

        public PlayerPin(Vector3dc position, MinecraftDimension dimension, Optional<String> UUID2, Optional<Vector3ic> spawnpoint, Optional<Integer> gamemode) {
            this.position = position;
            this.dimension = dimension;
            this.UUID = UUID2;
            this.spawnpoint = spawnpoint;
            this.gamemode = gamemode;
        }

        public Vector3dc getPosition() {
            return this.position;
        }

        public MinecraftDimension getDimension() {
            return this.dimension;
        }

        public Optional<String> getUUID() {
            return this.UUID;
        }

        public Optional<Vector3ic> getSpawnpoint() {
            return this.spawnpoint;
        }

        public Optional<Integer> getGamemode() {
            return this.gamemode;
        }
    }

    public static class VillageObjectPin {
        Vector3ic position;
        MinecraftDimension dimension;
        int freeTickets;
        String type;

        public VillageObjectPin(Vector3ic position, MinecraftDimension dimension, int freeTickets, String type) {
            this.position = position;
            this.dimension = dimension;
            this.freeTickets = freeTickets;
            this.type = type;
        }

        public Vector3ic getPosition() {
            return this.position;
        }

        public int getFreeTickets() {
            return this.freeTickets;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class MapPin {
        Vector2ic position;
        MinecraftDimension dimension;
        byte scale;
        Optional<List<BannerPin>> banners;
        @Exclude
        Optional<byte[]> colors;

        private MapPin() {
        }

        public MapPin(byte scale, Vector2ic position, MinecraftDimension dimension, List<BannerPin> banners, byte[] colors) {
            this(scale, position, dimension, Optional.ofNullable(banners), Optional.ofNullable(colors));
        }

        public MapPin(byte scale, Vector2ic position, MinecraftDimension dimension, Optional<List<BannerPin>> banners, Optional<byte[]> colors) {
            this.scale = scale;
            this.position = position;
            this.dimension = dimension;
            this.banners = banners;
            this.colors = colors;
        }

        @PostSerialize
        private void postSerialize(JsonElement src, Gson gson) {
            this.colors.ifPresent(c -> src.getAsJsonObject().addProperty("colors", Base64.getEncoder().encodeToString((byte[])c)));
        }

        @PostDeserialize
        private void postDeserialize(JsonElement src, Gson gson) {
            this.colors = Optional.ofNullable(src.getAsJsonObject().getAsJsonPrimitive("colors")).map(JsonPrimitive::getAsString).map(Base64.getDecoder()::decode);
        }

        public byte getScale() {
            return this.scale;
        }

        public Vector2ic getPosition() {
            return this.position;
        }

        public MinecraftDimension getDimension() {
            return this.dimension;
        }

        public Optional<List<BannerPin>> getBanners() {
            return this.banners;
        }

        public Optional<byte[]> getColors() {
            return this.colors;
        }

        public static class BannerPin {
            Vector3ic position;
            Optional<String> color;
            Optional<String> name;

            private BannerPin() {
            }

            public BannerPin(Vector3ic position, String color, String name) {
                this(position, Optional.ofNullable(color), Optional.ofNullable(name));
            }

            public BannerPin(Vector3ic position, Optional<String> color, Optional<String> name) {
                this.position = position;
                this.color = color;
                this.name = name;
            }

            public Vector3ic getPosition() {
                return this.position;
            }

            public Optional<String> getColor() {
                return this.color;
            }

            public Optional<String> getName() {
                return this.name;
            }
        }
    }

    public static class WorldSpawnPin {
        Vector3ic spawnpoint;

        private WorldSpawnPin() {
        }

        public WorldSpawnPin(Vector3ic spawnpoint) {
            this.spawnpoint = spawnpoint;
        }

        public Vector3ic getSpawnpoint() {
            return this.spawnpoint;
        }
    }

    public static class BorderPin {
        Vector2dc center;
        double size;

        private BorderPin() {
        }

        public BorderPin(Vector2dc center, double size) {
            this.center = center;
            this.size = size;
        }

        public Vector2dc getCenter() {
            return this.center;
        }

        public double getRadius() {
            return this.size;
        }
    }

    public static class ChunkPin {
        Vector2ic position;

        private ChunkPin() {
        }

        public ChunkPin(Vector2ic position) {
            this.position = position;
        }

        public Vector2ic getPosition() {
            return this.position;
        }
    }
}

