/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.renderer;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftVersion;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.BiomeColorMap;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.BlockColorMap;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.Color;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.ChunkRenderer;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RenderSettings;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3i;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.ChunkMetadata;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundMap;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ListTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.StringTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.regionfile.Chunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ChunkRenderer_1_18
extends ChunkRenderer {
    private static Logger log = LogManager.getLogger(ChunkRenderer_1_18.class);

    public ChunkRenderer_1_18(RenderSettings settings) {
        super(MinecraftVersion.MC_1_18, settings);
    }

    @Override
    ChunkMetadata renderChunk(Vector2ic chunkPosRegion, Vector2ic chunkPosWorld, CompoundTag level, Color[] map, int[] height, String[] regionBiomes) {
        this.blockColors = this.settings.blockColors.get((Object)this.version);
        try {
            String generationStatus = level.getAsStringTag("Status").map(Tag::getValue).orElse("empty");
            if (ChunkMetadata.ChunkMetadataRendered.STATUS_EMPTY.contains(generationStatus)) {
                return new ChunkMetadata.ChunkMetadataRendered(chunkPosWorld, generationStatus);
            }
            HashMap<String, Vector3ic> structureCenters = new HashMap<String, Vector3ic>();
            level.getAsCompoundTag("structures").flatMap(t -> t.getAsCompoundTag("starts")).stream().flatMap(tag -> tag.getValue().values().stream()).map(Tag::getAsCompoundTag).flatMap(structure -> structure.stream()).forEach(structure2 -> {
                String id = structure2.getStringValue("id").orElse("INVALID");
                if (id.equals("INVALID")) {
                    return;
                }
                Stream.of(structure2).flatMap(structure -> structure.getAsListTag("Children").stream()).flatMap(children -> children.getAsCompoundTagList().stream()).flatMap(children -> children.getValue().stream()).filter(child -> child.getIntValue("GD").map(gd -> gd == 0).orElse(false)).forEach(child -> {
                    int[] bb = child.getIntArrayValue("BB").get();
                    Vector3i center = new Vector3i(bb[0], bb[1], bb[2]).add(bb[3], bb[4], bb[5]);
                    center.x /= 2;
                    center.y /= 2;
                    center.z /= 2;
                    structureCenters.put(id, center);
                });
            });
            int lowestLoadedSection = 20;
            BlockColorMap.BlockColor[][] loadedSections = new BlockColorMap.BlockColor[24][];
            String[] loadedTopBiomes = null;
            Map<Byte, CompoundMap> sections = level.getAsListTag("sections").flatMap(ListTag::getAsCompoundTagList).map(ListTag::getValue).stream().flatMap(Collection::stream).collect(Collectors.toMap(section -> section.getByteValue("Y").get(), Tag::getValue));
            boolean mayCull = chunkPosWorld.x() << 4 < this.settings.minX || (chunkPosWorld.x() << 4) + 16 > this.settings.maxX || chunkPosWorld.y() << 4 < this.settings.minZ || (chunkPosWorld.y() << 4) + 16 > this.settings.maxZ;
            for (int z = 0; z < 16; z = (int)((byte)(z + 1))) {
                for (int x = 0; x < 16; x = (int)((byte)(x + 1))) {
                    if (mayCull && (x + (chunkPosWorld.x() << 4) < this.settings.minX || x + (chunkPosWorld.x() << 4) > this.settings.maxX || z + (chunkPosWorld.y() << 4) < this.settings.minZ || z + (chunkPosWorld.y() << 4) > this.settings.maxZ)) continue;
                    int xz = x | z << 4;
                    int biomeXZ = z & 0xC | x >> 2;
                    int regionXZ = chunkPosRegion.x() << 4 | x | chunkPosRegion.y() << 13 | z << 9;
                    boolean heightSet = false;
                    boolean discardTop = this.blockColors.isCaveView();
                    class ColorColumn {
                        Color color = Color.TRANSPARENT;
                        BlockColorMap.BlockColor lastColor = BlockColorMap.BlockColor.TRANSPARENT;
                        String lastBiome = null;
                        int lastColorTimes = 0;
                        boolean needStop = false;

                        ColorColumn() {
                        }

                        void putColor(BlockColorMap.BlockColor currentColor, int times, String biome) {
                            if (currentColor == this.lastColor && biome == this.lastBiome) {
                                this.lastColorTimes += times;
                            } else {
                                Color color = this.lastColor.color;
                                if (this.lastColor.isGrass || this.lastColor.isFoliage || this.lastColor.isWater) {
                                    BiomeColorMap.BiomeColor biomeColor = ChunkRenderer_1_18.this.settings.biomeColors.getBiomeColor(this.lastBiome);
                                    if (this.lastColor.isGrass) {
                                        color = Color.multiplyRGB(color, biomeColor.grassColor);
                                    }
                                    if (this.lastColor.isFoliage) {
                                        color = Color.multiplyRGB(color, biomeColor.foliageColor);
                                    }
                                    if (this.lastColor.isWater) {
                                        color = Color.multiplyRGB(color, biomeColor.waterColor);
                                    }
                                }
                                this.color = Color.alphaUnder(this.color, color, this.lastColorTimes);
                                this.lastColorTimes = times;
                                this.lastColor = currentColor;
                                this.lastBiome = biome;
                                if ((double)currentColor.color.a > 0.9999) {
                                    this.needStop = true;
                                }
                            }
                        }

                        Color getFinal() {
                            this.putColor(BlockColorMap.BlockColor.TRANSPARENT, 1, null);
                            return this.color;
                        }
                    }
                    ColorColumn color = new ColorColumn();
                    block6: for (int s = 19; s >= -4; s = (int)((byte)(s - 1))) {
                        if (s << 4 > this.settings.maxY) continue;
                        if (s < lowestLoadedSection) {
                            try {
                                CompoundMap section2 = sections.get((byte)s);
                                loadedSections[s + 4] = this.renderSection(section2, this.blockColors);
                                if (loadedTopBiomes == null) {
                                    loadedTopBiomes = new String[16];
                                    CompoundTag biomes = ((Tag)section2.get("biomes")).getAsCompoundTag().get();
                                    List palette = ((ListTag)biomes.getAsListTag("palette").flatMap(ListTag::getAsStringTagList).get()).getValue().stream().map(StringTag::getValue).collect(Collectors.toList());
                                    if (!biomes.getValue().containsKey("data")) {
                                        if (palette.size() > 1) {
                                            log.warn("Palette has more than one element, but no index data?!");
                                        }
                                        String biome = (String)palette.get(0);
                                        for (int i = 0; i < 16; ++i) {
                                            loadedTopBiomes[i] = biome;
                                        }
                                    } else {
                                        long[] dataArray = biomes.getLongArrayValue("data").get();
                                        int paletteSize = palette.size();
                                        int bitsPerIndex = 32 - Integer.numberOfLeadingZeros(paletteSize - 1);
                                        int shortsPerLong = Math.floorDiv(64, bitsPerIndex);
                                        int mask = (1 << bitsPerIndex) - 1;
                                        if (paletteSize <= 16) {
                                            long data = dataArray[0];
                                            for (int i = 0; i < 16; ++i) {
                                                loadedTopBiomes[i] = (String)palette.get((int)(data & (long)mask));
                                                data >>= bitsPerIndex;
                                            }
                                        } else {
                                            int index = 0;
                                            for (long l : dataArray) {
                                                for (int i = 0; i < shortsPerLong && index < 16; ++i) {
                                                    loadedTopBiomes[index++] = (String)palette.get((int)(l & (long)mask));
                                                    l >>= bitsPerIndex;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.warn("Failed to render chunk (" + chunkPosRegion.x() + ", " + chunkPosRegion.y() + ") section " + (byte)s + ". This is very likely because your chunk is corrupt. If possible, please verify it manually before sending a bug report.", (Throwable)e);
                                return new ChunkMetadata.ChunkMetadataFailed(chunkPosWorld, e);
                            }
                            lowestLoadedSection = s;
                        }
                        for (int y = 15; y >= 0; --y) {
                            int h = s << 4 | y;
                            if (h < this.settings.minY) break block6;
                            if (h > this.settings.maxY) continue;
                            int xzy = xz | y << 8;
                            BlockColorMap.BlockColor colorData = loadedSections[s + 4][xzy];
                            if (discardTop && colorData.isTranslucent) {
                                discardTop = false;
                            }
                            if (!(discardTop || colorData.isTranslucent || heightSet)) {
                                height[regionXZ] = h;
                                heightSet = true;
                            }
                            if (!discardTop) {
                                color.putColor(colorData, 1, loadedTopBiomes[biomeXZ]);
                            }
                            if (color.needStop) break block6;
                        }
                    }
                    regionBiomes[regionXZ] = loadedTopBiomes[biomeXZ];
                    map[regionXZ] = color.getFinal();
                }
            }
            return new ChunkMetadata.ChunkMetadataRendered(chunkPosWorld, generationStatus, structureCenters);
        }
        catch (Exception e) {
            log.warn("Failed to render chunk (" + chunkPosRegion.x() + ", " + chunkPosRegion.y() + ")", (Throwable)e);
            return new ChunkMetadata.ChunkMetadataFailed(chunkPosWorld, e);
        }
    }

    private BlockColorMap.BlockColor[] renderSection(CompoundMap section, BlockColorMap blockColors) {
        CompoundTag blockStates = ((Tag)section.get("block_states")).getAsCompoundTag().get();
        List palette = blockStates.getAsListTag("palette").flatMap(ListTag::getAsCompoundTagList).map(Tag::getValue).stream().flatMap(Collection::stream).map(map -> blockColors.getBlockColor(map.getStringValue("Name").get(), () -> ChunkRenderer_1_18.parseBlockState(map.getAsCompoundTag("Properties").get(), this.version.getBlockStates()))).collect(Collectors.toList());
        BlockColorMap.BlockColor[] ret = new BlockColorMap.BlockColor[4096];
        if (!blockStates.getValue().containsKey("data")) {
            if (palette.size() > 1) {
                log.warn("Palette has more than one element, but no index data?!");
            }
            BlockColorMap.BlockColor state = (BlockColorMap.BlockColor)palette.get(0);
            for (int i = 0; i < 4096; ++i) {
                ret[i] = state;
            }
            return ret;
        }
        long[] blocks = blockStates.getLongArrayValue("data").get();
        long[] blocksParsed = Chunk.extractFromLong1_16(blocks, palette.size());
        for (int i = 0; i < 4096; ++i) {
            int b = (int)blocksParsed[i];
            if (b >= palette.size()) {
                log.warn("Block " + i + " " + b + " was out of bounds, is this world corrupt?");
                continue;
            }
            ret[i] = (BlockColorMap.BlockColor)palette.get(b);
        }
        return ret;
    }
}

