/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.network;

import com.flanks255.psu.gui.PSUContainer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class SlotClickMessage {
    private final int slotID;
    private final boolean shift;
    private final boolean ctrl;
    private final boolean rightClick;

    public SlotClickMessage(int slotIDIn, boolean shiftIn, boolean ctrlIn, boolean rightClickIn) {
        this.slotID = slotIDIn;
        this.shift = shiftIn;
        this.ctrl = ctrlIn;
        this.rightClick = rightClickIn;
    }

    public static SlotClickMessage decode(FriendlyByteBuf buffer) {
        return new SlotClickMessage(buffer.readInt(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean());
    }

    public static void encode(SlotClickMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotID);
        buffer.writeBoolean(message.shift);
        buffer.writeBoolean(message.ctrl);
        buffer.writeBoolean(message.rightClick);
    }

    public static void handle(SlotClickMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player.f_36096_ instanceof PSUContainer) {
                ((PSUContainer)player.f_36096_).networkSlotClick(message.slotID, message.shift, message.ctrl, message.rightClick);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

