/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.inventory;

import com.flanks255.psu.inventory.PSUSlot;
import com.flanks255.psu.inventory.StorageManager;
import com.flanks255.psu.items.PSUTier;
import com.flanks255.psu.items.PocketStorageUnit;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PSUItemHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    private NonNullList<PSUSlot> slots;
    private int slotCount;
    private int slotCapacity;

    public PSUItemHandler(PSUTier tier) {
        this.slotCount = tier.slots;
        this.slotCapacity = tier.capacity;
        this.slots = NonNullList.m_122780_((int)tier.slots, (Object)PSUSlot.EMPTY);
    }

    void checkIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
    }

    public int getSlots() {
        return this.slotCount;
    }

    public int getSlotLimit(int slot) {
        return this.slotCapacity;
    }

    public PSUSlot getSlot(int slot) {
        this.checkIndex(slot);
        return (PSUSlot)this.slots.get(slot);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.checkIndex(slot);
        if (!((PSUSlot)this.slots.get(slot)).isEmpty() && ((PSUSlot)this.slots.get(slot)).getCount() > 0) {
            ItemStack tmp = ((PSUSlot)this.slots.get(slot)).getStack();
            tmp.m_41764_(((PSUSlot)this.slots.get(slot)).getCount());
            return tmp;
        }
        return ItemStack.f_41583_;
    }

    public boolean hasItem(ItemStack stack) {
        for (PSUSlot slot : this.slots) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)slot.getStack(), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public void upgrade(PSUTier tier) {
        if (tier.slots <= this.slots.size()) {
            return;
        }
        NonNullList<PSUSlot> oldStacks = this.slots;
        this.slots = NonNullList.m_122780_((int)tier.slots, (Object)PSUSlot.EMPTY);
        for (int i = 0; i < oldStacks.size(); ++i) {
            this.slots.set(i, (Object)((PSUSlot)oldStacks.get(i)));
        }
        this.slotCount = tier.slots;
        this.slotCapacity = tier.capacity;
    }

    public ItemStack insertItemSlotless(@Nonnull ItemStack stack, boolean allowEmpty, boolean allowVoid) {
        if (stack.m_41619_() || stack.m_41782_()) {
            return ItemStack.f_41583_;
        }
        for (PSUSlot slot : this.slots) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)slot.getStack(), (ItemStack)stack)) continue;
            int remainder = allowVoid ? 0 : Math.max(slot.getCount() + stack.m_41613_() - this.slotCapacity, 0);
            slot.setCount(Math.min(slot.getCount() + stack.m_41613_(), this.slotCapacity));
            this.onContentsChanged();
            ItemStack tmpstack = stack.m_41777_();
            stack.m_41764_(remainder);
            return tmpstack;
        }
        if (allowEmpty) {
            for (int n = 0; n < this.slots.size(); ++n) {
                if (!((PSUSlot)this.slots.get(n)).isEmpty()) continue;
                this.slots.set(n, (Object)new PSUSlot(stack));
                this.onContentsChanged();
                ItemStack tmpstack = stack.m_41777_();
                stack.m_41764_(0);
                return tmpstack;
            }
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.checkIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (((PSUSlot)this.slots.get(slot)).isEmpty()) {
            if (!simulate) {
                this.slots.set(slot, (Object)new PSUSlot(stack));
                this.onContentsChanged();
            }
            return ItemStack.f_41583_;
        }
        if (((PSUSlot)this.slots.get(slot)).checkItem(stack)) {
            if (!simulate) {
                PSUSlot tmp = (PSUSlot)this.slots.get(slot);
                tmp.incrementCount(stack.m_41613_(), this.slotCapacity);
                this.onContentsChanged();
            }
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.checkIndex(slot);
        PSUSlot tmp = (PSUSlot)this.slots.get(slot);
        if (tmp.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack item = tmp.getStack();
        int extract = Math.min(amount, Math.min(tmp.getCount(), item.m_41741_()));
        item.m_41764_(extract);
        if (tmp.getCount() <= extract) {
            if (!simulate) {
                this.slots.set(slot, (Object)PSUSlot.EMPTY);
                this.onContentsChanged();
            }
        } else if (!simulate) {
            tmp.decrementCount(extract);
            this.onContentsChanged();
        }
        return item;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return !stack.m_41782_() && !(stack.m_41720_() instanceof PocketStorageUnit);
    }

    private void onContentsChanged() {
        StorageManager.get().m_77762_();
    }

    public CompoundTag serializeNBT() {
        ListTag tagList = new ListTag();
        for (PSUSlot slot : this.slots) {
            if (!slot.isEmpty()) {
                tagList.add((Object)slot.writeNBT());
                continue;
            }
            CompoundTag tmp = new CompoundTag();
            tmp.m_128359_("Item", "");
            tmp.m_128405_("Count", 0);
            tagList.add((Object)tmp);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Slots", (Tag)tagList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("Slots")) {
            ListTag tagList = nbt.m_128437_("Slots", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTag = tagList.m_128728_(i);
                if (i >= this.slots.size()) continue;
                PSUSlot tmp = new PSUSlot(itemTag);
                this.slots.set(i, (Object)tmp);
            }
        }
    }
}

