/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.crafting;

import com.flanks255.psu.PocketStorage;
import com.flanks255.psu.crafting.TargetNBTIngredient;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class CopyDataRecipe
extends ShapedRecipe {
    public CopyDataRecipe(ResourceLocation id, String group, int recipeWidth, int recipeHeight, NonNullList<Ingredient> ingredients, ItemStack recipeOutput) {
        super(id, group, recipeWidth, recipeHeight, ingredients, recipeOutput);
    }

    public CopyDataRecipe(ShapedRecipe shapedRecipe) {
        super(shapedRecipe.m_6423_(), shapedRecipe.m_6076_(), shapedRecipe.getRecipeWidth(), shapedRecipe.getRecipeHeight(), shapedRecipe.m_7527_(), shapedRecipe.m_8043_());
    }

    public ItemStack m_5874_(@Nonnull CraftingContainer inv) {
        ItemStack craftingResult = super.m_5874_(inv);
        TargetNBTIngredient donorIngredient = null;
        ItemStack dataSource = ItemStack.f_41583_;
        NonNullList ingredients = this.m_7527_();
        for (Ingredient ingredient : ingredients) {
            if (!(ingredient instanceof TargetNBTIngredient)) continue;
            donorIngredient = (TargetNBTIngredient)ingredient;
            break;
        }
        if (!craftingResult.m_41619_()) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack item = inv.m_8020_(i);
                if (item.m_41619_() || !donorIngredient.test(item)) continue;
                dataSource = item;
                break;
            }
            if (!dataSource.m_41619_() && dataSource.m_41782_()) {
                craftingResult.m_41751_(dataSource.m_41783_().m_6426_());
            }
        }
        return craftingResult;
    }

    public static class Serializer
    implements RecipeSerializer<CopyDataRecipe> {
        @Nullable
        public CopyDataRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new CopyDataRecipe((ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer));
        }

        public CopyDataRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            try {
                return new CopyDataRecipe((ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json));
            }
            catch (Exception exception) {
                PocketStorage.LOGGER.info("Error reading CopyData Recipe from packet: ", (Throwable)exception);
                throw exception;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, CopyDataRecipe recipe) {
            try {
                RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe);
            }
            catch (Exception exception) {
                PocketStorage.LOGGER.info("Error writing CopyData Recipe to packet: ", (Throwable)exception);
                throw exception;
            }
        }
    }
}

