/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.data;

import com.lothrazar.simpletomb.helper.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class LocationBlockPos {
    public int x;
    public int y;
    public int z;
    public String dim;
    public static final LocationBlockPos ORIGIN = new LocationBlockPos(0, 0, 0, "");

    public LocationBlockPos(BlockPos pos, Level level) {
        this(pos, WorldHelper.dimensionToString(level));
    }

    public LocationBlockPos(BlockPos pos, String dim) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), dim);
    }

    public LocationBlockPos(int x, int y, int z, String dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public LocationBlockPos(Entity entity) {
        this(entity.m_20183_(), entity.f_19853_);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean equals(LocationBlockPos loc) {
        return loc.x == this.x && loc.y == this.y && loc.z == this.z && loc.dim.equalsIgnoreCase(this.dim);
    }

    public boolean isOrigin() {
        return this.equals(ORIGIN);
    }

    public double getDistance(BlockPos pos) {
        double deltX = this.x - pos.m_123341_();
        double deltY = this.y - pos.m_123342_();
        double deltZ = this.z - pos.m_123343_();
        return Math.sqrt(deltX * deltX + deltY * deltY + deltZ * deltZ);
    }

    public String toString() {
        return String.format("%s (%d, %d, %d)", this.dim, this.x, this.y, this.z);
    }
}

