/*
 * Decompiled with CFR 0.152.
 */
package de.sarenor.arsinstrumentum.network;

import de.sarenor.arsinstrumentum.items.curios.armarium.WizardsArmarium;
import de.sarenor.arsinstrumentum.setup.Registration;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class WizardsArmariumChoiceMessage {
    private final int choosenSlot;

    public WizardsArmariumChoiceMessage(FriendlyByteBuf buf) {
        this.choosenSlot = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.choosenSlot);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && CuriosApi.getCuriosHelper().findEquippedCurio((Item)Registration.WIZARDS_ARMARIUM.get(), (LivingEntity)player).isPresent()) {
                WizardsArmarium.handleArmariumChoice(player, this.choosenSlot, ctx);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public WizardsArmariumChoiceMessage(int choosenSlot) {
        this.choosenSlot = choosenSlot;
    }

    public int getChoosenSlot() {
        return this.choosenSlot;
    }
}

