/*
 * Decompiled with CFR 0.152.
 */
package de.sarenor.arsinstrumentum.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import de.sarenor.arsinstrumentum.datagen.ApparatusRecipeBuilder;
import de.sarenor.arsinstrumentum.setup.Registration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApparatusRecipes
extends ApparatusRecipeProvider {
    private static final Logger log = LogManager.getLogger(ApparatusRecipes.class);
    private final DataGenerator generator;
    List<EnchantingApparatusRecipe> recipes = new ArrayList<EnchantingApparatusRecipe>();

    public ApparatusRecipes(DataGenerator generatorIn) {
        super(generatorIn);
        this.generator = generatorIn;
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_instrumentum/recipes/apparatus/" + str + ".json");
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        log.info("ArsInstrumentum: Recipe-Generation started");
        this.addEntries();
        Path output = this.generator.m_123916_();
        for (IEnchantingRecipe iEnchantingRecipe : this.recipes) {
            if (!(iEnchantingRecipe instanceof EnchantingApparatusRecipe)) continue;
            EnchantingApparatusRecipe apparatusRecipe = (EnchantingApparatusRecipe)iEnchantingRecipe;
            System.out.println(iEnchantingRecipe);
            Path path = ApparatusRecipes.getRecipePath(output, apparatusRecipe.m_6423_().m_135815_());
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)apparatusRecipe.asRecipe(), (Path)path);
        }
        log.info("ArsInstrumentum: Recipe-Generation ended");
    }

    public void addEntries() {
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)Registration.WIZARDS_ARMARIUM.get()).withReagent((ItemLike)ItemsRegistry.MUNDANE_BELT).withPedestalItem(4, (ItemLike)ItemsRegistry.BLAZE_FIBER).withPedestalItem(2, (ItemLike)Items.f_42415_).withPedestalItem((ItemLike)Items.f_42108_).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.ARCHMAGE_HOOD).withReagent((ItemLike)ItemsRegistry.APPRENTICE_HOOD).withPedestalItem(1, (ItemLike)Items.f_42472_).keepNbtOfReagent(true).withId(new ResourceLocation("ars_instrumentum", "archmage_hood_from_apprentice")).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.ARCHMAGE_ROBES).withReagent((ItemLike)ItemsRegistry.APPRENTICE_ROBES).withPedestalItem(1, (ItemLike)Items.f_42473_).keepNbtOfReagent(true).withId(new ResourceLocation("ars_instrumentum", "archmage_robes_from_apprentice")).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.ARCHMAGE_LEGGINGS).withReagent((ItemLike)ItemsRegistry.APPRENTICE_LEGGINGS).withPedestalItem(1, (ItemLike)Items.f_42474_).withId(new ResourceLocation("ars_instrumentum", "archmage_leggings_from_apprentice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.ARCHMAGE_BOOTS).withReagent((ItemLike)ItemsRegistry.APPRENTICE_BOOTS).withPedestalItem(1, (ItemLike)Items.f_42475_).keepNbtOfReagent(true).withId(new ResourceLocation("ars_instrumentum", "archmage_boots_from_apprentice")).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.ARCHMAGE_HOOD).withReagent((ItemLike)ItemsRegistry.NOVICE_HOOD).withPedestalItem(1, (ItemLike)Items.f_42472_).withId(new ResourceLocation("ars_instrumentum", "archmage_hood_from_novice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.ARCHMAGE_ROBES).withReagent((ItemLike)ItemsRegistry.NOVICE_ROBES).withPedestalItem(1, (ItemLike)Items.f_42473_).withId(new ResourceLocation("ars_instrumentum", "archmage_robes_from_novice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.ARCHMAGE_LEGGINGS).withReagent((ItemLike)ItemsRegistry.NOVICE_LEGGINGS).withPedestalItem(1, (ItemLike)Items.f_42474_).withId(new ResourceLocation("ars_instrumentum", "archmage_leggings_from_novice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.ARCHMAGE_BOOTS).withReagent((ItemLike)ItemsRegistry.NOVICE_BOOTS).withPedestalItem(1, (ItemLike)Items.f_42475_).withId(new ResourceLocation("ars_instrumentum", "archmage_boots_from_novice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.APPRENTICE_HOOD).withReagent((ItemLike)ItemsRegistry.NOVICE_HOOD).withPedestalItem(1, (ItemLike)Items.f_42468_).withId(new ResourceLocation("ars_instrumentum", "apprentice_hood_from_novice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.APPRENTICE_ROBES).withReagent((ItemLike)ItemsRegistry.NOVICE_ROBES).withPedestalItem(1, (ItemLike)Items.f_42469_).withId(new ResourceLocation("ars_instrumentum", "apprentice_robes_from_novice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.APPRENTICE_LEGGINGS).withReagent((ItemLike)ItemsRegistry.NOVICE_LEGGINGS).withPedestalItem(1, (ItemLike)Items.f_42470_).withId(new ResourceLocation("ars_instrumentum", "apprentice_leggings_from_novice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.APPRENTICE_BOOTS).withReagent((ItemLike)ItemsRegistry.NOVICE_BOOTS).withPedestalItem(1, (ItemLike)Items.f_42471_).withId(new ResourceLocation("ars_instrumentum", "apprentice_boots_from_novice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.APPRENTICE_HOOD).withReagent((ItemLike)ItemsRegistry.ARCHMAGE_HOOD).withPedestalItem(1, (ItemLike)Items.f_42468_).withId(new ResourceLocation("ars_instrumentum", "apprentice_hood_from_archmage")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.APPRENTICE_ROBES).withReagent((ItemLike)ItemsRegistry.ARCHMAGE_ROBES).withPedestalItem(1, (ItemLike)Items.f_42469_).withId(new ResourceLocation("ars_instrumentum", "apprentice_robes_from_archmage")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.APPRENTICE_LEGGINGS).withReagent((ItemLike)ItemsRegistry.ARCHMAGE_LEGGINGS).withPedestalItem(1, (ItemLike)Items.f_42470_).withId(new ResourceLocation("ars_instrumentum", "apprentice_leggings_from_archmage")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.APPRENTICE_BOOTS).withReagent((ItemLike)ItemsRegistry.ARCHMAGE_BOOTS).withPedestalItem(1, (ItemLike)Items.f_42471_).withId(new ResourceLocation("ars_instrumentum", "apprentice_boots_from_archmage")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.NOVICE_HOOD).withReagent((ItemLike)ItemsRegistry.APPRENTICE_HOOD).withPedestalItem(1, (ItemLike)Items.f_42476_).withId(new ResourceLocation("ars_instrumentum", "novice_hood_from_apprentice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.NOVICE_ROBES).withReagent((ItemLike)ItemsRegistry.APPRENTICE_ROBES).withPedestalItem(1, (ItemLike)Items.f_42477_).withId(new ResourceLocation("ars_instrumentum", "novice_robes_from_apprentice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.NOVICE_LEGGINGS).withReagent((ItemLike)ItemsRegistry.APPRENTICE_LEGGINGS).withPedestalItem(1, (ItemLike)Items.f_42478_).withId(new ResourceLocation("ars_instrumentum", "novice_leggings_from_apprentice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.NOVICE_BOOTS).withReagent((ItemLike)ItemsRegistry.APPRENTICE_BOOTS).withPedestalItem(1, (ItemLike)Items.f_42479_).withId(new ResourceLocation("ars_instrumentum", "novice_boots_from_apprentice")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.NOVICE_HOOD).withReagent((ItemLike)ItemsRegistry.ARCHMAGE_HOOD).withPedestalItem(1, (ItemLike)Items.f_42476_).withId(new ResourceLocation("ars_instrumentum", "novice_hood_from_archmage")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.NOVICE_ROBES).withReagent((ItemLike)ItemsRegistry.ARCHMAGE_ROBES).withPedestalItem(1, (ItemLike)Items.f_42477_).withId(new ResourceLocation("ars_instrumentum", "novice_robes_from_archmage")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.NOVICE_LEGGINGS).withReagent((ItemLike)ItemsRegistry.ARCHMAGE_LEGGINGS).withPedestalItem(1, (ItemLike)Items.f_42478_).withId(new ResourceLocation("ars_instrumentum", "novice_leggings_from_archmage")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)ItemsRegistry.NOVICE_BOOTS).withReagent((ItemLike)ItemsRegistry.ARCHMAGE_BOOTS).withPedestalItem(1, (ItemLike)Items.f_42479_).withId(new ResourceLocation("ars_instrumentum", "novice_boots_from_archmage")).keepNbtOfReagent(true).build());
        this.recipes.add(ApparatusRecipeBuilder.builder().withResult((ItemLike)Registration.NUMERIC_CHARM.get()).withReagent((ItemLike)ItemsRegistry.DULL_TRINKET).withPedestalItem(2, Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD)).withPedestalItem(1, (ItemLike)Items.f_42415_).withPedestalItem((ItemLike)Items.f_42532_).withPedestalItem((ItemLike)Items.f_42516_).build());
    }

    public String m_6055_() {
        return "ArsInstrumentumApparatus";
    }
}

