/*
 * Decompiled with CFR 0.152.
 */
package de.sarenor.arsinstrumentum.client;

import com.hollingsworth.arsnouveau.api.client.IDisplayMana;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.sarenor.arsinstrumentum.items.curios.NumericCharm;
import de.sarenor.arsinstrumentum.setup.ArsInstrumentumConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ars_instrumentum", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NumericManaHUD
extends GuiComponent {
    private static final Minecraft minecraft = Minecraft.m_91087_();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderSpellHUD(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player = NumericManaHUD.minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (NumericCharm.hasCharm((Player)player) || Boolean.TRUE.equals(ArsInstrumentumConfig.Client.SHOW_MANA_NUM.get())) {
            NumericManaHUD.drawHUD(event.getPoseStack(), (Player)player);
        }
    }

    public static boolean shouldDisplayBar() {
        IDisplayMana item2;
        IDisplayMana item;
        if (NumericManaHUD.minecraft.f_91074_ == null) {
            return false;
        }
        ItemStack mainHand = NumericManaHUD.minecraft.f_91074_.m_21205_();
        ItemStack offHand = NumericManaHUD.minecraft.f_91074_.m_21206_();
        Item item3 = mainHand.m_41720_();
        return item3 instanceof IDisplayMana && (item = (IDisplayMana)item3).shouldDisplay(mainHand) || (item3 = offHand.m_41720_()) instanceof IDisplayMana && (item2 = (IDisplayMana)item3).shouldDisplay(offHand);
    }

    private static void drawHUD(PoseStack ms, Player player) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)player).orElse(null);
        if (!NumericManaHUD.shouldDisplayBar() || mana == null) {
            return;
        }
        boolean renderOnTop = (Boolean)ArsInstrumentumConfig.Client.SHOW_MANA_ON_TOP.get();
        int offsetLeft = 10;
        int height = minecraft.m_91268_().m_85446_() - 15;
        int max = mana.getMaxMana();
        int current = (int)mana.getCurrentMana();
        String delimiter = renderOnTop ? "/" : "   /   ";
        String textMax = max + delimiter + max;
        String text = current + delimiter + max;
        int maxWidth = NumericManaHUD.minecraft.f_91062_.m_92895_(textMax);
        if (renderOnTop) {
            height -= 25;
        } else {
            offsetLeft = 67 - maxWidth / 2;
        }
        NumericManaHUD.m_93236_((PoseStack)ms, (Font)NumericManaHUD.minecraft.f_91062_, (String)text, (int)(offsetLeft += maxWidth - NumericManaHUD.minecraft.f_91062_.m_92895_(text)), (int)height, (int)0xFFFFFF);
        if (!renderOnTop) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("ars_nouveau", "textures/gui/manabar_gui_border.png"));
            NumericManaHUD.m_93133_((PoseStack)ms, (int)10, (int)(height - 8), (float)0.0f, (float)18.0f, (int)108, (int)20, (int)256, (int)256);
        }
    }
}

