/*
 * Decompiled with CFR 0.152.
 */
package de.sarenor.arsinstrumentum.blocks;

import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.BasicSpellTurretTile;
import com.hollingsworth.arsnouveau.common.block.tile.RelayTile;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import de.sarenor.arsinstrumentum.blocks.tiles.ArcaneApplicatorTile;
import de.sarenor.arsinstrumentum.items.CopyPasteSpellScroll;
import de.sarenor.arsinstrumentum.items.RunicStorageStone;
import de.sarenor.arsinstrumentum.items.ScrollOfSaveStarbuncle;
import de.sarenor.arsinstrumentum.utils.BlockPosUtils;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ArcaneApplicator
extends TickableModBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final String ARCANE_APPLICATOR_ID = "arcane_applicator";
    public static final VoxelShape SHAPE_POST = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final VoxelShape SHAPE_TOP_PLATE = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final VoxelShape SHAPE_COLLISION = Shapes.m_83110_((VoxelShape)SHAPE_POST, (VoxelShape)SHAPE_TOP_PLATE);
    public static final VoxelShape SHAPE_WEST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)10.0, (double)0.0, (double)5.333333, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.333333, (double)12.0, (double)0.0, (double)9.666667, (double)16.0, (double)16.0), Block.m_49796_((double)9.666667, (double)14.0, (double)0.0, (double)14.0, (double)18.0, (double)16.0), SHAPE_POST});
    public static final VoxelShape SHAPE_NORTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)10.0, (double)1.0, (double)16.0, (double)14.0, (double)5.333333), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)12.0, (double)5.333333, (double)16.0, (double)16.0, (double)9.666667), Block.m_49796_((double)0.0, (double)14.0, (double)9.666667, (double)16.0, (double)18.0, (double)14.0), SHAPE_POST});
    public static final VoxelShape SHAPE_EAST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)10.666667, (double)10.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.333333, (double)12.0, (double)0.0, (double)10.666667, (double)16.0, (double)16.0), Block.m_49796_((double)2.0, (double)14.0, (double)0.0, (double)6.333333, (double)18.0, (double)16.0), SHAPE_POST});
    public static final VoxelShape SHAPE_SOUTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)10.0, (double)10.666667, (double)16.0, (double)14.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)12.0, (double)6.333333, (double)16.0, (double)16.0, (double)10.666667), Block.m_49796_((double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)18.0, (double)6.333333), SHAPE_POST});

    public ArcaneApplicator() {
        super(ArcaneApplicator.defaultProperties().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TRIGGERED, (Comparable)Boolean.FALSE));
    }

    public static BlockBehaviour.Properties defaultProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 6.0f);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_POST;
        };
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_COLLISION;
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    private void handleApplicationSignal(ItemStack itemStack, ServerLevel serverLevel, BlockPos blockPos) {
        if (itemStack.m_41720_() instanceof ScrollOfSaveStarbuncle) {
            this.handleStarbuncleApply(itemStack, serverLevel, blockPos);
        } else if (itemStack.m_41720_() instanceof RunicStorageStone) {
            this.handleRelayApply(itemStack, serverLevel, blockPos);
        } else if (itemStack.m_41720_() instanceof CopyPasteSpellScroll || itemStack.m_41720_() instanceof SpellParchment) {
            this.handleSpellturretApply(itemStack, serverLevel, blockPos);
        }
    }

    private void handleStarbuncleApply(ItemStack itemStack, ServerLevel serverLevel, BlockPos blockPos) {
        serverLevel.m_45976_(Starbuncle.class, new AABB(blockPos.m_122013_(10).m_122025_(10).m_6625_(6), blockPos.m_122020_(10).m_122030_(10).m_6630_(6))).stream().filter(starbuncle -> BlockPosUtils.isNeighbour(blockPos, starbuncle.data.bedPos)).forEach(starbuncle -> ScrollOfSaveStarbuncle.apply(itemStack, starbuncle, null));
    }

    private void handleRelayApply(ItemStack itemStack, ServerLevel serverLevel, BlockPos blockPos) {
        StreamSupport.stream(BlockPosUtils.getNeighbours(blockPos).spliterator(), false).map(arg_0 -> ((ServerLevel)serverLevel).m_7702_(arg_0)).filter(blockEntity -> blockEntity instanceof RelayTile).forEach(blockEntity -> RunicStorageStone.apply(itemStack, (RelayTile)blockEntity, null));
    }

    private void handleSpellturretApply(ItemStack itemStack, ServerLevel serverLevel, BlockPos blockPos) {
        SpellCaster copyPasteSpellcaster = new SpellCaster(itemStack);
        StreamSupport.stream(BlockPosUtils.getNeighbours(blockPos).spliterator(), false).map(arg_0 -> ((ServerLevel)serverLevel).m_7702_(arg_0)).filter(blockEntity -> blockEntity instanceof BasicSpellTurretTile).forEach(arg_0 -> ArcaneApplicator.lambda$handleSpellturretApply$5((ISpellCaster)copyPasteSpellcaster, arg_0));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean neighborSignal = worldIn.m_46753_(pos) || worldIn.m_46753_(pos.m_7494_());
        boolean isTriggered = (Boolean)state.m_61143_((Property)TRIGGERED);
        if (neighborSignal && !isTriggered) {
            worldIn.m_186460_(pos, (Block)this, 4);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.TRUE), 4);
        } else if (!neighborSignal && isTriggered) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.FALSE), 4);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (handIn != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof ArcaneApplicatorTile) {
            ArcaneApplicatorTile tile = (ArcaneApplicatorTile)blockEntity;
            if (tile.getStack() != null && player.m_21120_(handIn).m_41619_()) {
                if (world.m_8055_(pos.m_7494_()).m_60767_() != Material.f_76296_) {
                    return InteractionResult.SUCCESS;
                }
                item = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), tile.getStack());
                world.m_7967_((Entity)item);
                tile.setStack(ItemStack.f_41583_);
            } else if (!player.m_150109_().m_36056_().m_41619_() && this.isHoldableItem(player.m_150109_().m_36056_())) {
                if (tile.getStack() != null) {
                    item = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), tile.getStack());
                    world.m_7967_((Entity)item);
                }
                tile.setStack(player.m_150109_().m_7407_(player.m_150109_().f_35977_, 1));
            }
            world.m_7260_(pos, state, state, 2);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean isHoldableItem(ItemStack itemStack) {
        Item placedItem = itemStack.m_41720_();
        return placedItem instanceof SpellParchment || placedItem instanceof CopyPasteSpellScroll || placedItem instanceof RunicStorageStone || placedItem instanceof ScrollOfSaveStarbuncle;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        ArcaneApplicatorTile tile;
        super.m_5707_(worldIn, pos, state, player);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof ArcaneApplicatorTile && (tile = (ArcaneApplicatorTile)blockEntity).getStack() != null) {
            worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), tile.getStack()));
        }
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        this.getApplicableStack(serverLevel, blockPos).ifPresent(itemStack -> this.handleApplicationSignal((ItemStack)itemStack, serverLevel, blockPos));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ArcaneApplicatorTile(blockPos, blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61360_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Nonnull
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public boolean m_7278_(BlockState state) {
        return false;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)worldIn.m_7702_(pos));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    private Optional<ItemStack> getApplicableStack(ServerLevel serverLevel, BlockPos blockPos) {
        ArcaneApplicatorTile tile;
        BlockEntity blockEntity;
        if (!serverLevel.f_46443_ && (blockEntity = serverLevel.m_7702_(blockPos)) instanceof ArcaneApplicatorTile && (tile = (ArcaneApplicatorTile)blockEntity).getStack() != null) {
            return Optional.of(tile.getStack());
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$handleSpellturretApply$5(ISpellCaster copyPasteSpellcaster, BlockEntity blockEntity) {
        ((BasicSpellTurretTile)blockEntity).spellCaster.setSpell(copyPasteSpellcaster.getSpell());
        ((BasicSpellTurretTile)blockEntity).spellCaster.setColor(copyPasteSpellcaster.getColor());
        ((BasicSpellTurretTile)blockEntity).spellCaster.setSpellName(copyPasteSpellcaster.getSpellName());
    }
}

