/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.client.util;

import dev.itsmeow.whisperwoods.imdlib.client.render.ImplRenderer;
import dev.itsmeow.whisperwoods.imdlib.mixin.EntityRenderersInvoker;
import dev.itsmeow.whisperwoods.imdlib.util.SafePlatform;
import dev.itsmeow.whisperwoods.imdlib.util.config.CommonConfigAPI;
import dev.itsmeow.whisperwoods.imdlib.util.config.ConfigBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;

public class ModelReplacementHandler {
    public static ModelReplacementHandler INSTANCE = null;
    public final Logger LOG = LogManager.getLogger();
    public final String parent_modid;
    protected Map<Pair<String, String>, Supplier<Supplier<ReplaceDefinition<?>>>> replaceDefs = new HashMap();
    protected ReplacementConfig config;

    public ModelReplacementHandler(String modid) {
        this.parent_modid = modid;
        INSTANCE = this;
    }

    public ReplacementConfig getConfig(ConfigBuilder builder) {
        return this.getConfig(builder, (TriConsumer<ConfigBuilder, String, Map<String, Supplier<Boolean>>>)((TriConsumer)(a, b, c) -> {}));
    }

    public ReplacementConfig getConfig(ConfigBuilder builder, TriConsumer<ConfigBuilder, String, Map<String, Supplier<Boolean>>> manuals) {
        this.config = new ReplacementConfig(this, builder, manuals);
        return this.config;
    }

    public void addReplace(String modid, String name, Supplier<Supplier<ReplaceDefinition<?>>> definition) {
        this.replaceDefs.put((Pair<String, String>)Pair.of((Object)modid, (Object)name), definition);
        this.LOG.debug(String.format("[%s] Registering replace for %s from %s", this.parent_modid, name, modid));
    }

    public boolean getEnabledAndLoaded(String mod, String override) {
        Map<String, Supplier<Boolean>> overrides = this.config.replace_config.getModsMap().get(mod);
        if (overrides == null) {
            return false;
        }
        return overrides.containsKey(override) ? overrides.get(override).get() : false;
    }

    public void initComplete() {
        CommonConfigAPI.loadClientReplace();
        this.overwriteRenders();
    }

    public void overwriteRenders() {
        this.replaceDefs.forEach((pair, definitionSupplier) -> {
            boolean doReplace = this.getEnabledAndLoaded((String)pair.getLeft(), (String)pair.getRight());
            if (SafePlatform.isModLoaded((String)pair.getLeft())) {
                ReplaceDefinition def = (ReplaceDefinition)((Supplier)definitionSupplier.get()).get();
                if (doReplace) {
                    EntityRenderersInvoker.invokeRegister(def.type, def.factory);
                    this.LOG.debug(String.format("[%s] Overriding %s / %s in %s", this.parent_modid, pair.getRight(), def.type.m_20676_(), pair.getLeft()));
                } else {
                    this.LOG.debug(String.format("[%s] Was going to override %s / %s in %s, but it is disabled!", this.parent_modid, pair.getRight(), def.type.m_20676_(), pair.getLeft()));
                }
            } else {
                this.LOG.debug(String.format("[%s] %s was not replaced, because %s is not loaded! Config %s", this.parent_modid, pair.getRight(), pair.getLeft(), doReplace));
            }
        });
    }

    public <T extends Mob, A extends EntityModel<T>> ReplaceDefinition<T> lambdaReplace(EntityType<T> type, float shadowSize, ImplRenderer.RenderDef<T, A> renderDef) {
        return new ReplaceDefinition<T>(type, renderDef.apply(ImplRenderer.factory(this.parent_modid, shadowSize)).done());
    }

    public static class ReplacementConfig {
        public OverridesConfiguration replace_config;

        public ReplacementConfig(ModelReplacementHandler parent, ConfigBuilder builder, TriConsumer<ConfigBuilder, String, Map<String, Supplier<Boolean>>> manuals) {
            HashMap replaceMap = new HashMap();
            for (Pair<String, String> pair : parent.replaceDefs.keySet()) {
                replaceMap.putIfAbsent((String)pair.getLeft(), new HashMap());
                ((Map)replaceMap.get(pair.getLeft())).put((String)pair.getRight(), parent.replaceDefs.get(pair));
            }
            HashMap<String, Map<String, Supplier<Boolean>>> map = new HashMap<String, Map<String, Supplier<Boolean>>>();
            for (String modid : replaceMap.keySet()) {
                map.putIfAbsent(modid, new HashMap());
                builder.push(modid);
                for (String name : ((Map)replaceMap.get(modid)).keySet()) {
                    ReplacementConfig.addConfig(builder, map, modid, name);
                }
                manuals.accept((Object)builder, (Object)modid, (Object)((Map)map.get(modid)));
                builder.pop();
            }
            this.replace_config = new OverridesConfiguration(map);
        }

        public static void addConfig(ConfigBuilder builder, Map<String, Map<String, Supplier<Boolean>>> map, String modid, String name) {
            map.get(modid).put(name, builder.define("replace_" + name, true));
        }

        public static class OverridesConfiguration {
            public final Map<String, Map<String, Supplier<Boolean>>> mods;

            public OverridesConfiguration(Map<String, Map<String, Supplier<Boolean>>> mods) {
                this.mods = mods;
            }

            public Map<String, Map<String, Supplier<Boolean>>> getModsMap() {
                return this.mods;
            }
        }
    }

    public record ReplaceDefinition<T extends LivingEntity>(EntityType<T> type, EntityRendererProvider<T> factory) {
    }
}

