/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import dev.itsmeow.whisperwoods.entity.EntityAnimalWithTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.util.variant.IVariant;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public abstract class EntityAnimalWithTypesAndSize
extends EntityAnimalWithTypes {
    protected static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(EntityAnimalWithTypesAndSize.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public EntityAnimalWithTypesAndSize(EntityType<? extends EntityAnimalWithTypes> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.setSize(0.35f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
    }

    public EntityDimensions m_6972_(Pose pose) {
        float size = ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
        return EntityDimensions.m_20395_((float)size, (float)size).m_20388_(this.m_6134_());
    }

    public void setSize(float size) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Size", this.m_6972_((Pose)Pose.STANDING).f_20377_);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        float size = compound.m_128457_("Size");
        this.setSize(size);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, CompoundTag compound) {
        livingdata = super.m_6518_(world, difficulty, reason, (SpawnGroupData)livingdata, compound);
        if (!this.m_6162_()) {
            IVariant i = this.getRandomType();
            float rand = this.getRandomizedSize();
            if (livingdata instanceof AgeableSizeTypeData) {
                i = ((AgeableSizeTypeData)((Object)livingdata)).typeData;
                rand = ((AgeableSizeTypeData)((Object)livingdata)).size;
            } else {
                livingdata = new AgeableSizeTypeData(i, rand);
            }
            this.setType(i);
            this.setSize(rand);
        }
        return livingdata;
    }

    protected abstract float getRandomizedSize();

    public static class AgeableSizeTypeData
    extends IVariantTypes.AgeableTypeData {
        public float size;

        public AgeableSizeTypeData(IVariant type, float size) {
            super(type);
            this.size = size;
        }
    }
}

