/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.workbench.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.dimlets.items.DimletItem;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.rftoolsdim.modules.essences.blocks.BiomeAbsorberTileEntity;
import mcjty.rftoolsdim.modules.essences.blocks.BlockAbsorberTileEntity;
import mcjty.rftoolsdim.modules.essences.blocks.FluidAbsorberTileEntity;
import mcjty.rftoolsdim.modules.essences.blocks.StructureAbsorberTileEntity;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeKey;
import mcjty.rftoolsdim.modules.knowledge.items.LostKnowledgeItem;
import mcjty.rftoolsdim.modules.workbench.WorkbenchConfig;
import mcjty.rftoolsdim.modules.workbench.WorkbenchModule;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class ResearcherTileEntity
extends TickingTileEntity {
    public static final int SLOT_IN = 0;
    public static final int SLOT_OUT = 1;
    @GuiValue
    private int progress;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific(ResearcherTileEntity::isResearchable).in(), 0, 64, 24).slot(SlotDefinition.generic().out(), 1, 118, 24).playerSlots(10, 70));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)WorkbenchConfig.RESEARCHER_MAXENERGY.get()).intValue(), (long)((Integer)WorkbenchConfig.RESEARCHER_ENERGY_INPUT_PERTICK.get()).intValue());
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> ResearcherTileEntity.isResearchable(stack)).insertable(GenericItemHandler.slot((int)0)).onUpdate((slot, stack) -> {
        if (slot == 0) {
            this.progress = this.getMaxProgress();
        }
    }).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Knowledge Holder").containerSupplier(DefaultContainerProvider.container(WorkbenchModule.CONTAINER_RESEARCHER, CONTAINER_FACTORY, (GenericTileEntity)this)).energyHandler(() -> this.energyStorage).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    public static final VoxelShape SLAB = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);

    public ResearcherTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)WorkbenchModule.TYPE_RESEARCHER.get(), pos, state);
    }

    private static boolean isResearchable(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof LostKnowledgeItem) {
            KnowledgeKey key = LostKnowledgeItem.getKnowledgeKey(stack);
            return key == null;
        }
        if (item == EssencesModule.BLOCK_ABSORBER_ITEM.get()) {
            return true;
        }
        if (item == EssencesModule.FLUID_ABSORBER_ITEM.get()) {
            return true;
        }
        if (item == EssencesModule.BIOME_ABSORBER_ITEM.get()) {
            return true;
        }
        if (item == EssencesModule.STRUCTURE_ABSORBER_ITEM.get()) {
            return true;
        }
        if (DimletItem.isReadyDimlet(stack)) {
            DimletKey dimletKey = DimletTools.getDimletKey(stack);
            if (dimletKey == null) {
                return false;
            }
            return dimletKey.type().usesKnowledgeSystem();
        }
        return false;
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(ResearcherTileEntity::new).infusable().manualEntry(ManualHelper.create((String)"rftoolsdim:dimlets/researcher")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }

            @Nonnull
            public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
                return SLAB;
            }
        };
    }

    protected void tickServer() {
        ItemStack stack;
        if (!this.items.getStackInSlot(1).m_41619_()) {
            return;
        }
        long consume = (long)((float)((Integer)WorkbenchConfig.RESEARCHER_USE_PER_TICK.get()).intValue() / (1.0f + this.infusable.getInfusedFactor() / 3.0f));
        if (this.energyStorage.getEnergy() >= consume && !(stack = this.items.getStackInSlot(0)).m_41619_()) {
            --this.progress;
            if (this.progress <= 0) {
                this.progress = 0;
                this.research();
                this.markDirtyClient();
            }
            this.energyStorage.consumeEnergy(consume);
            this.markDirtyQuick();
        }
    }

    public void research() {
        ItemStack stack = this.items.getStackInSlot(0);
        if (!stack.m_41619_()) {
            Item item = stack.m_41720_();
            if (item instanceof LostKnowledgeItem) {
                this.researchKnowledge((LostKnowledgeItem)item);
            } else if (item == EssencesModule.BLOCK_ABSORBER_ITEM.get()) {
                this.researchBlockAbsorber(stack);
            } else if (item == EssencesModule.FLUID_ABSORBER_ITEM.get()) {
                this.researchFluidAbsorber(stack);
            } else if (item == EssencesModule.BIOME_ABSORBER_ITEM.get()) {
                this.researchBiomeAbsorber(stack);
            } else if (item == EssencesModule.STRUCTURE_ABSORBER_ITEM.get()) {
                this.researchStructureAbsorber(stack);
            } else if (DimletItem.isReadyDimlet(stack)) {
                this.researchDimlet(stack);
            }
        }
    }

    private void researchDimlet(ItemStack stack) {
        DimletKey key = DimletTools.getDimletKey(stack);
        if (key != null) {
            ItemStack researched = LostKnowledgeItem.createLostKnowledge(this.f_58857_, key);
            this.items.setStackInSlot(1, researched);
        }
        this.items.decrStackSize(0, 1);
    }

    private void researchBiomeAbsorber(ItemStack stack) {
        DimletKey key;
        String biomeId = BiomeAbsorberTileEntity.getBiome(stack);
        if (biomeId != null && !biomeId.isEmpty() && (key = DimletDictionary.get().getBiomeDimlet(biomeId)) != null) {
            int absorberProgress = BiomeAbsorberTileEntity.getProgress(stack);
            if (this.f_58857_.m_213780_().m_188503_(100) < absorberProgress) {
                ItemStack researched = LostKnowledgeItem.createLostKnowledge(this.f_58857_, key);
                this.items.setStackInSlot(1, researched);
            }
        }
        this.items.decrStackSize(0, 1);
    }

    private void researchBlockAbsorber(ItemStack stack) {
        DimletKey key;
        String blockId = BlockAbsorberTileEntity.getBlock(stack);
        if (blockId != null && !blockId.isEmpty() && (key = DimletDictionary.get().getBlockDimlet(blockId)) != null) {
            int absorberProgress = BlockAbsorberTileEntity.getProgress(stack);
            if (this.f_58857_.m_213780_().m_188503_(100) < absorberProgress) {
                ItemStack researched = LostKnowledgeItem.createLostKnowledge(this.f_58857_, key);
                this.items.setStackInSlot(1, researched);
            }
        }
        this.items.decrStackSize(0, 1);
    }

    private void researchFluidAbsorber(ItemStack stack) {
        DimletKey key;
        String fluidId = FluidAbsorberTileEntity.getFluid(stack);
        if (fluidId != null && !fluidId.isEmpty() && (key = DimletDictionary.get().getFluidDimlet(fluidId)) != null) {
            int absorberProgress = FluidAbsorberTileEntity.getProgress(stack);
            if (this.f_58857_.m_213780_().m_188503_(100) < absorberProgress) {
                ItemStack researched = LostKnowledgeItem.createLostKnowledge(this.f_58857_, key);
                this.items.setStackInSlot(1, researched);
            }
        }
        this.items.decrStackSize(0, 1);
    }

    private void researchStructureAbsorber(ItemStack stack) {
        DimletKey key;
        String structureId = StructureAbsorberTileEntity.getStructure(stack);
        if (structureId != null && !structureId.isEmpty() && (key = DimletDictionary.get().getStructureDimlet(structureId)) != null) {
            int absorberProgress = StructureAbsorberTileEntity.getProgress(stack);
            if (this.f_58857_.m_213780_().m_188503_(100) < absorberProgress) {
                ItemStack researched = LostKnowledgeItem.createLostKnowledge(this.f_58857_, key);
                this.items.setStackInSlot(1, researched);
            }
        }
        this.items.decrStackSize(0, 1);
    }

    private void researchKnowledge(LostKnowledgeItem item) {
        DimletRarity rarity = item.getRarity();
        ItemStack researched = LostKnowledgeItem.createRandomLostKnowledge(this.f_58857_, rarity, this.f_58857_.m_213780_());
        this.items.setStackInSlot(1, researched);
        if (!this.items.getStackInSlot(0).m_41619_()) {
            this.progress = this.getMaxProgress();
        }
        this.items.decrStackSize(0, 1);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressPercentage() {
        int max = this.getMaxProgress();
        return (max - this.progress) * 100 / max;
    }

    private int getMaxProgress() {
        int p = (Integer)WorkbenchConfig.RESEARCH_TIME.get();
        return (int)((float)p / (1.0f + this.infusable.getInfusedFactor()));
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.progress = tagCompound.m_128451_("progress");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        tagCompound.m_128405_("progress", this.progress);
        super.m_183515_(tagCompound);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        this.saveItemHandlerCap(tagCompound);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.loadItemHandlerCap(tagCompound);
    }
}

