/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.knowledge.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.TagTools;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.dimension.TimeType;
import mcjty.rftoolsdim.dimension.additional.SkyDimletType;
import mcjty.rftoolsdim.dimension.biomes.BiomeControllerType;
import mcjty.rftoolsdim.dimension.features.FeatureType;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import mcjty.rftoolsdim.dimension.terraintypes.TerrainType;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.knowledge.data.CommonTags;
import mcjty.rftoolsdim.modules.knowledge.data.DimletPattern;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeKey;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeSet;
import mcjty.rftoolsdim.modules.knowledge.data.RandomPatternCreator;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;

public class KnowledgeManager {
    private long worldSeed = -1L;
    private Map<KnowledgeKey, DimletPattern> patterns = null;
    private final Map<DimletRarity, List<KnowledgeKey>> knownPatterns = new HashMap<DimletRarity, List<KnowledgeKey>>();
    private final Map<KnowledgeKey, String> keyReasons = new HashMap<KnowledgeKey, String>();
    private static final KnowledgeManager INSTANCE = new KnowledgeManager();
    private final CommonTags commonTags = new CommonTags();

    public static KnowledgeManager get() {
        return INSTANCE;
    }

    public void clear() {
        this.commonTags.clear();
        this.keyReasons.clear();
        this.knownPatterns.clear();
        this.patterns = null;
        this.worldSeed = -1L;
    }

    private void resolve(long seed) {
        if (seed != this.worldSeed || this.patterns == null) {
            this.worldSeed = seed;
            this.patterns = RandomPatternCreator.createRandomPatterns(seed);
        }
    }

    public static ItemStack getPatternItem(char p) {
        return switch (p) {
            case ' ' -> ItemStack.f_41583_;
            case '*' -> new ItemStack((ItemLike)Registration.DIMENSIONAL_SHARD.get());
            case '0' -> new ItemStack((ItemLike)DimletModule.COMMON_ESSENCE.get());
            case '1' -> new ItemStack((ItemLike)DimletModule.RARE_ESSENCE.get());
            case '2' -> new ItemStack((ItemLike)DimletModule.LEGENDARY_ESSENCE.get());
            default -> ItemStack.f_41583_;
        };
    }

    public static char getPatternChar(ItemStack stack) {
        if (stack.m_41619_()) {
            return ' ';
        }
        Item item = stack.m_41720_();
        if (item == Registration.DIMENSIONAL_SHARD.get()) {
            return '*';
        }
        if (item == DimletModule.COMMON_ESSENCE.get()) {
            return '0';
        }
        if (item == DimletModule.RARE_ESSENCE.get()) {
            return '1';
        }
        if (item == DimletModule.LEGENDARY_ESSENCE.get()) {
            return '2';
        }
        return ' ';
    }

    @Nullable
    private String getKnowledgeSetReason(CommonLevelAccessor level, DimletKey key) {
        return switch (key.type()) {
            default -> throw new IncompatibleClassChangeError();
            case DimletType.TERRAIN -> null;
            case DimletType.ATTRIBUTE -> null;
            case DimletType.BIOME_CONTROLLER -> null;
            case DimletType.BIOME_CATEGORY -> null;
            case DimletType.BIOME -> this.getReasonBiome(key);
            case DimletType.STRUCTURE -> this.getReasonStructure(level, key);
            case DimletType.FEATURE -> null;
            case DimletType.SKY -> null;
            case DimletType.TIME -> null;
            case DimletType.DIGIT -> null;
            case DimletType.ADMIN -> null;
            case DimletType.BLOCK -> this.getReasonBlock(key);
            case DimletType.TAG -> new ResourceLocation(key.key()).m_135815_();
            case DimletType.FLUID -> new ResourceLocation(key.key()).m_135827_();
        };
    }

    @Nullable
    private String getReasonBiome(DimletKey key) {
        ResourceLocation rl = new ResourceLocation(key.key());
        Biome biome = (Biome)BuiltinRegistries.f_123865_.m_7745_(rl);
        if (biome != null) {
            return this.getMostImportantIsTag(rl);
        }
        return null;
    }

    @Nullable
    private String getMostImportantIsTag(ResourceLocation rl) {
        return BuiltinRegistries.f_123865_.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)rl)).m_203616_().filter(t -> t.f_203868_().m_135815_().startsWith("is_")).sorted().findFirst().map(k -> k.f_203868_().toString()).orElse(null);
    }

    @Nullable
    private String getReasonStructure(CommonLevelAccessor level, DimletKey key) {
        Structure structure = (Structure)BuiltinRegistries.f_235988_.m_7745_(new ResourceLocation(key.key()));
        if (structure != null) {
            return new ResourceLocation(key.key()).m_135815_();
        }
        return null;
    }

    @Nullable
    private String getReasonBlock(DimletKey key) {
        TagKey<Block> tagId = this.getMostCommonTagForBlock(key);
        if (tagId != null) {
            return tagId.f_203868_().m_135815_();
        }
        return null;
    }

    private KnowledgeSet getKnowledgeSet(CommonLevelAccessor level, DimletKey key) {
        return switch (key.type()) {
            default -> throw new IncompatibleClassChangeError();
            case DimletType.TERRAIN -> TerrainType.byName(key.key()).getSet();
            case DimletType.ATTRIBUTE -> AttributeType.byName(key.key()).getSet();
            case DimletType.BIOME_CONTROLLER -> BiomeControllerType.byName(key.key()).getSet();
            case DimletType.BIOME_CATEGORY -> this.getBiomeCategoryKnowledgeSet(key);
            case DimletType.BIOME -> this.getBiomeKnowledgeSet(key);
            case DimletType.STRUCTURE -> this.getStructureKnowledgeSet(level, key);
            case DimletType.FEATURE -> FeatureType.byName(key.key()).getSet();
            case DimletType.TIME -> TimeType.byName(key.key()).getSet();
            case DimletType.BLOCK -> this.getBlockKnowledgeSet(key);
            case DimletType.TAG -> this.getTagKnowledgeSet(key);
            case DimletType.SKY -> this.getSkyKnowledgeSet(key);
            case DimletType.FLUID -> this.getFluidKnowledgeSet(key);
            case DimletType.DIGIT -> KnowledgeSet.SET1;
            case DimletType.ADMIN -> KnowledgeSet.SET1;
        };
    }

    private KnowledgeSet getSkyKnowledgeSet(DimletKey key) {
        SkyDimletType skyType = SkyDimletType.byName(key.key());
        if (skyType == null) {
            return KnowledgeSet.SET1;
        }
        return skyType.getKnowledgeSet();
    }

    private KnowledgeSet getFluidKnowledgeSet(DimletKey key) {
        int i = Math.abs(new ResourceLocation(key.key()).m_135827_().hashCode());
        return KnowledgeSet.values()[i % KnowledgeSet.values().length];
    }

    private KnowledgeSet getBiomeCategoryKnowledgeSet(DimletKey key) {
        return KnowledgeSet.values()[Math.abs(key.key().hashCode()) % KnowledgeSet.values().length];
    }

    private KnowledgeSet getTagKnowledgeSet(DimletKey key) {
        ResourceLocation tagId = new ResourceLocation(key.key());
        int i = Math.abs(tagId.hashCode());
        return KnowledgeSet.values()[i % KnowledgeSet.values().length];
    }

    private KnowledgeSet getBlockKnowledgeSet(DimletKey key) {
        TagKey<Block> tagId = this.getMostCommonTagForBlock(key);
        if (tagId == null) {
            return KnowledgeSet.SET1;
        }
        int i = Math.abs(tagId.hashCode());
        return KnowledgeSet.values()[i % KnowledgeSet.values().length];
    }

    private TagKey<Block> getMostCommonTagForBlock(DimletKey key) {
        TagKey mostImportant = null;
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key.key()));
        if (block == null) {
            RFToolsDim.setup.getLogger().error("Block '" + key.key() + "' is missing!");
        } else {
            Collection tags = TagTools.getTags((Block)block);
            int maxAmount = -1;
            for (TagKey tag : tags) {
                ArrayList elements = new ArrayList();
                TagTools.getBlocksForTag((TagKey)tag).forEach(h -> elements.add((Block)h.m_203334_()));
                int size = elements.size();
                if (this.commonTags.isCommon((TagKey<Block>)tag)) {
                    size += 10;
                }
                if (size <= maxAmount) continue;
                mostImportant = tag;
                maxAmount = size;
            }
        }
        return mostImportant;
    }

    private KnowledgeSet getStructureKnowledgeSet(CommonLevelAccessor level, DimletKey key) {
        ResourceLocation id = new ResourceLocation(key.key());
        Structure structure = (Structure)BuiltinRegistries.f_235988_.m_7745_(id);
        if (structure == null) {
            if (key.key().equals("default") || key.key().equals("none")) {
                return KnowledgeSet.SET1;
            }
            RFToolsDim.setup.getLogger().error("Structure '" + key.key() + "' is missing!");
            return KnowledgeSet.SET2;
        }
        return KnowledgeSet.values()[Math.abs(id.hashCode()) % KnowledgeSet.values().length];
    }

    private KnowledgeSet getBiomeKnowledgeSet(DimletKey key) {
        ResourceLocation rl = new ResourceLocation(key.key());
        Biome biome = (Biome)BuiltinRegistries.f_123865_.m_7745_(rl);
        if (biome == null) {
            RFToolsDim.setup.getLogger().error("Biome '" + key.key() + "' is missing!");
            return KnowledgeSet.SET1;
        }
        return KnowledgeSet.values()[Math.abs(key.key().hashCode()) % KnowledgeSet.values().length];
    }

    @Nullable
    public KnowledgeKey getKnowledgeKey(CommonLevelAccessor level, long seed, DimletKey key) {
        this.resolve(seed);
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings == null) {
            return null;
        }
        KnowledgeSet set = this.getKnowledgeSet(level, key);
        return new KnowledgeKey(key.type(), settings.getRarity(), set);
    }

    @Nullable
    public DimletPattern getPattern(CommonLevelAccessor level, long seed, DimletKey key) {
        KnowledgeKey kkey = this.getKnowledgeKey(level, seed, key);
        if (kkey == null) {
            return null;
        }
        return this.patterns.get(kkey);
    }

    public String getReason(Level world, KnowledgeKey key) {
        this.getKnownPatterns(world, key.rarity());
        return this.keyReasons.get(key);
    }

    public List<KnowledgeKey> getKnownPatterns(Level world, DimletRarity rarity) {
        if (!this.knownPatterns.containsKey((Object)rarity)) {
            ArrayList<KnowledgeKey> set = new ArrayList<KnowledgeKey>();
            for (DimletKey key : DimletDictionary.get().getDimlets()) {
                ServerLevel overworld;
                KnowledgeKey kkey;
                DimletSettings settings = DimletDictionary.get().getSettings(key);
                if (settings == null || !Objects.equals((Object)settings.getRarity(), (Object)rarity) || (kkey = this.getKnowledgeKey((CommonLevelAccessor)(overworld = LevelTools.getOverworld((Level)world)), overworld.m_7328_(), key)) == null) continue;
                set.add(kkey);
                String reason = this.getKnowledgeSetReason((CommonLevelAccessor)world, key);
                if (reason == null) continue;
                this.keyReasons.put(kkey, reason);
            }
            RFToolsDim.setup.getLogger().info("Patterns for rarity " + rarity.name() + ": " + set.size());
            this.knownPatterns.put(rarity, set);
        }
        return this.knownPatterns.get((Object)rarity);
    }
}

