/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.blob.tools;

import java.util.Random;
import javax.annotation.Nullable;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.modules.blob.BlobModule;
import mcjty.rftoolsdim.modules.blob.entities.DimensionalBlobEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraftforge.common.ForgeHooks;

public class Spawner {
    public static void spawnOne(ServerLevel world, Player player, CompiledDescriptor compiledDescriptor, DimensionData data, Random random) {
        double distanceX = random.nextDouble() * 100.0 - 50.0;
        double distanceZ = random.nextDouble() * 100.0 - 50.0;
        while (distanceX < 22.0 && distanceZ < 22.0) {
            distanceX = random.nextDouble() * 100.0 - 50.0;
            distanceZ = random.nextDouble() * 100.0 - 50.0;
        }
        int x = (int)(player.m_20185_() + distanceX);
        int z = (int)(player.m_20189_() + distanceZ);
        EntityType<DimensionalBlobEntity> type = Spawner.randomBlob(compiledDescriptor, data, random);
        BlockPos pos = Spawner.getValidSpawnablePosition(random, (LevelReader)world, x, z);
        if (pos == null) {
            return;
        }
        boolean nocollisions = world.m_45772_(type.m_20585_((double)x, (double)pos.m_123342_(), (double)z));
        boolean canSpawn = true;
        if (!nocollisions || !canSpawn) {
            return;
        }
        DimensionalBlobEntity entity = (DimensionalBlobEntity)type.m_20615_((Level)world);
        entity.m_7678_(x, pos.m_123342_(), z, random.nextFloat() * 360.0f, 0.0f);
        if (ForgeHooks.canEntitySpawn((Mob)entity, (LevelAccessor)world, (double)x, (double)pos.m_123342_(), (double)z, null, (MobSpawnType)MobSpawnType.NATURAL) == -1) {
            return;
        }
        if (entity.m_5545_((LevelAccessor)world, MobSpawnType.NATURAL) && entity.m_6914_((LevelReader)world)) {
            entity.m_6518_((ServerLevelAccessor)world, world.m_6436_(entity.m_20183_()), MobSpawnType.NATURAL, null, null);
            world.m_47205_((Entity)entity);
        }
    }

    private static EntityType<DimensionalBlobEntity> randomBlob(CompiledDescriptor compiledDescriptor, DimensionData data, Random random) {
        float perTick = compiledDescriptor != null ? (float)compiledDescriptor.getActualPowerCost() : 0.0f;
        perTick = Math.min(perTick, 50000.0f);
        float rareChance = 0.1f + perTick / 150000.0f;
        if (random.nextFloat() < rareChance) {
            if (random.nextFloat() < rareChance) {
                return (EntityType)BlobModule.DIMENSIONAL_BLOB_LEGENDARY.get();
            }
            return (EntityType)BlobModule.DIMENSIONAL_BLOB_RARE.get();
        }
        return (EntityType)BlobModule.DIMENSIONAL_BLOB_COMMON.get();
    }

    @Nullable
    private static BlockPos getValidSpawnablePosition(Random random, LevelReader worldIn, int x, int z) {
        int height = worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        if (height <= 3) {
            return null;
        }
        height = random.nextInt(height - 3) + 3;
        BlockPos blockPos = new BlockPos(x, height - 1, z);
        while (!Spawner.isValidSpawnPos(worldIn, blockPos)) {
            if ((blockPos = blockPos.m_7495_()).m_123342_() > worldIn.m_141937_() + 1) continue;
            return null;
        }
        return blockPos;
    }

    private static boolean isValidSpawnPos(LevelReader world, BlockPos pos) {
        if (!world.m_8055_(pos).m_60647_((BlockGetter)world, pos, PathComputationType.LAND)) {
            return false;
        }
        return world.m_8055_(pos.m_7495_()).m_60815_();
    }
}

