/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.biomes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.dimension.biomes.BiomeControllerType;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;

public class RFTBiomeProvider
extends BiomeSource {
    public static final Codec<RFTBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(RFTBiomeProvider::getBiomeRegistry), (App)DimensionSettings.SETTINGS_CODEC.fieldOf("settings").forGetter(RFTBiomeProvider::getSettings)).apply((Applicative)instance, RFTBiomeProvider::new));
    private final List<Holder<Biome>> biomes;
    private final Set<TagKey<Biome>> biomeCategories;
    private final Map<ResourceLocation, Holder<Biome>> biomeMapping = new HashMap<ResourceLocation, Holder<Biome>>();
    private final Registry<Biome> biomeRegistry;
    private final DimensionSettings settings;
    private final MultiNoiseBiomeSource multiNoiseBiomeSource;
    private final boolean defaultBiomes;
    private Holder<Biome> biome1 = null;
    private Holder<Biome> biome2 = null;

    public RFTBiomeProvider(Registry<Biome> biomeRegistry, DimensionSettings settings) {
        super(() -> RFTBiomeProvider.getDefaultBiomes(biomeRegistry, settings));
        this.settings = settings;
        this.biomeRegistry = biomeRegistry;
        this.multiNoiseBiomeSource = MultiNoiseBiomeSource.Preset.f_187087_.m_187104_(biomeRegistry, true);
        this.biomes = this.getBiomes(biomeRegistry, settings);
        this.biomeCategories = this.getBiomeCategories(settings);
        this.defaultBiomes = this.biomes.isEmpty() && this.biomeCategories.isEmpty();
        biomeRegistry.m_123024_().forEach(this::getMappedBiome);
    }

    private static List<Holder<Biome>> getDefaultBiomes(Registry<Biome> biomeRegistry, DimensionSettings settings) {
        List<ResourceLocation> biomes = settings.getCompiledDescriptor().getBiomes();
        return biomes.stream().map(arg_0 -> biomeRegistry.m_7745_(arg_0)).map(b -> biomeRegistry.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)biomeRegistry.m_7981_(b)))).collect(Collectors.toList());
    }

    public DimensionSettings getSettings() {
        return this.settings;
    }

    private boolean isCategoryMatching(Biome biome) {
        if (this.biomeCategories.isEmpty()) {
            return true;
        }
        return this.biomeRegistry.m_7854_((Object)biome).map(key -> this.biomeRegistry.m_206081_(key).m_203616_().filter(this.biomeCategories::contains).findAny().isPresent()).orElse(false);
    }

    private Holder<Biome> getMappedBiome(Biome biome) {
        if (this.defaultBiomes) {
            return this.biomeRegistry.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)this.biomeRegistry.m_7981_((Object)biome)));
        }
        return this.biomeMapping.computeIfAbsent(this.biomeRegistry.m_7981_((Object)biome), resourceLocation -> {
            List<Holder<Biome>> biomes = this.getBiomes(this.biomeRegistry, this.settings);
            float[] minDist = new float[]{1.0E9f};
            Biome[] desired = new Biome[]{biome};
            if (biomes.isEmpty()) {
                if (!this.isCategoryMatching(desired[0])) {
                    this.biomeRegistry.m_123024_().forEach(b -> {
                        float dist;
                        if (this.isCategoryMatching((Biome)b) && (dist = this.distance((Biome)b, biome)) < minDist[0]) {
                            desired[0] = b;
                            minDist[0] = dist;
                        }
                    });
                }
            } else {
                for (Holder<Biome> b2 : biomes) {
                    float dist;
                    if (!this.biomeCategories.isEmpty() && !this.isCategoryMatching((Biome)b2.m_203334_()) || !((dist = this.distance((Biome)b2.m_203334_(), biome)) < minDist[0])) continue;
                    desired[0] = (Biome)b2.m_203334_();
                    minDist[0] = dist;
                }
            }
            return this.biomeRegistry.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)this.biomeRegistry.m_7981_((Object)desired[0])));
        });
    }

    private float distance(Biome biome1, Biome biome2) {
        Set tags1 = this.biomeRegistry.m_206081_((ResourceKey)this.biomeRegistry.m_7854_((Object)biome1).get()).m_203616_().collect(Collectors.toSet());
        Set tags2 = this.biomeRegistry.m_206081_((ResourceKey)this.biomeRegistry.m_7854_((Object)biome2).get()).m_203616_().collect(Collectors.toSet());
        tags1.removeAll(tags2);
        tags1 = this.biomeRegistry.m_206081_((ResourceKey)this.biomeRegistry.m_7854_((Object)biome1).get()).m_203616_().collect(Collectors.toSet());
        tags2.removeAll(tags1);
        float d1 = Math.max(tags1.size(), tags2.size());
        float d2 = Math.abs(biome1.m_47554_() - biome2.m_47554_());
        float d3 = Math.abs(biome1.m_47548_() - biome2.m_47548_());
        float d4 = biome1.m_47533_() == biome2.m_47533_() ? 0.0f : 1.0f;
        return d1 + d2 * d2 + d3 * d3 + d4;
    }

    private List<Holder<Biome>> getBiomes(Registry<Biome> biomeRegistry, DimensionSettings settings) {
        List<ResourceLocation> biomes = settings.getCompiledDescriptor().getBiomes();
        return biomes.stream().map(arg_0 -> biomeRegistry.m_7745_(arg_0)).map(b -> biomeRegistry.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)biomeRegistry.m_7981_(b)))).collect(Collectors.toList());
    }

    private Set<TagKey<Biome>> getBiomeCategories(DimensionSettings settings) {
        Set<TagKey<Biome>> categories = settings.getCompiledDescriptor().getBiomeCategories();
        return categories;
    }

    public Registry<Biome> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    @Nonnull
    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    @Nonnull
    public Set<Holder<Biome>> m_207840_() {
        if (this.defaultBiomes) {
            return this.multiNoiseBiomeSource.m_207840_();
        }
        return new HashSet<Holder<Biome>>(this.multiNoiseBiomeSource.m_207840_());
    }

    private void getBiome1And2() {
        if (this.biome1 == null) {
            if (this.biomes.isEmpty()) {
                List<Biome> list = this.biomeRegistry.m_123024_().filter(this::isCategoryMatching).toList();
                if (list.isEmpty()) {
                    this.biome1 = this.biome2 = this.biomeRegistry.m_206081_(Biomes.f_48202_);
                } else {
                    this.biome1 = this.biomeRegistry.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)this.biomeRegistry.m_7981_((Object)list.get(0))));
                    this.biome2 = list.size() > 1 ? this.biomeRegistry.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)this.biomeRegistry.m_7981_((Object)list.get(1)))) : this.biome1;
                }
            } else {
                this.biome1 = this.biomes.get(0);
                this.biome2 = this.biomes.size() > 1 ? this.biomes.get(1) : this.biome1;
            }
            this.biome1 = this.getMappedBiome((Biome)this.biome1.m_203334_());
            if (this.biome1 == null) {
                this.biome1 = this.biomeRegistry.m_206081_(Biomes.f_48202_);
            }
            this.biome2 = this.getMappedBiome((Biome)this.biome2.m_203334_());
            if (this.biome2 == null) {
                this.biome2 = this.biome1;
            }
        }
    }

    @Nonnull
    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler climate) {
        return switch (this.settings.getCompiledDescriptor().getBiomeControllerType()) {
            case BiomeControllerType.CHECKER -> this.getCheckerBiome(x, z);
            case BiomeControllerType.SINGLE -> this.getSingleBiome();
            default -> this.getDefaultBiome(x, y, z, climate);
        };
    }

    private Holder<Biome> getDefaultBiome(int x, int y, int z, Climate.Sampler climate) {
        if (this.defaultBiomes) {
            return this.multiNoiseBiomeSource.m_203407_(x, y, z, climate);
        }
        return this.getMappedBiome((Biome)this.multiNoiseBiomeSource.m_203407_(x, y, z, climate).m_203334_());
    }

    private Holder<Biome> getSingleBiome() {
        this.getBiome1And2();
        return this.biome1;
    }

    private Holder<Biome> getCheckerBiome(int x, int z) {
        this.getBiome1And2();
        if (((x >> 3) + (z >> 3)) % 2 == 0) {
            return this.biome1;
        }
        return this.biome2;
    }
}

